/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.mozilla;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.util.LimeWireUtils;
import org.limewire.core.impl.mozilla.LimeMozillaDownloadManagerListenerImpl;
import org.limewire.core.settings.MozillaSettings;
import org.limewire.core.settings.SharingSettings;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.interfaces.nsIDownloadManager;
import org.mozilla.interfaces.nsIPrefService;

@Singleton
public class LimeMozillaOverrides {
    private final LimeMozillaDownloadManagerListenerImpl downloadManagerListener;

    @Inject
    public LimeMozillaOverrides(LimeMozillaDownloadManagerListenerImpl downloadManagerListener) {
        this.downloadManagerListener = downloadManagerListener;
    }

    public void overrideMozillaDefaults() {
        MozillaExecutor.mozAsyncExec(new Runnable(){

            @Override
            public void run() {
                nsIPrefService prefService = XPCOMUtils.getService("@mozilla.org/preferences-service;1", nsIPrefService.class);
                prefService.getBranch("browser.download.").setBoolPref("useDownloadDir", 1);
                prefService.getBranch("browser.download.").setIntPref("folderList", 2);
                String downloadDir = SharingSettings.INCOMPLETE_DIRECTORY.get().getAbsolutePath();
                prefService.getBranch("browser.download.").setCharPref("dir", downloadDir);
                prefService.getBranch("browser.download.manager.").setBoolPref("showWhenStarting", 0);
                prefService.getBranch("browser.download.manager.").setBoolPref("showAlertOnComplete", 0);
                prefService.getBranch("general.useragent.extra.").setCharPref("firefox", LimeWireUtils.getHttpServer());
                prefService.getBranch("browser.").setBoolPref("offline", 0);
                prefService.getBranch("network.").setBoolPref("online", 1);
                prefService.getBranch("browser.helperApps.neverAsk.").setCharPref("saveToDisk", MozillaSettings.DOWNLOAD_MIME_TYPES.get());
                nsIDownloadManager downloadManager = XPCOMUtils.getServiceProxy("@mozilla.org/download-manager;1", nsIDownloadManager.class);
                LimeMozillaOverrides.this.downloadManagerListener.addMissingDownloads();
                LimeMozillaOverrides.this.downloadManagerListener.resumeDownloads();
                downloadManager.addListener(LimeMozillaOverrides.this.downloadManagerListener);
                int max = MozillaSettings.MAX_CONNECTIONS.getValue();
                prefService.getBranch("network.http.").setIntPref("max-connections", max);
                prefService.getBranch("network.http.").setIntPref("max-connections-per-server", max / 2);
            }
        });
    }
}

