/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.friend.impl;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendConnection;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.feature.LimewireFeature;
import org.limewire.inject.LazySingleton;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectionHistogram;
import org.limewire.inspection.InspectionPoint;
import org.limewire.listener.EventBean;
import org.limewire.listener.EventUtils;

@LazySingleton
public class FriendInspections {
    private EventBean<FriendConnectionEvent> connectionEventBean;

    @Inject
    public FriendInspections(EventBean<FriendConnectionEvent> connectionEventBean) {
        this.connectionEventBean = connectionEventBean;
    }

    @InspectableContainer
    private class LazyInspectableContainer {
        @InspectionPoint(value="xmpp service", category=DataCategory.USAGE)
        private final Inspectable inspectable = new Inspectable(){

            @Override
            public Object inspect() {
                FriendConnection conn = (FriendConnection)EventUtils.getSource(FriendInspections.this.connectionEventBean);
                boolean isLoggedIn = conn != null && conn.isLoggedIn();
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                map.put("loggedIn", isLoggedIn);
                if (isLoggedIn) {
                    assert (conn != null);
                    map.put("logged in service", conn.getConfiguration().getNetworkName());
                    map.put("total friends", conn.getFriends().size());
                }
                this.collectFriendStatistics(map, conn);
                return map;
            }

            private void collectFriendStatistics(Map<Object, Object> data, FriendConnection connection) {
                int count = 0;
                InspectionHistogram<Integer> presencesHistogram = new InspectionHistogram<Integer>();
                int onlineFriends = 0;
                if (connection != null) {
                    block0: for (Friend user : connection.getFriends()) {
                        if (user.isSignedIn()) {
                            ++onlineFriends;
                        }
                        Map<String, FriendPresence> presences = user.getPresences();
                        presencesHistogram.count(presences.size());
                        for (FriendPresence presence : presences.values()) {
                            if (!presence.hasFeatures(LimewireFeature.ID)) continue;
                            ++count;
                            continue block0;
                        }
                    }
                }
                data.put("limewire friends", count);
                data.put("online friends", onlineFriends);
                data.put("presences", presencesHistogram.inspect());
            }
        };

        private LazyInspectableContainer() {
        }
    }
}

