/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.ProducingNHttpEntity;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.nio.timeout.StalledUploadWatchdog;

public abstract class AbstractProducingNHttpEntity
extends AbstractHttpEntity
implements ProducingNHttpEntity {
    private StalledUploadWatchdog watchdog;
    private long timeout = StalledUploadWatchdog.DELAY_TIME;
    private boolean initialized = false;
    private final Shutdownable timeoutable = new Shutdownable(){

        @Override
        public void shutdown() {
            AbstractProducingNHttpEntity.this.timeout();
        }
    };

    protected void activateTimeout() {
        if (this.watchdog == null) {
            this.watchdog = new StalledUploadWatchdog(this.timeout, NIODispatcher.instance().getScheduledExecutorService());
        }
        this.watchdog.activate(this.timeoutable);
    }

    protected void deactivateTimeout() {
        if (this.watchdog != null) {
            this.watchdog.deactivate();
        }
    }

    @Override
    public InputStream getContent() throws IOException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract long getContentLength();

    @Override
    public boolean isRepeatable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStreaming() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        if (!this.initialized) {
            this.initialized = true;
            this.initialize(encoder, ioctrl);
        }
        if (!this.writeContent(encoder, ioctrl)) {
            encoder.complete();
        }
    }

    public abstract boolean writeContent(ContentEncoder var1, IOControl var2) throws IOException;

    public abstract void initialize(ContentEncoder var1, IOControl var2) throws IOException;

    public abstract void timeout();
}

