/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.httpclient;

import com.google.inject.Provider;
import java.net.Socket;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpParams;
import org.limewire.http.httpclient.SocketWrapperProtocolSocketFactory;
import org.limewire.service.ErrorService;

class ReapingClientConnectionManager
extends ThreadSafeClientConnManager {
    private final ScheduledFuture connectionCloserTask;
    private final IdleConnectionCloser connectionCloser = new IdleConnectionCloser();

    public ReapingClientConnectionManager(Provider<SchemeRegistry> schemeRegistry, Provider<ScheduledExecutorService> scheduler, Provider<HttpParams> defaultParams) {
        super(schemeRegistry.get());
        this.connectionCloserTask = scheduler.get().scheduleWithFixedDelay(this.connectionCloser, 0L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
        this.connectionCloser.setManagerOnce(this);
        return super.requestConnection(route, state);
    }

    @Override
    public void shutdown() {
        this.connectionCloserTask.cancel(true);
        super.shutdown();
    }

    void setSocket(Socket s) {
        SchemeRegistry registry = this.getSchemeRegistry();
        Iterator<String> i$ = registry.getSchemeNames().iterator();
        while (i$.hasNext()) {
            String o;
            String name = o = i$.next();
            Scheme scheme = registry.getScheme(name);
            ((SocketWrapperProtocolSocketFactory)scheme.getSocketFactory()).setSocket(s);
        }
    }

    private static class IdleConnectionCloser
    implements Runnable {
        private static final long IDLE_TIME = 30000L;
        private final AtomicReference<ClientConnectionManager> managerHolder = new AtomicReference();

        IdleConnectionCloser() {
        }

        void setManagerOnce(ClientConnectionManager manager) {
            this.managerHolder.compareAndSet(null, manager);
        }

        @Override
        public void run() {
            try {
                ClientConnectionManager manager = this.managerHolder.get();
                if (manager != null) {
                    manager.closeIdleConnections(30000L, TimeUnit.MILLISECONDS);
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }
}

