/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.libtorrent;

import com.sun.jna.Structure;
import org.limewire.bittorrent.TorrentState;
import org.limewire.bittorrent.TorrentStatus;
import org.limewire.libtorrent.LibTorrentState;
import org.limewire.util.StringUtils;

public class LibTorrentStatus
extends Structure
implements TorrentStatus {
    public long total_done;
    public long total_wanted_done;
    public long total_wanted;
    public long total_download;
    public long total_upload;
    public long total_payload_download;
    public long total_payload_upload;
    public long all_time_payload_download;
    public long all_time_payload_upload;
    public float download_rate;
    public float upload_rate;
    public float download_payload_rate;
    public float upload_payload_rate;
    public int num_peers;
    public int num_uploads;
    public int num_seeds;
    public int num_connections;
    public int state;
    public float progress;
    public int paused;
    public int finished;
    public int valid;
    public int auto_managed;
    public int seeding_time;
    public int active_time;
    public String error;
    public String current_tracker;
    public int num_complete;
    public int num_incomplete;
    public long total_failed_bytes;

    @Override
    public float getDownloadPayloadRate() {
        return this.download_payload_rate;
    }

    @Override
    public float getUploadPayloadRate() {
        return this.upload_payload_rate;
    }

    @Override
    public int getNumPeers() {
        return this.num_peers;
    }

    @Override
    public int getNumUploads() {
        return this.num_uploads;
    }

    @Override
    public int getNumSeeds() {
        return this.num_seeds;
    }

    @Override
    public int getNumConnections() {
        return this.num_connections;
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public long getTotalDone() {
        return this.total_done;
    }

    @Override
    public long getAllTimePayloadDownload() {
        return this.all_time_payload_download;
    }

    @Override
    public long getAllTimePayloadUpload() {
        return this.all_time_payload_upload;
    }

    @Override
    public long getTotalFailedDownload() {
        return this.total_failed_bytes;
    }

    @Override
    public boolean isPaused() {
        return this.paused != 0;
    }

    @Override
    public boolean isFinished() {
        return this.finished != 0;
    }

    @Override
    public boolean isError() {
        return !StringUtils.isEmpty(this.error);
    }

    @Override
    public String getError() {
        return this.error;
    }

    @Override
    public TorrentState getState() {
        LibTorrentState libTorrentState = LibTorrentState.forId(this.state);
        switch (libTorrentState) {
            case ALLOCATING: {
                return TorrentState.ALLOCATING;
            }
            case CHECKING_FILES: {
                return TorrentState.CHECKING_FILES;
            }
            case DOWNLOADING: {
                return TorrentState.DOWNLOADING;
            }
            case DOWNLOADING_METADATA: {
                return TorrentState.DOWNLOADING_METADATA;
            }
            case FINISHED: {
                return TorrentState.FINISHED;
            }
            case QUEUED_FOR_CHECKING: {
                return TorrentState.QUEUED_FOR_CHECKING;
            }
            case SEEDING: {
                return TorrentState.SEEDING;
            }
        }
        throw new UnsupportedOperationException("No known state for id: " + this.state + " and libtorrent state: " + (Object)((Object)libTorrentState));
    }

    @Override
    public float getSeedRatio() {
        if (this.getAllTimePayloadDownload() <= 0L || this.getAllTimePayloadUpload() <= 0L) {
            return 0.0f;
        }
        float seedRatio = (float)this.getAllTimePayloadUpload() / (float)this.getAllTimePayloadDownload();
        return seedRatio;
    }

    @Override
    public float getDownloadRate() {
        return this.download_rate;
    }

    @Override
    public float getUploadRate() {
        return this.upload_rate;
    }

    @Override
    public boolean isAutoManaged() {
        return false;
    }

    @Override
    public int getSeedingTime() {
        if (this.seeding_time == 0 && LibTorrentState.forId(this.state) == LibTorrentState.FINISHED) {
            return this.active_time;
        }
        return this.seeding_time;
    }

    @Override
    public int getActiveTime() {
        return this.active_time;
    }

    @Override
    public long getTotalWanted() {
        return this.total_wanted;
    }

    @Override
    public long getTotalWantedDone() {
        return this.total_wanted_done;
    }

    @Override
    public String getCurrentTracker() {
        return this.current_tracker != null && this.current_tracker.isEmpty() ? null : this.current_tracker;
    }

    @Override
    public int getNumComplete() {
        return this.num_complete;
    }

    @Override
    public int getNumIncomplete() {
        return this.num_incomplete;
    }
}

