/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.libtorrent;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.limewire.bittorrent.Torrent;
import org.limewire.bittorrent.TorrentAlert;
import org.limewire.bittorrent.TorrentEvent;
import org.limewire.bittorrent.TorrentEventType;
import org.limewire.bittorrent.TorrentFileEntry;
import org.limewire.bittorrent.TorrentInfo;
import org.limewire.bittorrent.TorrentParams;
import org.limewire.bittorrent.TorrentPeer;
import org.limewire.bittorrent.TorrentPiecesInfo;
import org.limewire.bittorrent.TorrentStatus;
import org.limewire.libtorrent.LibTorrentFileEntry;
import org.limewire.libtorrent.LibTorrentPeer;
import org.limewire.libtorrent.LibTorrentStatus;
import org.limewire.libtorrent.LibTorrentWrapper;
import org.limewire.listener.AsynchronousEventMulticaster;
import org.limewire.listener.AsynchronousMulticasterImpl;
import org.limewire.listener.EventListener;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

class TorrentImpl
implements Torrent {
    private static final Log LOG = LogFactory.getLog(TorrentImpl.class);
    private final Map<String, Object> properties = Collections.synchronizedMap(new HashMap(2));
    private final AsynchronousEventMulticaster<TorrentEvent> listeners;
    private final LibTorrentWrapper libTorrent;
    private final AtomicReference<TorrentStatus> status = new AtomicReference<Object>(null);
    private final AtomicReference<TorrentInfo> torrentInfo = new AtomicReference<Object>(null);
    private final AtomicReference<File> torrentDataFile = new AtomicReference<Object>(null);
    private final AtomicReference<File> torrentFile = new AtomicReference<Object>(null);
    private final AtomicReference<File> fastResumeFile = new AtomicReference<Object>(null);
    private final AtomicLong startTime = new AtomicLong(-1L);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final AtomicBoolean complete = new AtomicBoolean(false);
    private final Lock lock = new ReentrantLock();
    private final String sha1;
    private String name = null;
    private String trackerURL = null;
    private final AtomicBoolean isPrivate = new AtomicBoolean(true);

    public TorrentImpl(TorrentParams params, LibTorrentWrapper libTorrent, ScheduledExecutorService fastExecutor) {
        this.libTorrent = libTorrent;
        this.listeners = new AsynchronousMulticasterImpl<TorrentEvent>(fastExecutor);
        this.sha1 = params.getSha1();
        this.trackerURL = params.getTrackerURL();
        this.name = params.getName();
        Boolean isPrivate = params.getPrivate();
        this.torrentFile.set(params.getTorrentFile());
        this.fastResumeFile.set(params.getFastResumeFile());
        this.torrentDataFile.set(params.getTorrentDataFile());
        if (isPrivate != null) {
            this.isPrivate.set(isPrivate);
        }
        if (this.sha1 == null) {
            throw new NullPointerException("Sha1 torrent parameter cannot be null.");
        }
    }

    @Override
    public void addListener(EventListener<TorrentEvent> listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<TorrentEvent> listener) {
        return this.listeners.removeListener(listener);
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (!this.started.getAndSet(true)) {
            this.lock.lock();
            try {
                this.startTime.set(System.currentTimeMillis());
                this.resume();
                this.listeners.broadcast(new TorrentEvent(this, TorrentEventType.STARTED));
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public File getTorrentFile() {
        return this.torrentFile.get();
    }

    @Override
    public File getFastResumeFile() {
        return this.fastResumeFile.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTorrent(File directory) {
        this.lock.lock();
        try {
            assert (this.isFinished());
            this.libTorrent.move_torrent(this.sha1, directory.getAbsolutePath());
            this.torrentDataFile.set(new File(directory, this.torrentDataFile.get().getName()));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        this.lock.lock();
        try {
            this.libTorrent.pause_torrent(this.sha1);
            this.updateStatus(this.getStatusInner());
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setTorrentFile(File torrentFile) {
        this.torrentFile.set(torrentFile);
    }

    @Override
    public void setFastResumeFile(File fastResumeFile) {
        this.fastResumeFile.set(fastResumeFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        this.lock.lock();
        try {
            if (this.getStatus().isError()) {
                this.libTorrent.clear_error_and_retry(this.sha1);
            } else {
                this.libTorrent.resume_torrent(this.sha1);
            }
            this.updateStatus(this.getStatusInner());
        }
        finally {
            this.lock.unlock();
        }
    }

    private LibTorrentStatus getStatusInner() {
        LibTorrentStatus status = new LibTorrentStatus();
        this.libTorrent.get_torrent_status(this.sha1, status);
        this.libTorrent.free_torrent_status(status);
        return status;
    }

    @Override
    public float getDownloadRate() {
        TorrentStatus status = this.status.get();
        return status == null ? 0.0f : status.getDownloadPayloadRate();
    }

    @Override
    public String getSha1() {
        return this.sha1;
    }

    @Override
    public boolean isPaused() {
        TorrentStatus status = this.status.get();
        return status == null ? false : status.isPaused();
    }

    @Override
    public boolean isFinished() {
        TorrentStatus status = this.status.get();
        return status == null ? false : status.isFinished();
    }

    @Override
    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public String getTrackerURL() {
        return this.trackerURL;
    }

    @Override
    public int getNumPeers() {
        TorrentStatus status = this.status.get();
        return status == null ? 0 : status.getNumPeers();
    }

    @Override
    public File getTorrentDataFile() {
        return this.torrentDataFile.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.lock.lock();
        try {
            if (!this.cancelled.getAndSet(true) && this.isValid() && this.hasMetaData()) {
                TorrentInfo ti = this.libTorrent.get_torrent_info(this.sha1);
                this.torrentInfo.set(ti);
            }
            this.listeners.broadcast(new TorrentEvent(this, TorrentEventType.STOPPED));
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getTotalUploaded() {
        TorrentStatus status = this.status.get();
        if (status == null) {
            return 0L;
        }
        return status.getAllTimePayloadUpload();
    }

    @Override
    public int getNumUploads() {
        TorrentStatus status = this.status.get();
        if (status == null) {
            return 0;
        }
        return status.getNumUploads();
    }

    @Override
    public float getUploadRate() {
        TorrentStatus status = this.status.get();
        return status == null ? 0.0f : status.getUploadPayloadRate();
    }

    @Override
    public float getSeedRatio() {
        TorrentStatus status = this.status.get();
        if (status != null) {
            float seedRatio = status.getSeedRatio();
            return seedRatio;
        }
        return 0.0f;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled.get();
    }

    @Override
    public TorrentStatus getStatus() {
        return this.status.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStatus(TorrentStatus torrentStatus) {
        this.lock.lock();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Updating torrent status: {0} \n {1}", (Object)this.sha1, (Object)torrentStatus);
        }
        try {
            if (!this.cancelled.get()) {
                this.status.set(torrentStatus);
                boolean newlyfinished = !this.complete.get() && torrentStatus.isFinished();
                this.complete.set(torrentStatus.isFinished());
                if (newlyfinished) {
                    this.listeners.broadcast(new TorrentEvent(this, TorrentEventType.COMPLETED));
                } else {
                    this.listeners.broadcast(new TorrentEvent(this, TorrentEventType.STATUS_CHANGED));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleFastResumeAlert(TorrentAlert alert) {
        this.lock.lock();
        try {
            this.listeners.broadcast(new TorrentEvent(this, TorrentEventType.FAST_RESUME_FILE_SAVED));
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getNumConnections() {
        TorrentStatus status = this.getStatus();
        if (status != null) {
            return status.getNumConnections();
        }
        return 0;
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TorrentFileEntry> getTorrentFileEntries() {
        this.lock.lock();
        try {
            if (!this.isValid()) {
                TorrentInfo torrentInfo = this.torrentInfo.get();
                if (torrentInfo == null) {
                    List<TorrentFileEntry> list = Collections.emptyList();
                    return list;
                }
                List<TorrentFileEntry> list = torrentInfo.getTorrentFileEntries();
                return list;
            }
            LibTorrentFileEntry[] files = this.libTorrent.get_files(this.sha1);
            List<TorrentFileEntry> list = Arrays.asList(files);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TorrentPeer> getTorrentPeers() {
        this.lock.lock();
        try {
            LibTorrentPeer[] peers = this.libTorrent.get_peers(this.sha1);
            List<TorrentPeer> list = Arrays.asList(peers);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isAutoManaged() {
        TorrentStatus status = this.status.get();
        return status == null ? false : status.isAutoManaged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoManaged(boolean autoManaged) {
        this.lock.lock();
        try {
            this.libTorrent.set_auto_managed_torrent(this.sha1, autoManaged);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTorrenFileEntryPriority(TorrentFileEntry torrentFileEntry, int priority) {
        this.lock.lock();
        try {
            this.libTorrent.set_file_priority(this.sha1, torrentFileEntry.getIndex(), priority);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public File getTorrentDataFile(TorrentFileEntry torrentFileEntry) {
        return new File(this.getTorrentDataFile().getParent(), torrentFileEntry.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMetaData() {
        this.lock.lock();
        try {
            boolean bl = this.torrentInfo.get() != null || this.libTorrent.has_metadata(this.sha1);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TorrentInfo getTorrentInfo() {
        this.lock.lock();
        try {
            if (this.isValid() && this.hasMetaData() && this.torrentInfo.get() == null) {
                TorrentInfo ti = this.libTorrent.get_torrent_info(this.sha1);
                this.torrentInfo.set(ti);
            }
            TorrentInfo torrentInfo = this.torrentInfo.get();
            return torrentInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public <T> T getProperty(String key, T defaultValue) {
        Object value = this.properties.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    @Override
    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        this.lock.lock();
        try {
            boolean bl = this.libTorrent.is_valid(this.sha1);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getStartTime() {
        return this.startTime.get();
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceReannounce() {
        this.lock.lock();
        try {
            this.libTorrent.force_reannounce(this.sha1);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrapeTracker() {
        this.lock.lock();
        try {
            this.libTorrent.scrape_tracker(this.sha1);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveFastResumeData() {
        this.lock.lock();
        try {
            this.libTorrent.signal_fast_resume_data_request(this.sha1);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TorrentPiecesInfo getPiecesInfo() {
        this.lock.lock();
        try {
            TorrentPiecesInfo torrentPiecesInfo = this.libTorrent.get_pieces_status(this.sha1);
            return torrentPiecesInfo;
        }
        finally {
            this.lock.unlock();
        }
    }
}

