/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.util;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.KUID;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.settings.ContextSettings;
import org.limewire.mojito.settings.KademliaSettings;

public class DHTSizeEstimator {
    private static final Log LOG = LogFactory.getLog(DHTSizeEstimator.class);
    private static final BigInteger MAXIMUM = KUID.MAXIMUM.toBigInteger();
    private static final int MIN_NODE_COUNT = 3;
    private List<BigInteger> localSizeHistory = new LinkedList<BigInteger>();
    private List<BigInteger> remoteSizeHistory = new LinkedList<BigInteger>();
    private BigInteger estimatedSize = BigInteger.ZERO;
    private long localEstimateTime = 0L;
    private long updateEstimatedSizeTime = 0L;

    public synchronized void clear() {
        this.estimatedSize = BigInteger.ZERO;
        this.localEstimateTime = 0L;
        this.updateEstimatedSizeTime = 0L;
        this.localSizeHistory.clear();
        this.remoteSizeHistory.clear();
    }

    public synchronized BigInteger getEstimatedSize(RouteTable routeTable) {
        if (routeTable != null && System.currentTimeMillis() - this.localEstimateTime >= ContextSettings.ESTIMATE_NETWORK_SIZE_EVERY.getValue()) {
            RouteTable.SelectMode mode = RouteTable.SelectMode.ALL;
            if (ContextSettings.ESTIMATE_WITH_LIVE_NODES_ONLY.getValue()) {
                mode = RouteTable.SelectMode.ALIVE;
            }
            KUID localNodeId = routeTable.getLocalNode().getNodeID();
            Collection<Contact> nodes = routeTable.select(localNodeId, KademliaSettings.REPLICATION_PARAMETER.getValue(), mode);
            this.updateSize(nodes);
            this.localEstimateTime = System.currentTimeMillis();
        }
        return this.estimatedSize;
    }

    public synchronized void addEstimatedRemoteSize(BigInteger remoteSize) {
        if (!ContextSettings.COUNT_REMOTE_SIZE.getValue()) {
            this.remoteSizeHistory.clear();
            return;
        }
        if (remoteSize.compareTo(BigInteger.ZERO) == 0) {
            return;
        }
        if (remoteSize.compareTo(BigInteger.ZERO) < 0 || remoteSize.compareTo(MAXIMUM) > 0) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(remoteSize + " is an illegal argument");
            }
            return;
        }
        this.remoteSizeHistory.add(remoteSize);
        int maxRemoteHistorySize = ContextSettings.MAX_REMOTE_HISTORY_SIZE.getValue();
        while (this.remoteSizeHistory.size() > maxRemoteHistorySize && !this.remoteSizeHistory.isEmpty()) {
            this.remoteSizeHistory.remove(0);
        }
    }

    public synchronized void updateSize(Collection<? extends Contact> nodes) {
        if (System.currentTimeMillis() - this.updateEstimatedSizeTime >= ContextSettings.UPDATE_NETWORK_SIZE_EVERY.getValue() && nodes.size() >= 3) {
            this.estimatedSize = this.computeSize(nodes);
            this.updateEstimatedSizeTime = System.currentTimeMillis();
        }
    }

    public synchronized BigInteger computeSize(Collection<? extends Contact> nodes) {
        TreeSet<BigInteger> remoteSizeSet;
        if (nodes.size() < 3) {
            return BigInteger.ONE.max(BigInteger.valueOf(nodes.size()));
        }
        Iterator<? extends Contact> contacts = nodes.iterator();
        BigInteger sum1 = BigInteger.ZERO;
        BigInteger sum2 = BigInteger.ZERO;
        KUID nearestId = contacts.next().getNodeID();
        int i = 1;
        while (contacts.hasNext()) {
            Contact node = contacts.next();
            BigInteger distance = nearestId.xor(node.getNodeID()).toBigInteger();
            BigInteger j = BigInteger.valueOf(i);
            sum1 = sum1.add(j.multiply(distance));
            sum2 = sum2.add(j.pow(2));
            ++i;
        }
        BigInteger estimatedSize = BigInteger.ZERO;
        if (!sum1.equals(BigInteger.ZERO)) {
            estimatedSize = KUID.MAXIMUM.toBigInteger().multiply(sum2).divide(sum1);
        }
        estimatedSize = BigInteger.ONE.max(estimatedSize);
        BigInteger localSize = BigInteger.ZERO;
        this.localSizeHistory.add(estimatedSize);
        int maxLocalHistorySize = ContextSettings.MAX_LOCAL_HISTORY_SIZE.getValue();
        while (this.localSizeHistory.size() > maxLocalHistorySize && !this.localSizeHistory.isEmpty()) {
            this.localSizeHistory.remove(0);
        }
        if (!this.localSizeHistory.isEmpty()) {
            BigInteger localSizeSum = BigInteger.ZERO;
            for (BigInteger size : this.localSizeHistory) {
                localSizeSum = localSizeSum.add(size);
            }
            localSize = localSizeSum.divide(BigInteger.valueOf(this.localSizeHistory.size()));
        }
        BigInteger combinedSize = localSize;
        if (ContextSettings.COUNT_REMOTE_SIZE.getValue() && (remoteSizeSet = new TreeSet<BigInteger>(this.remoteSizeHistory)).size() >= 3) {
            int skip;
            BigInteger[] remote = remoteSizeSet.toArray(new BigInteger[0]);
            int count = 1;
            for (int i2 = skip = ContextSettings.SKIP_REMOTE_ESTIMATES.getValue(); skip >= 0 && i2 < remote.length - skip; ++i2) {
                combinedSize = combinedSize.add(remote[i2]);
                ++count;
            }
            combinedSize = combinedSize.divide(BigInteger.valueOf(count));
            combinedSize = combinedSize.min(MAXIMUM);
        }
        return BigInteger.ONE.max(combinedSize);
    }
}

