/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.net.ProxyManager;
import org.limewire.net.ProxySettings;
import org.limewire.net.SocketBindingSettings;
import org.limewire.net.SocketController;
import org.limewire.nio.NBSocket;
import org.limewire.nio.NBSocketFactory;
import org.limewire.nio.observer.ConnectObserver;

abstract class AbstractSocketController
implements SocketController {
    private static final Log LOG = LogFactory.getLog(AbstractSocketController.class);
    private InetSocketAddress lastBindAddr;
    private final ProxyManager proxyManager;
    private final SocketBindingSettings defaultSocketBindingSettings;

    AbstractSocketController(ProxyManager proxyManager, SocketBindingSettings defaultSocketBindingSettings) {
        this.proxyManager = proxyManager;
        this.defaultSocketBindingSettings = defaultSocketBindingSettings;
    }

    @Override
    public Socket connect(NBSocketFactory factory, InetSocketAddress remoteAddress, InetSocketAddress localAddress, int timeout, ConnectObserver observer) throws IOException {
        return this.connect(localAddress, factory, remoteAddress, timeout, observer);
    }

    public Socket connect(NBSocket socket, InetSocketAddress localAddr, InetSocketAddress addr, int timeout, ConnectObserver observer) throws IOException {
        return this.connect(localAddr, null, addr, timeout, observer);
    }

    private Socket connect(InetSocketAddress localAddr, NBSocketFactory factory, InetSocketAddress addr, int timeout, ConnectObserver observer) throws IOException {
        ProxySettings.ProxyType proxyType = this.proxyManager.getProxyType(addr.getAddress());
        if (proxyType != ProxySettings.ProxyType.NONE) {
            return this.connectProxy(localAddr, factory, proxyType, addr, timeout, observer);
        }
        return this.connectPlain(localAddr, factory, addr, timeout, observer);
    }

    protected Socket connectPlain(InetSocketAddress localAddr, NBSocketFactory factory, InetSocketAddress addr, int timeout, ConnectObserver observer) throws IOException {
        NBSocket socket = factory.createSocket();
        this.bindSocket(socket, localAddr);
        if (observer == null) {
            if (LOG.isDebugEnabled()) {
                String ipp = addr.getAddress().getHostAddress() + ":" + addr.getPort();
                LOG.debug("Connecting to " + ipp + " (blocking)");
            }
            socket.connect(addr, timeout);
        } else {
            if (LOG.isDebugEnabled()) {
                String ipp = addr.getAddress().getHostAddress() + ":" + addr.getPort();
                LOG.debug("Connecting to " + ipp + " (non-blocking)");
            }
            socket.connect(addr, timeout, observer);
        }
        return socket;
    }

    protected void bindSocket(NBSocket socket, InetSocketAddress localAddr) throws IOException {
        if (localAddr != null) {
            socket.bind(localAddr);
        } else if (this.defaultSocketBindingSettings.isSocketBindingRequired()) {
            String bindAddrString = this.defaultSocketBindingSettings.getAddressToBindTo();
            if (this.lastBindAddr == null || !this.lastBindAddr.getAddress().getHostAddress().equals(bindAddrString)) {
                this.lastBindAddr = new InetSocketAddress(bindAddrString, 0);
            }
            try {
                socket.bind(this.lastBindAddr);
            }
            catch (IOException iox) {
                this.defaultSocketBindingSettings.bindingFailed();
            }
        }
    }

    protected Socket connectProxy(InetSocketAddress localAddr, NBSocketFactory factory, ProxySettings.ProxyType type, InetSocketAddress addr, int timeout, ConnectObserver observer) throws IOException {
        InetSocketAddress proxyAddr = this.proxyManager.getProxyHost();
        if (observer != null) {
            return this.connectPlain(localAddr, factory, proxyAddr, timeout, this.proxyManager.getConnectorFor(type, observer, addr, timeout));
        }
        Socket proxySocket = this.connectPlain(localAddr, factory, proxyAddr, timeout, null);
        try {
            return this.proxyManager.establishProxy(type, proxySocket, addr, timeout);
        }
        catch (IOException iox) {
            try {
                proxySocket.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw iox;
        }
    }
}

