/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.observer.WriteObserver;

class SocketInterestWriteAdapter
implements InterestWritableByteChannel {
    private volatile WriteObserver interested;
    private SocketChannel channel;
    private boolean shutdown = false;

    SocketInterestWriteAdapter(SocketChannel channel) {
        this.channel = channel;
    }

    @Override
    public int write(ByteBuffer buffer) throws IOException {
        return this.channel.write(buffer);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public synchronized void interestWrite(WriteObserver observer, boolean on) {
        if (!this.shutdown) {
            this.interested = on ? observer : null;
            NIODispatcher.instance().interestWrite(this.channel, on);
        }
    }

    @Override
    public boolean handleWrite() throws IOException {
        WriteObserver chain = this.interested;
        if (chain != null) {
            return chain.handleWrite();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        SocketInterestWriteAdapter socketInterestWriteAdapter = this;
        synchronized (socketInterestWriteAdapter) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        WriteObserver chain = this.interested;
        if (chain != null) {
            chain.shutdown();
        }
        this.interested = null;
    }

    @Override
    public void handleIOException(IOException x) {
        throw new RuntimeException("unsupported", x);
    }

    @Override
    public boolean hasBufferedOutput() {
        return false;
    }
}

