/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.promotion;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.util.Providers;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.geocode.GeocodeInformation;
import org.limewire.promotion.DatabaseExecutionException;
import org.limewire.promotion.InitializeException;
import org.limewire.promotion.KeywordUtil;
import org.limewire.promotion.KeywordUtilImpl;
import org.limewire.promotion.LatitudeLongitude;
import org.limewire.promotion.PromotionBinder;
import org.limewire.promotion.PromotionBinderRepository;
import org.limewire.promotion.PromotionSearcher;
import org.limewire.promotion.PromotionServices;
import org.limewire.promotion.SearcherDatabase;
import org.limewire.promotion.containers.PromotionMessageContainer;
import org.limewire.promotion.impressions.ImpressionsCollector;

@Singleton
public class PromotionSearcherImpl
implements PromotionSearcher {
    private final KeywordUtil keywordUtil;
    private final SearcherDatabase searcherDatabase;
    private final ImpressionsCollector impressionsCollector;
    private final PromotionBinderRepository promotionBinderRepository;
    private final PromotionServices promotionServices;
    private final ExecutorService exec;
    private volatile Provider<Integer> maxNumberOfResults = Providers.of(5);

    @Inject
    public PromotionSearcherImpl(KeywordUtilImpl keywordUtil, SearcherDatabase searcherDatabase, ImpressionsCollector impressionsCollector, PromotionBinderRepository promotionBinderRepository, PromotionServices promotionServices) {
        this.keywordUtil = keywordUtil;
        this.searcherDatabase = searcherDatabase;
        this.impressionsCollector = impressionsCollector;
        this.promotionBinderRepository = promotionBinderRepository;
        this.promotionServices = promotionServices;
        this.exec = ExecutorsHelper.newThreadPool("SearcherThread");
    }

    @Override
    public void search(String query, PromotionSearcher.PromotionSearchResultsCallback callback, GeocodeInformation userLocation) {
        if (this.isEnabled()) {
            this.exec.execute(new Searcher(query, callback, userLocation));
        }
    }

    @Override
    public void init(Provider<Integer> maxNumberOfResults) throws InitializeException {
        this.maxNumberOfResults = maxNumberOfResults;
        this.searcherDatabase.init();
    }

    @Override
    public void shutDown() {
        this.searcherDatabase.shutDown();
    }

    @Override
    public boolean isEnabled() {
        return this.promotionServices.isRunning();
    }

    private class Searcher
    implements Runnable {
        private final String query;
        private final PromotionSearcher.PromotionSearchResultsCallback callback;
        private final String normalizedQuery;
        private final LatitudeLongitude userLatLon;
        private final String userTerritory;

        Searcher(String query, PromotionSearcher.PromotionSearchResultsCallback callback, GeocodeInformation userLocation) {
            this.query = query;
            this.callback = callback;
            this.normalizedQuery = PromotionSearcherImpl.this.keywordUtil.normalizeQuery(query);
            if (userLocation == null) {
                this.userLatLon = null;
                this.userTerritory = null;
            } else {
                this.userLatLon = this.getLatitudeLongitude(userLocation);
                this.userTerritory = userLocation.getProperty(GeocodeInformation.Property.CountryCode);
            }
        }

        private LatitudeLongitude getLatitudeLongitude(GeocodeInformation geocodeInformation) {
            String lat = geocodeInformation.getProperty(GeocodeInformation.Property.Latitude);
            String lon = geocodeInformation.getProperty(GeocodeInformation.Property.Longitude);
            if (lat == null || lon == null) {
                return null;
            }
            try {
                return new LatitudeLongitude(Double.parseDouble(lat), Double.parseDouble(lon));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }

        @Override
        public void run() {
            Date timeQueried = new Date();
            PromotionBinder binder = null;
            List<SearcherDatabase.QueryResult> results = null;
            binder = PromotionSearcherImpl.this.promotionBinderRepository.getBinderForBucket(PromotionSearcherImpl.this.keywordUtil.getHashValue(this.normalizedQuery));
            try {
                if (binder != null) {
                    PromotionSearcherImpl.this.searcherDatabase.ingest(binder);
                }
                PromotionSearcherImpl.this.searcherDatabase.expungeExpired();
                results = PromotionSearcherImpl.this.searcherDatabase.query(this.normalizedQuery);
            }
            catch (DatabaseExecutionException e) {
                PromotionSearcherImpl.this.promotionServices.stop();
            }
            if (results == null) {
                return;
            }
            this.removeInvalidResults(results, timeQueried);
            ArrayList<SearcherDatabase.QueryResult> visibleResults = new ArrayList<SearcherDatabase.QueryResult>(results.size());
            for (SearcherDatabase.QueryResult result : results) {
                if (result.getPromotionMessageContainer().isImpressionOnly()) {
                    PromotionSearcherImpl.this.impressionsCollector.recordImpression(this.query, timeQueried, new Date(), result.getPromotionMessageContainer(), result.getBinderUniqueName());
                    continue;
                }
                visibleResults.add(result);
            }
            int shownResults = 0;
            int idx = 0;
            for (SearcherDatabase.QueryResult result : visibleResults) {
                int remainingMaxToShow;
                float probability = result.getPromotionMessageContainer().getProbability();
                int remainingToIterateThrough = visibleResults.size() - idx;
                if (remainingToIterateThrough <= (remainingMaxToShow = (Integer)PromotionSearcherImpl.this.maxNumberOfResults.get() - shownResults) || Math.random() <= (double)probability) {
                    ++shownResults;
                    this.callback.process(result.getPromotionMessageContainer());
                    PromotionSearcherImpl.this.impressionsCollector.recordImpression(this.query, timeQueried, new Date(), result.getPromotionMessageContainer(), result.getBinderUniqueName());
                }
                ++idx;
                if (shownResults < (Integer)PromotionSearcherImpl.this.maxNumberOfResults.get()) continue;
                break;
            }
        }

        private boolean isMessageValid(PromotionMessageContainer promotionMessageContainer, String binderUniqueName, long currentTimeMillis) {
            PromotionBinder binder = PromotionSearcherImpl.this.searcherDatabase.getBinder(binderUniqueName);
            if (binder == null) {
                return false;
            }
            return binder.isValidMember(promotionMessageContainer, true, currentTimeMillis);
        }

        private void removeInvalidResults(List<SearcherDatabase.QueryResult> results, Date timeQueried) {
            for (SearcherDatabase.QueryResult result : new ArrayList<SearcherDatabase.QueryResult>(results)) {
                Locale[] territories;
                PromotionMessageContainer promo = result.getPromotionMessageContainer();
                List<PromotionMessageContainer.GeoRestriction> restrictions = promo.getGeoRestrictions();
                if (restrictions.size() > 0) {
                    if (this.userLatLon == null) {
                        results.remove(result);
                        continue;
                    }
                    boolean matchedAtLeastOneRestriction = false;
                    for (PromotionMessageContainer.GeoRestriction restriction : restrictions) {
                        if (!restriction.contains(this.userLatLon)) continue;
                        matchedAtLeastOneRestriction = true;
                        break;
                    }
                    if (!matchedAtLeastOneRestriction) {
                        results.remove(result);
                        continue;
                    }
                }
                if ((territories = promo.getTerritories()).length > 0) {
                    if (this.userTerritory == null) {
                        results.remove(result);
                        continue;
                    }
                    boolean matchAtLeastOneTerritory = false;
                    for (Locale territory : territories) {
                        if (!this.userTerritory.equalsIgnoreCase(territory.getCountry())) continue;
                        matchAtLeastOneTerritory = true;
                        break;
                    }
                    if (!matchAtLeastOneTerritory) {
                        results.remove(result);
                        continue;
                    }
                }
                if (this.isMessageValid(result.getPromotionMessageContainer(), result.getBinderUniqueName(), timeQueried.getTime())) continue;
                results.remove(result);
            }
        }
    }
}

