/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import java.util.ArrayList;
import java.util.List;
import org.limewire.concurrent.ManagedThread;
import org.limewire.rudp.UDPConnectionProcessor;
import org.limewire.rudp.UDPTimerEvent;

public class UDPScheduler
extends ManagedThread {
    public static final UDPTimerEvent NO_EVENT = new NoEvent(Long.MAX_VALUE);
    private static final String NAME_OF_THREAD = "UDPScheduler";
    private List<UDPTimerEvent> _connectionEvents;
    private UDPTimerEvent _scheduledEvent;
    private boolean _started = false;
    private static UDPScheduler _instance = null;
    private UpdateThread _updateThread = null;
    private final Object _updateThreadLock = new Object();
    private final Object _mainThreadLock = new Object();

    public static synchronized UDPScheduler instance() {
        if (_instance == null) {
            _instance = new UDPScheduler();
        }
        return _instance;
    }

    private UDPScheduler() {
        super(NAME_OF_THREAD);
        this._connectionEvents = new ArrayList<UDPTimerEvent>();
        this._scheduledEvent = NO_EVENT;
    }

    public void register(UDPTimerEvent evt) {
        this.startThreads();
        this._updateThread.registerEvent(evt);
    }

    private final synchronized void registerSync(UDPTimerEvent evt) {
        this._connectionEvents.add(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startThreads() {
        Object object = this._mainThreadLock;
        synchronized (object) {
            if (!this._started) {
                this._started = true;
                this.setDaemon(true);
                this.start();
            }
        }
        object = this._updateThreadLock;
        synchronized (object) {
            if (this._updateThread == null) {
                this._updateThread = new UpdateThread();
                this._updateThread.setDaemon(true);
                this._updateThread.start();
            }
        }
    }

    public void scheduleEvent(UDPTimerEvent evt) {
        this.startThreads();
        this._updateThread.addEvent(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            long waitTime;
            UDPScheduler uDPScheduler;
            try {
                uDPScheduler = this;
                synchronized (uDPScheduler) {
                    if (this._scheduledEvent == NO_EVENT) {
                        waitTime = 0L;
                    } else {
                        waitTime = this._scheduledEvent.getEventTime() - System.currentTimeMillis();
                        if (waitTime == 0L) {
                            waitTime = -1L;
                        }
                    }
                    if (waitTime >= 0L) {
                        this.wait(waitTime);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            uDPScheduler = this;
            synchronized (uDPScheduler) {
                waitTime = this._scheduledEvent.getEventTime() - System.currentTimeMillis();
                if (waitTime > 0L) {
                    continue;
                }
            }
            this.runEvent();
            this.reworkSchedule();
        }
    }

    private synchronized void runEvent() {
        if (this._scheduledEvent.shouldUnregister()) {
            this._connectionEvents.remove(this._scheduledEvent);
        } else {
            this._scheduledEvent.handleEvent();
        }
    }

    private synchronized void reworkSchedule() {
        this._scheduledEvent = NO_EVENT;
        for (int i = 0; i < this._connectionEvents.size(); ++i) {
            UDPTimerEvent evt = this._connectionEvents.get(i);
            long time = evt.getEventTime();
            if (evt == NO_EVENT || time >= this._scheduledEvent.getEventTime() && this._scheduledEvent != NO_EVENT) continue;
            this._scheduledEvent = evt;
        }
    }

    private static final class NoEvent
    extends UDPTimerEvent {
        public NoEvent(long time) {
            super(time, null);
        }

        @Override
        protected void doActualEvent(UDPConnectionProcessor udpCon) {
        }
    }

    class UpdateThread
    extends ManagedThread {
        List<UDPTimerEvent> _listSchedule;
        List<UDPTimerEvent> _listRegister;

        public UpdateThread() {
            super("UDPUpdateThread");
            this._listSchedule = new ArrayList<UDPTimerEvent>();
            this._listRegister = new ArrayList<UDPTimerEvent>();
        }

        public synchronized void addEvent(UDPTimerEvent evt) {
            this._listSchedule.add(evt);
            this.notify();
        }

        public synchronized void registerEvent(UDPTimerEvent evt) {
            this._listRegister.add(evt);
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                int i;
                ArrayList<UDPTimerEvent> localListRegister;
                ArrayList<UDPTimerEvent> localListSchedule;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                UpdateThread e = this;
                synchronized (e) {
                    localListSchedule = new ArrayList<UDPTimerEvent>(this._listSchedule);
                    this._listSchedule.clear();
                    localListRegister = new ArrayList<UDPTimerEvent>(this._listRegister);
                    this._listRegister.clear();
                }
                for (i = 0; i < localListRegister.size(); ++i) {
                    UDPScheduler.this.registerSync((UDPTimerEvent)localListRegister.get(i));
                }
                for (i = 0; i < localListSchedule.size(); ++i) {
                    UDPTimerEvent evt = (UDPTimerEvent)localListSchedule.get(i);
                    this.updateSchedule(evt);
                }
                UpdateThread updateThread = this;
                synchronized (updateThread) {
                    if (this._listSchedule.size() > 0 || this._listRegister.size() > 0) {
                        continue;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateSchedule(UDPTimerEvent evt) {
            UDPScheduler uDPScheduler = UDPScheduler.this;
            synchronized (uDPScheduler) {
                if (evt.getEventTime() < UDPScheduler.this._scheduledEvent.getEventTime() && UDPScheduler.this._connectionEvents.contains(evt)) {
                    UDPScheduler.this._scheduledEvent = evt;
                    UDPScheduler.this.notify();
                }
            }
        }
    }
}

