/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.limewire.security.AbstractSecurityToken;
import org.limewire.security.InvalidSecurityTokenException;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;
import org.limewire.util.ByteUtils;

public final class AddressSecurityToken
extends AbstractSecurityToken {
    public static final int MIN_QK_SIZE_IN_BYTES = 4;
    public static final int MAX_QK_SIZE_IN_BYTES = 16;
    private final int _hashCode = this.genHashCode(this.getBytes());

    public AddressSecurityToken(SocketAddress address, MACCalculatorRepositoryManager mgr) {
        this(((InetSocketAddress)address).getAddress(), ((InetSocketAddress)address).getPort(), mgr);
    }

    public AddressSecurityToken(InetAddress ip, int port, MACCalculatorRepositoryManager mgr) {
        this(new AddressTokenData(ip, port), mgr);
    }

    public AddressSecurityToken(AddressTokenData data, MACCalculatorRepositoryManager mgr) {
        super(data, mgr);
    }

    public AddressSecurityToken(byte[] key, MACCalculatorRepositoryManager mgr) throws InvalidSecurityTokenException {
        super((byte[])key.clone(), mgr);
    }

    private int genHashCode(byte[] key) {
        int code = 0x5A5A5A5A;
        for (int i = key.length - 1; i >= 0; --i) {
            code ^= 0xFF & key[i];
            code *= (code << 1) + 1;
            code = code >>> 27 | code << 5;
        }
        return code;
    }

    @Override
    protected byte[] getFromMAC(byte[] key, SecurityToken.TokenData ignored) {
        for (int i = key.length - 1; i >= 0; --i) {
            if (key[i] != 28) continue;
            key[i] = -6;
        }
        return key;
    }

    public boolean isFor(SocketAddress address) {
        InetAddress ip = ((InetSocketAddress)address).getAddress();
        int port = ((InetSocketAddress)address).getPort();
        return this.isFor(ip, port);
    }

    public boolean isFor(InetAddress ip, int port) {
        return this.isFor(new AddressTokenData(ip, port));
    }

    @Override
    public int hashCode() {
        return this._hashCode;
    }

    public String toString() {
        return "{AddressSecurityToken: " + new BigInteger(1, this.getBytes()).toString(16) + "}";
    }

    public static boolean isValidSecurityTokenBytes(byte[] key) {
        return key != null && key.length >= 4 && key.length <= 16;
    }

    @Override
    protected boolean isValidBytes(byte[] key) {
        return AddressSecurityToken.isValidSecurityTokenBytes(key);
    }

    public static class AddressTokenData
    implements SecurityToken.TokenData {
        protected final byte[] data;

        public AddressTokenData(SocketAddress address) {
            this(((InetSocketAddress)address).getAddress(), ((InetSocketAddress)address).getPort());
        }

        public AddressTokenData(InetAddress addr, int port) {
            byte[] ipBytes = addr.getAddress();
            int ipInt = 0;
            for (int i = 3; i >= 0; --i) {
                ipInt ^= ipBytes[i] << (i << 3);
            }
            this.data = new byte[8];
            ByteUtils.int2beb(port, this.data, 0);
            ByteUtils.int2beb(ipInt, this.data, 4);
        }

        @Override
        public byte[] getData() {
            return this.data;
        }
    }
}

