/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.support;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.util.EntityUtils;
import org.limewire.core.api.support.LocalClientInfo;
import org.limewire.http.httpclient.LimeHttpClient;
import org.limewire.http.httpclient.SimpleLimeHttpClient;
import org.limewire.ui.support.RemoteClientInfo;

final class ServletAccessor {
    private static final Log LOG = LogFactory.getLog(ServletAccessor.class);
    @Inject
    private static volatile Provider<LimeHttpClient> limeHttpClient;
    private static final int CONNECT_TIMEOUT = 10000;
    private static final String DEFAULT_SERVLET_URL = "http://bugreports.limewire.com/bugs/servlet/BugHandler";
    private final String SERVLET_URL;
    private final boolean ALLOW_NIO;

    ServletAccessor() {
        this(true);
    }

    ServletAccessor(boolean allowNIO) {
        this(allowNIO, DEFAULT_SERVLET_URL);
    }

    ServletAccessor(boolean allowNIO, String servlet_url) {
        this.ALLOW_NIO = allowNIO;
        this.SERVLET_URL = servlet_url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized RemoteClientInfo getRemoteBugInfo(LocalClientInfo localInfo) {
        RemoteClientInfo remoteInfo = new RemoteClientInfo();
        HttpResponse response = null;
        SimpleLimeHttpClient client = this.ALLOW_NIO && limeHttpClient != null ? limeHttpClient.get() : new SimpleLimeHttpClient();
        try {
            NameValuePair[] params = this.getNameValuePairs(localInfo.getPostRequestParams());
            HttpPost post = new HttpPost(this.SERVLET_URL);
            post.addHeader("Cache-Control", "no-cache");
            post.addHeader("User-Agent", LimeWireUtils.getHttpServer());
            post.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            post.setEntity(new UrlEncodedFormEntity(Arrays.asList(params), "UTF-8"));
            HttpConnectionParams.setConnectionTimeout(client.getParams(), 10000);
            HttpClientParams.setRedirecting(client.getParams(), false);
            response = client.execute(post);
            String result = response.getEntity() != null ? EntityUtils.toString(response.getEntity()) : null;
            String body = result;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got response: " + response);
            }
            if (response.getStatusLine().getStatusCode() == 200) {
                remoteInfo.addRemoteInfo(body);
            } else {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Servlet connect failed, code: " + response.getStatusLine().getStatusCode());
                }
                remoteInfo.connectFailed();
            }
            client.releaseConnection(response);
        }
        catch (IOException e) {
            this.fail(remoteInfo, e);
        }
        finally {
            client.releaseConnection(response);
        }
        return remoteInfo;
    }

    private void fail(RemoteClientInfo remoteInfo, Throwable e) {
        LOG.error("Error connecting to bug servlet", e);
        remoteInfo.connectFailed();
    }

    private NameValuePair[] getNameValuePairs(Map.Entry[] entries) {
        NameValuePair[] pairs = new NameValuePair[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            Map.Entry entry = entries[i];
            pairs[i] = new BasicNameValuePair(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return pairs;
    }
}

