/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.action;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.limewire.ui.swing.action.ItemNotifyable;
import org.limewire.ui.swing.action.PopupDecider;

public class PopupUtil {
    public static JPopupMenu addPopupMenus(JComponent component, Action ... actions) {
        return PopupUtil.addPopupMenus(component, AlwaysShowPopup.get(), actions);
    }

    public static JPopupMenu addPopupMenus(JComponent component, PopupDecider decider, Action ... actions) {
        JPopupMenu menu = new JPopupMenu();
        for (Action action : actions) {
            menu.add(action);
        }
        PopupListener popupListener = new PopupListener(menu, decider);
        component.addMouseListener(popupListener);
        menu.addPopupMenuListener(popupListener);
        return menu;
    }

    private static class PopupListener
    extends MouseAdapter
    implements PopupMenuListener {
        private final JPopupMenu popup;
        private final PopupDecider decider;

        public PopupListener(JPopupMenu popup, PopupDecider decider) {
            this.popup = popup;
            this.decider = decider;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() && this.decider.shouldDisplay(e)) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            for (Component comp : this.popup.getComponents()) {
                if (!(comp instanceof JMenuItem)) continue;
                JMenuItem item = (JMenuItem)comp;
                Action action = item.getAction();
                if (action != null) {
                    item.setEnabled(action.isEnabled());
                }
                if (!(action instanceof ItemNotifyable)) continue;
                ItemNotifyable notifyable = (ItemNotifyable)((Object)action);
                notifyable.notifyItem(item);
            }
        }
    }

    private static class AlwaysShowPopup
    implements PopupDecider {
        private static AlwaysShowPopup INSTANCE = new AlwaysShowPopup();

        private AlwaysShowPopup() {
        }

        public static PopupDecider get() {
            return INSTANCE;
        }

        @Override
        public boolean shouldDisplay(MouseEvent e) {
            return true;
        }
    }
}

