/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.ui.swing.components.FancyTab;
import org.limewire.ui.swing.components.LimeComboBox;
import org.limewire.ui.swing.util.GuiUtils;

class FancyTabMoreButton
extends LimeComboBox {
    @Resource
    private Icon selectedIcon;
    private Icon unselectedIcon;
    @InspectablePrimitive(value="more tabs button clicked", category=DataCategory.USAGE)
    private static volatile int moreTabsButtonClicked = 0;
    private JPopupMenu menu = new JPopupMenu();

    public FancyTabMoreButton(List<FancyTab> tabs) {
        super((List<Action>)null);
        GuiUtils.assignResources(this);
        this.unselectedIcon = new EmptyIcon(this.selectedIcon.getIconWidth(), this.selectedIcon.getIconHeight());
        this.overrideMenu(this.menu);
        MoreListener listener = new MoreListener(tabs);
        this.menu.addPopupMenuListener(listener);
        this.setFocusable(false);
    }

    private JComponent createMenuItemFor(final JPopupMenu menu, FancyTab tab) {
        JXPanel jp = new JXPanel();
        jp.setOpaque(false);
        jp.setBackground(UIManager.getColor("MenuItem.selectionBackground"));
        AbstractButton selectButton = tab.createMainButton();
        selectButton.setOpaque(false);
        selectButton.setHorizontalAlignment(10);
        selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                menu.setVisible(false);
            }
        });
        JLabel selectionLabel = new JLabel(tab.isSelected() ? this.selectedIcon : this.unselectedIcon);
        selectionLabel.setOpaque(false);
        JLabel busyLabel = tab.createBusyLabel();
        busyLabel.setOpaque(false);
        GroupLayout layout = new GroupLayout(jp);
        jp.setLayout(layout);
        GroupLayout.SequentialGroup horGroup = layout.createSequentialGroup();
        layout.setHorizontalGroup(horGroup);
        GroupLayout.ParallelGroup verGroup = layout.createParallelGroup(GroupLayout.Alignment.CENTER);
        layout.setVerticalGroup(verGroup);
        layout.setAutoCreateGaps(true);
        horGroup.addGap(5).addComponent(selectionLabel).addComponent(busyLabel).addComponent(selectButton, 0, 120, 120);
        ((GroupLayout.Group)verGroup).addComponent(selectionLabel).addComponent(busyLabel).addComponent(selectButton);
        layout.setHonorsVisibility(busyLabel, false);
        Highlighter highlighter = new Highlighter(jp, selectButton);
        jp.addMouseListener(highlighter);
        selectButton.addMouseListener(highlighter);
        return jp;
    }

    private class MoreListener
    implements PopupMenuListener {
        private final List<FancyTab> tabs;

        public MoreListener(List<FancyTab> tabs) {
            this.tabs = tabs;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            FancyTabMoreButton.this.setSelected(false);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            FancyTabMoreButton.this.menu.removeAll();
            for (FancyTab tab : this.tabs) {
                FancyTabMoreButton.this.menu.add(FancyTabMoreButton.this.createMenuItemFor(FancyTabMoreButton.this.menu, tab));
            }
            FancyTabMoreButton.this.setSelected(true);
            moreTabsButtonClicked++;
        }
    }

    private static class Highlighter
    extends MouseAdapter {
        private final JXPanel panel;
        private final AbstractButton selectButton;

        public Highlighter(JXPanel panel, AbstractButton selectButton) {
            this.panel = panel;
            this.selectButton = selectButton;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.panel.setOpaque(true);
            this.panel.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.panel.setOpaque(false);
            this.panel.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!(e.getSource() instanceof AbstractButton) && SwingUtilities.isLeftMouseButton(e)) {
                this.selectButton.doClick(0);
            }
        }
    }
}

