/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.ui.swing.components.AbstractTabList;
import org.limewire.ui.swing.components.FancyTab;
import org.limewire.ui.swing.components.FancyTabMoreButton;
import org.limewire.ui.swing.components.TabActionMap;
import org.limewire.ui.swing.components.decorators.ComboBoxDecorator;
import org.limewire.ui.swing.util.GuiUtils;

public class FlexibleTabList
extends AbstractTabList {
    private static final int MAX_TAB_WIDTH = 205;
    private static final int MIN_TAB_WIDTH = 115;
    private static final int RIGHT_INSET = 3;
    @Resource
    private Icon moreDefaultIcon;
    @Resource
    private Icon morePressedIcon;
    @Resource
    private Icon moreRolloverIcon;
    private final ComboBoxDecorator comboBoxDecorator;
    private final Action closeOtherAction;
    private final Action closeAllAction;
    private int maxVisibleTabs;
    private int vizStartIdx = -1;

    @Inject
    FlexibleTabList(ComboBoxDecorator comboBoxDecorator) {
        this.comboBoxDecorator = comboBoxDecorator;
        GuiUtils.assignResources(this);
        this.setOpaque(false);
        this.setLayout(new MigLayout("insets 0 0 0 3, gap 0, filly, hidemode 2"));
        this.setMinimumSize(new Dimension(0, this.getMinimumSize().height));
        this.closeOtherAction = new CloseOther();
        this.closeAllAction = new CloseAll();
        this.maxVisibleTabs = Integer.MAX_VALUE;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (FlexibleTabList.this.calculateVisibleTabCount() != FlexibleTabList.this.maxVisibleTabs) {
                    FlexibleTabList.this.layoutTabs();
                }
            }
        });
    }

    public void addTabActionMapAt(TabActionMap actionMap, int i) {
        FancyTab tab = this.createAndPrepareTab(actionMap);
        this.addTab(tab, i);
    }

    @Override
    protected FancyTab createAndPrepareTab(TabActionMap actionMap) {
        FancyTab tab = super.createAndPrepareTab(actionMap);
        tab.setMinimumSize(new Dimension(115, tab.getMinimumSize().height));
        tab.setMaximumSize(new Dimension(205, tab.getMaximumSize().height));
        actionMap.setRemoveAll(this.closeAllAction);
        actionMap.setRemoveOthers(this.closeOtherAction);
        return tab;
    }

    @Override
    protected void layoutTabs() {
        this.removeAll();
        List<FancyTab> visibleTabs = this.getPendingVisibleTabs();
        for (FancyTab tab : visibleTabs) {
            this.add((Component)tab, "growy");
        }
        if (visibleTabs.size() < this.getTabs().size()) {
            FancyTabMoreButton more = new FancyTabMoreButton(this.getTabs());
            this.comboBoxDecorator.decorateIconComboBox(more);
            more.setIcon(this.moreDefaultIcon);
            more.setPressedIcon(this.morePressedIcon);
            more.setRolloverIcon(this.moreRolloverIcon);
            more.setSelectedIcon(this.morePressedIcon);
            this.add((Component)more, "gapleft 0:" + String.valueOf(115));
        }
        this.revalidate();
        this.repaint();
    }

    private List<FancyTab> getPendingVisibleTabs() {
        List<FancyTab> vizTabs;
        this.maxVisibleTabs = this.calculateVisibleTabCount();
        List<FancyTab> tabs = this.getTabs();
        if (this.maxVisibleTabs >= tabs.size()) {
            this.vizStartIdx = 0;
            vizTabs = tabs;
        } else {
            if (tabs.size() - this.vizStartIdx < this.maxVisibleTabs) {
                this.vizStartIdx = tabs.size() - this.maxVisibleTabs;
            }
            vizTabs = tabs.subList(this.vizStartIdx, this.vizStartIdx + this.maxVisibleTabs);
            FancyTab selectedTab = this.getSelectedTab();
            if (selectedTab != null && !vizTabs.contains(selectedTab)) {
                int selIdx = tabs.indexOf(selectedTab);
                this.vizStartIdx = this.vizStartIdx > selIdx ? selIdx : selIdx - this.maxVisibleTabs + 1;
                vizTabs = tabs.subList(this.vizStartIdx, this.vizStartIdx + this.maxVisibleTabs);
            }
        }
        return vizTabs;
    }

    private int calculateVisibleTabCount() {
        int totalWidth = this.getSize().width;
        int availWidth = Math.max(totalWidth, 115);
        int visibleTabCount = availWidth / 115;
        if (visibleTabCount < this.getTabs().size()) {
            int moreWidth = this.moreDefaultIcon.getIconWidth();
            availWidth = Math.max(totalWidth - moreWidth - 3, 115);
            visibleTabCount = availWidth / 115;
        }
        return visibleTabCount;
    }

    private void recreateTabs() {
        List<FancyTab> tabs = this.getTabs();
        ArrayList<TabActionMap> actionMaps = new ArrayList<TabActionMap>(tabs.size());
        for (FancyTab tab : tabs) {
            actionMaps.add(tab.getTabActionMap());
        }
        this.setTabActionMaps(actionMaps);
    }

    public void setCloseAllText(String closeAllText) {
        this.getTabProperties().setCloseAllText(closeAllText);
        this.closeAllAction.putValue("Name", closeAllText);
    }

    public void setCloseOneText(String closeOneText) {
        this.getTabProperties().setCloseOneText(closeOneText);
    }

    public void setCloseOtherText(String closeOtherText) {
        this.getTabProperties().setCloseOtherText(closeOtherText);
        this.closeOtherAction.putValue("Name", closeOtherText);
    }

    public void setRemovable(boolean removable) {
        this.getTabProperties().setRemovable(removable);
        this.recreateTabs();
    }

    public void setTabInsets(Insets insets) {
        this.getTabProperties().setInsets(insets);
        this.revalidate();
    }

    private class CloseOther
    extends AbstractAction {
        public CloseOther() {
            super(FlexibleTabList.this.getTabProperties().getCloseOtherText());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            while (FlexibleTabList.this.getTabs().size() > 1) {
                FancyTab tab = FlexibleTabList.this.getTabs().get(0);
                if (this.isFrom(tab, (Component)e.getSource())) {
                    tab = FlexibleTabList.this.getTabs().get(1);
                }
                tab.remove();
            }
        }

        private boolean isFrom(JComponent parent, Component child) {
            while (child.getParent() != null) {
                if ((child = child.getParent()) instanceof JPopupMenu) {
                    child = ((JPopupMenu)child).getInvoker();
                }
                if (child != parent) continue;
                return true;
            }
            return false;
        }
    }

    private class CloseAll
    extends AbstractAction {
        public CloseAll() {
            super(FlexibleTabList.this.getTabProperties().getCloseAllText());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            while (!FlexibleTabList.this.getTabs().isEmpty()) {
                FlexibleTabList.this.getTabs().get(0).remove();
            }
        }
    }
}

