/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.JButton;
import org.jdesktop.application.Resource;
import org.limewire.ui.swing.components.CustomHyperlinkUI;
import org.limewire.ui.swing.util.FontUtils;
import org.limewire.ui.swing.util.GuiUtils;

public class HyperlinkButton
extends JButton
implements MouseListener {
    private final HyperlinkButtonResources r = new HyperlinkButtonResources();

    public HyperlinkButton() {
        this.initialize();
    }

    public HyperlinkButton(Action action) {
        super(action);
        this.initialize();
    }

    public HyperlinkButton(String text) {
        this.initialize();
        this.setText(text);
    }

    public HyperlinkButton(String text, Action action) {
        super(action);
        this.setHideActionText(true);
        this.setText(text);
        this.initialize();
    }

    private void initialize() {
        this.setUI(new CustomHyperlinkUI());
        this.addMouseListener(this);
        FontUtils.underline(this);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (!FontUtils.isUnderlined(this)) {
            FontUtils.underline(this);
        }
    }

    public void removeUnderline() {
        Font font = this.getFont();
        if (font != null) {
            super.setFont(FontUtils.deriveUnderline(font, false));
        }
    }

    private void updateForeground() {
        if (this.isEnabled()) {
            if (this.getModel().isRollover()) {
                super.setForeground(this.r.rolloverForeground);
            } else {
                super.setForeground(this.r.foreground);
            }
        } else {
            super.setForeground(this.r.disabledForeground);
        }
    }

    public void setNormalForeground(Color color) {
        this.r.foreground = color;
        this.updateForeground();
    }

    public void setRolloverForeground(Color color) {
        this.r.rolloverForeground = color;
        this.updateForeground();
    }

    public void setDisabledForeground(Color color) {
        this.r.disabledForeground = color;
        this.updateForeground();
    }

    @Override
    public void setEnabled(boolean value) {
        super.setEnabled(value);
        if (this.r != null) {
            this.updateForeground();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.updateForeground();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.updateForeground();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    private class HyperlinkButtonResources {
        @Resource
        Color rolloverForeground;
        @Resource
        Color foreground;
        @Resource
        Color disabledForeground;

        public HyperlinkButtonResources() {
            GuiUtils.assignResources(this);
            HyperlinkButton.super.setForeground(this.foreground);
        }
    }
}

