/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Insets;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.ShiftedIcon;
import org.limewire.ui.swing.listener.ActionHandListener;

public class IconButton
extends JButton {
    private MouseListener actionHandListener;

    public IconButton() {
        this.init();
    }

    public IconButton(Action a) {
        super(a);
        this.init();
    }

    public IconButton(Icon icon) {
        super(icon);
        this.init();
    }

    public IconButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public IconButton(Icon icon, Icon rolloverIcon) {
        super(icon);
        this.init();
        this.setRolloverIcon(rolloverIcon);
    }

    public IconButton(Icon icon, Icon rolloverIcon, Icon pressedIcon) {
        super(icon);
        this.init();
        this.setRolloverIcon(rolloverIcon);
        this.setPressedIcon(pressedIcon);
    }

    public IconButton(Icon icon, Icon rolloverIcon, Icon pressedIcon, Icon selectedIcon) {
        super(icon);
        this.init();
        this.setRolloverIcon(rolloverIcon);
        this.setPressedIcon(pressedIcon);
        this.setSelectedIcon(selectedIcon);
    }

    @Override
    public void setIcon(Icon defaultIcon) {
        super.setIcon(defaultIcon);
        if (this.getSelectedIcon() == null || this.getSelectedIcon() instanceof CustomShiftedIcon) {
            if (defaultIcon == null) {
                this.setSelectedIcon(null);
            } else {
                this.setSelectedIcon(new CustomShiftedIcon(1, 1, defaultIcon));
            }
        }
    }

    public static void setIconButtonProperties(JButton button) {
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setFocusPainted(false);
        button.setRolloverEnabled(false);
        button.setHideActionText(true);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setOpaque(false);
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        button.setIconTextGap(2);
    }

    private void init() {
        IconButton.setIconButtonProperties(this);
        this.actionHandListener = new ActionHandListener();
        this.addMouseListener(this.actionHandListener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        ActionHandListener.setActionHandDrawingDisabled(this, !enabled);
    }

    public void removeActionHandListener() {
        this.removeMouseListener(this.actionHandListener);
    }

    public void resetDefaultCursor() {
        ActionHandListener.resetDefaultCursor(this);
    }

    @Override
    protected void configurePropertiesFromAction(Action a) {
        Icon icon;
        super.configurePropertiesFromAction(a);
        if (IconButton.hasSelectedKey(a)) {
            this.setSelectedFromAction(a);
        }
        if ((icon = (Icon)a.getValue(AbstractAction.PRESSED_ICON)) != null) {
            this.setPressedIcon(icon);
        }
        if ((icon = (Icon)a.getValue(AbstractAction.ROLLOVER_ICON)) != null) {
            this.setRolloverIcon(icon);
        }
    }

    @Override
    protected void actionPropertyChanged(Action action, String propertyName) {
        super.actionPropertyChanged(action, propertyName);
        if (propertyName == "SwingSelectedKey" && IconButton.hasSelectedKey(action)) {
            this.setSelectedFromAction(action);
        } else if (propertyName == AbstractAction.PRESSED_ICON) {
            this.setPressedIcon((Icon)action.getValue(AbstractAction.PRESSED_ICON));
        } else if (propertyName == AbstractAction.ROLLOVER_ICON) {
            this.setRolloverIcon((Icon)action.getValue(AbstractAction.ROLLOVER_ICON));
        }
    }

    private void setSelectedFromAction(Action a) {
        boolean selected = false;
        if (a != null) {
            selected = Boolean.TRUE.equals(a.getValue("SwingSelectedKey"));
        }
        if (selected != this.isSelected()) {
            this.setSelected(selected);
        }
    }

    private static boolean hasSelectedKey(Action a) {
        return a != null && a.getValue("SwingSelectedKey") != null;
    }

    private static class CustomShiftedIcon
    extends ShiftedIcon {
        public CustomShiftedIcon(int shiftWidth, int shiftHeight, Icon icon) {
            super(shiftWidth, shiftHeight, icon);
        }
    }
}

