/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.limewire.ui.swing.components.LimeJDialog;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class YesNoCheckBoxDialog
extends LimeJDialog {
    public static final String YES_COMMAND = "YES";
    public static final String NO_COMMAND = "NO";
    private JButton yesButton = null;
    private JButton noButton = null;
    private JCheckBox checkBox;
    private String selectedCommand;

    public YesNoCheckBoxDialog(String message, String checkBoxMessage, boolean checked) {
        this(message, checkBoxMessage, checked, I18n.tr("Yes"), I18n.tr("No"));
    }

    public YesNoCheckBoxDialog(String message, String checkBoxMessage, boolean checked, String yesLabel, String noLabel) {
        this("", message, checkBoxMessage, checked, yesLabel, noLabel);
    }

    public YesNoCheckBoxDialog(String title, String message, String checkBoxMessage, boolean checked, String yesLabel, String noLabel) {
        super((Frame)GuiUtils.getMainFrame(), title);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        JPanel panel = new JPanel();
        MultiLineLabel messageLabel = new MultiLineLabel(message, 350);
        this.checkBox = new JCheckBox(checkBoxMessage);
        this.checkBox.setSelected(checked);
        this.yesButton = new JButton(yesLabel);
        this.yesButton.setActionCommand(YES_COMMAND);
        this.yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                YesNoCheckBoxDialog.this.selectedCommand = YesNoCheckBoxDialog.YES_COMMAND;
                YesNoCheckBoxDialog.this.dispose();
            }
        });
        this.noButton = new JButton(noLabel);
        this.noButton.setActionCommand(NO_COMMAND);
        this.noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                YesNoCheckBoxDialog.this.selectedCommand = YesNoCheckBoxDialog.NO_COMMAND;
                YesNoCheckBoxDialog.this.dispose();
            }
        });
        panel.setLayout(new MigLayout("", "", ""));
        panel.add((Component)messageLabel, "wrap");
        panel.add((Component)this.checkBox, "wrap");
        panel.add((Component)this.yesButton, "alignx right");
        panel.add((Component)this.noButton, "alignx right");
        this.setContentPane(panel);
        this.pack();
    }

    public void addActionListener(ActionListener actionListener) {
        this.yesButton.addActionListener(actionListener);
        this.noButton.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.yesButton.removeActionListener(actionListener);
        this.noButton.removeActionListener(actionListener);
    }

    public synchronized boolean isCheckBoxSelected() {
        return this.checkBox.isSelected();
    }

    public boolean isConfirmed() {
        return this.selectedCommand == YES_COMMAND;
    }
}

