/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.filter;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.UniqueList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.swing.DefaultEventListModel;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.Category;
import org.limewire.ui.swing.components.RolloverCursorListener;
import org.limewire.ui.swing.filter.AbstractFilter;
import org.limewire.ui.swing.filter.CategoryMatcher;
import org.limewire.ui.swing.filter.FilterableItem;
import org.limewire.ui.swing.filter.UniqueListFactory;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.Objects;

class CategoryFilter<E extends FilterableItem>
extends AbstractFilter<E> {
    private final JPanel panel = new JPanel();
    private final JLabel categoryLabel = new JLabel();
    private final JXList list = new JXList();
    private Category selectedCategory;
    private EventList<Category> categoryList;
    private UniqueListFactory<Category> uniqueListFactory;
    private UniqueList<Category> uniqueList;
    private DefaultEventListModel<Category> listModel;
    private DefaultEventSelectionModel<Category> selectionModel;

    public CategoryFilter(EventList<E> resultsList) {
        AbstractFilter.FilterResources resources = this.getResources();
        this.panel.setLayout(new MigLayout("insets 0 0 0 0, gap 0!", "[left,grow]", ""));
        this.panel.setOpaque(false);
        this.categoryLabel.setFont(resources.getHeaderFont());
        this.categoryLabel.setForeground(resources.getHeaderColor());
        this.categoryLabel.setText(I18n.tr("Categories"));
        this.list.setCellRenderer((ListCellRenderer)new CategoryCellRenderer());
        this.list.setFont(resources.getRowFont());
        this.list.setForeground(resources.getRowColor());
        this.list.setOpaque(false);
        this.list.setRolloverEnabled(true);
        this.list.setSelectionMode(0);
        this.list.setHighlighters(new ColorHighlighter(HighlightPredicate.ROLLOVER_ROW, resources.getHighlightBackground(), resources.getHighlightForeground()));
        new RolloverCursorListener().install(this.list);
        this.panel.add((Component)this.categoryLabel, "gap 6 6, wrap");
        this.panel.add((Component)this.list, "grow");
        this.initialize(resultsList);
    }

    private void initialize(EventList<E> resultsList) {
        this.categoryList = this.createCategoryList(resultsList);
        this.uniqueListFactory = new UniqueListFactory<Category>(this.categoryList, new CategoryComparator());
        this.uniqueListFactory.setName(I18n.tr("Categories"));
        this.uniqueList = this.uniqueListFactory.getUniqueList();
        this.categoryLabel.setVisible(this.uniqueList.size() > 0);
        this.uniqueList.addListEventListener((ListEventListener<Category>)new ListEventListener<Object>(){

            @Override
            public void listChanged(ListEvent<Object> listChanges) {
                if (!CategoryFilter.this.categoryLabel.isVisible() && CategoryFilter.this.uniqueList.size() > 0) {
                    CategoryFilter.this.categoryLabel.setVisible(true);
                } else if (CategoryFilter.this.categoryLabel.isVisible() && CategoryFilter.this.uniqueList.size() < 1) {
                    CategoryFilter.this.categoryLabel.setVisible(false);
                }
            }
        });
        this.listModel = new DefaultEventListModel<Category>(this.uniqueList);
        this.selectionModel = new DefaultEventSelectionModel<Category>(this.uniqueList);
        this.list.setModel(this.listModel);
        this.list.setSelectionModel(this.selectionModel);
        this.selectionModel.addListSelectionListener(new SelectionListener());
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public void reset() {
        this.selectionModel.clearSelection();
        this.selectedCategory = null;
        this.deactivate();
    }

    @Override
    public void dispose() {
        this.uniqueListFactory.dispose();
        this.categoryList.dispose();
    }

    @Override
    protected void activate(String activeText, Matcher<E> matcher) {
        super.activate(activeText, matcher);
        this.getComponent().setVisible(false);
    }

    @Override
    protected void deactivate() {
        super.deactivate();
        this.getComponent().setVisible(true);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName()).append("[");
        buf.append("uniqueItems=").append(this.uniqueList.size());
        buf.append(", active=").append(this.isActive());
        EventList<Category> selectedList = this.selectionModel.getSelected();
        buf.append(", selection=").append(selectedList.size() > 0 ? (Serializable)selectedList.get(0) : "null");
        buf.append("]");
        return buf.toString();
    }

    public int getCategoryCount() {
        return this.uniqueList.size();
    }

    public Category getDefaultCategory() {
        Category defaultCategory = null;
        int defaultCount = 0;
        for (Category category : this.uniqueList) {
            int count = this.uniqueList.getCount(category);
            if (count <= defaultCount) continue;
            defaultCount = count;
            defaultCategory = category;
        }
        return defaultCategory;
    }

    public Category getSelectedCategory() {
        return this.selectedCategory;
    }

    private EventList<Category> createCategoryList(EventList<E> resultsList) {
        return GlazedListsFactory.simpleFunctionList(resultsList, new CategoryFunction());
    }

    private static class CategoryFunction<E extends FilterableItem>
    implements FunctionList.Function<E, Category> {
        private CategoryFunction() {
        }

        @Override
        public Category evaluate(E item) {
            return item.getCategory();
        }
    }

    private static class CategoryComparator
    implements Comparator<Category> {
        private CategoryComparator() {
        }

        @Override
        public int compare(Category cat1, Category cat2) {
            return Objects.compareToNullIgnoreCase(cat1.toString(), cat2.toString(), false);
        }
    }

    private class CategoryCellRenderer
    extends DefaultListCellRenderer {
        private final Color background;
        private final Border border;

        private CategoryCellRenderer() {
            this.background = CategoryFilter.this.getResources().getBackground();
            this.border = BorderFactory.createEmptyBorder(1, 7, 0, 7);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component renderer = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (renderer instanceof JLabel) {
                int count = CategoryFilter.this.uniqueList.getCount((Category)((Object)value));
                StringBuilder buf = new StringBuilder();
                buf.append(value.toString()).append(" (").append(count).append(")");
                ((JLabel)renderer).setText(buf.toString());
                ((JLabel)renderer).setBackground(this.background);
                ((JLabel)renderer).setBorder(this.border);
            }
            return renderer;
        }
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (CategoryFilter.this.isActive()) {
                return;
            }
            EventList selectedList = CategoryFilter.this.selectionModel.getSelected();
            if (selectedList.size() > 0) {
                CategoryFilter.this.selectedCategory = (Category)((Object)selectedList.get(0));
                CategoryMatcher newMatcher = new CategoryMatcher(CategoryFilter.this.selectedCategory);
                CategoryFilter.this.activate(CategoryFilter.this.selectedCategory.toString(), newMatcher);
            } else {
                CategoryFilter.this.selectedCategory = null;
                CategoryFilter.this.deactivate();
            }
            CategoryFilter.this.fireFilterChanged(CategoryFilter.this);
        }
    }
}

