/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.chat;

import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.text.html.StyleSheet;
import org.jdesktop.application.Resource;
import org.limewire.ui.swing.friends.chat.AbstractMessageImpl;
import org.limewire.ui.swing.friends.chat.Message;
import org.limewire.ui.swing.friends.chat.MessageText;
import org.limewire.ui.swing.friends.chat.URLWrapper;
import org.limewire.ui.swing.util.GuiUtils;

class MessageTextImpl
extends AbstractMessageImpl
implements MessageText {
    private static final int MAX_LENGTH_PIXELS = 250;
    private final String message;
    @Resource(key="ChatInputPanel.textFont")
    private Font textFont;

    public MessageTextImpl(String senderName, String chatFriendId, Message.Type type, String message) {
        super(senderName, chatFriendId, type);
        GuiUtils.assignResources(this);
        this.message = message;
    }

    @Override
    public String getMessageText() {
        return this.message;
    }

    public String toString() {
        return this.getMessageText();
    }

    @Override
    public String format() {
        return this.insertBreaksAddAnchorsTags(this.message.replace("<", "&lt;").replace(">", "&gt;"));
    }

    private String insertBreaksAddAnchorsTags(String wrap) {
        StringTokenizer stringTokenizer = new StringTokenizer(wrap, " \n\t\r");
        StringBuffer htmlString = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            boolean isURL = URLWrapper.isURL(token);
            StringBuffer brokenString = new StringBuffer();
            String[] brokenTokens = this.breakString(token);
            for (int i = 0; i < brokenTokens.length; ++i) {
                brokenString.append(brokenTokens[i]);
                if (brokenTokens.length <= 1) continue;
                brokenString.append("<wbr>");
            }
            if (isURL) {
                htmlString.append(URLWrapper.createAnchorTag(token, brokenString.toString().trim()));
            } else {
                htmlString.append(brokenString.toString());
            }
            if (!stringTokenizer.hasMoreTokens()) continue;
            htmlString.append(" ");
        }
        return htmlString.toString();
    }

    private String[] breakString(String token) {
        int maxCharacters = this.getMaxCharacters(token);
        ArrayList<String> brokenStrings = new ArrayList<String>();
        int index = 0;
        int length = token.length();
        while (index < length) {
            int start = index;
            int end = index + maxCharacters;
            if (end > length) {
                end = length;
            }
            String brokenString = token.substring(start, end);
            brokenStrings.add(brokenString);
            index = end;
        }
        return brokenStrings.toArray(new String[brokenStrings.size()]);
    }

    private int getMaxCharacters(String token) {
        int pixelWidth1Character = this.getAverageCharacterWidthInString(token, this.textFont);
        return 250 / pixelWidth1Character;
    }

    private int getAverageCharacterWidthInString(String text, Font font) {
        StyleSheet css = new StyleSheet();
        FontMetrics fontMetrics = css.getFontMetrics(font);
        int averageCharacterWidthForFont = (int)Math.ceil((double)fontMetrics.stringWidth(text) / (double)text.length());
        return averageCharacterWidthForFont;
    }
}

