/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.navigator;

import ca.odell.glazedlists.EventList;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.limewire.core.api.library.LocalFileList;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.core.api.library.SharedFileListManager;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.inject.LazySingleton;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.dnd.GhostDragGlassPane;
import org.limewire.ui.swing.library.navigator.CreateListAction;
import org.limewire.ui.swing.library.navigator.LibraryNavItem;
import org.limewire.ui.swing.library.navigator.LibraryNavPopupHandler;
import org.limewire.ui.swing.library.navigator.LibraryNavTableEditor;
import org.limewire.ui.swing.library.navigator.LibraryNavTableRenderer;
import org.limewire.ui.swing.library.navigator.LibraryNavigatorTable;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

@LazySingleton
public class LibraryNavigatorPanel
extends JXPanel {
    @Resource
    private Color backgroundColor;
    @Resource
    private Color borderColor;
    @Resource
    private Font createListFont;
    private final LibraryNavigatorTable table;
    private final CreateListAction createAction;
    private final SharedFileListManager sharedFileListManager;
    private HyperlinkButton createListButton;

    @Inject
    public LibraryNavigatorPanel(LibraryNavigatorTable table, LibraryNavTableRenderer renderer, LibraryNavTableEditor editor, LibraryNavPopupHandler popupHandler, CreateListAction createAction, SharedFileListManager sharedFileListManager, GhostDragGlassPane ghostGlassPane) {
        super(new MigLayout("insets 0, gap 0, fillx", "[150!]", ""));
        this.table = table;
        this.sharedFileListManager = sharedFileListManager;
        this.createAction = createAction;
        GuiUtils.assignResources(this);
        this.setBackground(this.backgroundColor);
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, this.borderColor));
        JPanel panel = new JPanel(new MigLayout("fill, gap 0, insets 0"));
        panel.setBackground(this.backgroundColor);
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        panel.add((Component)table, "grow, wrap");
        table.getColumnModel().getColumn(0).setCellRenderer(renderer);
        table.getColumnModel().getColumn(0).setCellEditor(editor);
        table.setPopupHandler(popupHandler);
        this.add((Component)scrollPane, "growx, growy, wrap");
        this.createCreateListButton();
        panel.add((Component)this.createListButton, "aligny top, gapbottom 5, gapleft 30");
        this.initData();
    }

    @Inject
    void register(ListenerSupport<FriendConnectionEvent> connectionEvent) {
        connectionEvent.addListener(new EventListener<FriendConnectionEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(FriendConnectionEvent event) {
                EventList<SharedFileList> listsModel;
                if (event.getType() == FriendConnectionEvent.Type.CONNECTED && (listsModel = LibraryNavigatorPanel.this.sharedFileListManager.getModel()).size() == 1) {
                    LibraryNavigatorPanel.this.createPrivateShareList();
                }
            }
        });
        this.table.getColumnModel().getColumn(0).getCellEditor().addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
                LibraryNavigatorPanel.this.createListButton.setEnabled(true);
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                LibraryNavigatorPanel.this.createListButton.setEnabled(true);
            }
        });
    }

    private void createPrivateShareList() {
        this.sharedFileListManager.createNewSharedFileList(I18n.tr("Private Shared"));
    }

    private void initData() {
        this.table.getSelectionModel().setSelectionInterval(0, 0);
    }

    private void createCreateListButton() {
        this.createListButton = new HyperlinkButton(I18n.tr("Create List"), this.createAction);
        this.createListButton.setFont(this.createListFont);
    }

    public void selectLocalFileList(LocalFileList localFileList) {
        this.table.selectLibraryNavItem(localFileList);
    }

    public void addTableSelectionListener(ListSelectionListener listener) {
        this.table.getSelectionModel().addListSelectionListener(listener);
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public LibraryNavItem getSelectedNavItem() {
        return this.table.getSelectedItem();
    }

    public void editSharedListName(SharedFileList sharedFileList) {
        assert (!sharedFileList.isPublic());
        this.selectLocalFileList(sharedFileList);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LibraryNavigatorPanel.this.table.setEditable(true);
                LibraryNavigatorPanel.this.table.editCellAt(LibraryNavigatorPanel.this.getSelectedRow(), 0);
                LibraryNavigatorPanel.this.createListButton.setEnabled(false);
            }
        });
    }

    public int getPrivateListCount() {
        return this.table.getPrivateSharedLibraryCount();
    }
}

