/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.mainframe;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Stage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Resource;
import org.jdesktop.application.SessionStorage;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.limewire.core.api.Application;
import org.limewire.core.impl.MockModule;
import org.limewire.core.settings.GeocodeSettings;
import org.limewire.core.settings.InstallSettings;
import org.limewire.core.settings.LWSSettings;
import org.limewire.geocode.GeocodeInformation;
import org.limewire.inject.GuiceUtils;
import org.limewire.inject.LimeWireInjectModule;
import org.limewire.inject.Modules;
import org.limewire.inspection.Inspector;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.ui.swing.LimeWireSwingUiModule;
import org.limewire.ui.swing.browser.LimeMozillaInitializer;
import org.limewire.ui.swing.components.LimeJFrame;
import org.limewire.ui.swing.components.PlainCheckBoxMenuItemUI;
import org.limewire.ui.swing.components.PlainMenuItemUI;
import org.limewire.ui.swing.components.PlainMenuUI;
import org.limewire.ui.swing.components.PlainWindowsCheckBoxMenuItemUI;
import org.limewire.ui.swing.components.PlainWindowsMenuItemUI;
import org.limewire.ui.swing.components.PlainWindowsMenuUI;
import org.limewire.ui.swing.mainframe.DelayedShutdownHandler;
import org.limewire.ui.swing.mainframe.FramePositioner;
import org.limewire.ui.swing.mainframe.LimeWireSwingUI;
import org.limewire.ui.swing.mainframe.NullSessionStorage;
import org.limewire.ui.swing.menu.LimeMenuBar;
import org.limewire.ui.swing.options.OptionsDialog;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.shell.ShellAssociationManager;
import org.limewire.ui.swing.tray.TrayExitListener;
import org.limewire.ui.swing.tray.TrayNotifier;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.SaveDirectoryHandler;
import org.limewire.ui.swing.wizard.SetupWizard;
import org.limewire.util.OSUtils;
import org.mozilla.browser.MozillaInitialization;

public class AppFrame
extends SingleFrameApplication {
    private static final Log LOG = LogFactory.getLog(AppFrame.class);
    public static final String STARTUP = "startup";
    private boolean isStartup = false;
    @Inject
    private static volatile Injector injector;
    private static volatile boolean started;
    @Resource
    private Color bgColor;
    @Resource
    private Color glassPaneColor;
    @Resource
    private Color selectionBackgroundColor;
    @Resource
    private Icon upFolderVistaFixIcon;
    @Resource
    private Icon detailsViewVistaFixIcon;
    @Resource
    private Icon listViewVistaFixIcon;
    @Resource
    private Icon newFolderVistaFixIcon;
    @Inject
    private Application application;
    @Inject
    private LimeWireSwingUI ui;
    @Inject
    private Provider<SetupWizard> setupWizardProvider;
    @Inject
    private Provider<OptionsDialog> options;
    @Inject
    private FramePositioner framePositioner;
    @Inject
    private TrayNotifier trayNotifier;
    @Inject
    private LimeMenuBar limeMenuBar;
    @Inject
    private DelayedShutdownHandler delayedShutdownHandler;
    @Inject
    private Provider<GeocodeInformation> geoLocation;
    private OptionsDialog lastOptionsDialog;

    public static void main(String[] args) {
        AppFrame.launch(AppFrame.class, args);
    }

    public static boolean isStarted() {
        return started;
    }

    private void changeSessionStorage(ApplicationContext ctx, SessionStorage storage) {
        try {
            Method m = ctx.getClass().getDeclaredMethod("setSessionStorage", SessionStorage.class);
            m.setAccessible(true);
            m.invoke((Object)ctx, storage);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void initialize(String[] args) {
        this.changeSessionStorage(this.getContext(), new NullSessionStorage(this.getContext()));
        GuiUtils.assignResources(this);
        this.initUIDefaults();
        if (MozillaInitialization.getStatus() != MozillaInitialization.InitStatus.FAILED) {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        }
        this.isStartup = args.length > 0 && STARTUP.equals(args[0]);
    }

    @Override
    protected void startup() {
        String title = this.getContext().getResourceMap().getString("Application.title", new Object[0]);
        FirstVizIgnorer frame = new FirstVizIgnorer(title);
        frame.setName("mainFrame");
        this.getMainView().setFrame(frame);
        assert (this.ui == null);
        this.createUiInjector();
        assert (this.ui != null);
        if (this.isStartup || SwingUiSettings.MINIMIZE_TO_TRAY.getValue()) {
            this.trayNotifier.showTrayIcon();
        } else {
            this.trayNotifier.hideTrayIcon();
        }
        this.getMainFrame().setJMenuBar(this.limeMenuBar);
        this.delayedShutdownHandler.install(this);
        this.addExitListener(new TrayExitListener(this.trayNotifier));
        if (OSUtils.isMacOSX()) {
            this.addExitListener(new Application.ExitListener(){

                @Override
                public boolean canExit(EventObject event) {
                    if (event.getSource() instanceof JFrame) {
                        AppFrame.this.hide(AppFrame.this.getMainView());
                        return false;
                    }
                    return true;
                }

                @Override
                public void willExit(EventObject event) {
                }
            });
        }
        this.addExitListener(new ShutdownListener(this.getMainFrame(), this.application));
        this.framePositioner.initialize(this.getMainFrame());
        this.show(this.ui);
        this.framePositioner.setWindowPosition();
        if (this.isStartup) {
            this.minimizeToTray();
        } else {
            this.getMainFrame().setVisible(true);
        }
        this.ui.goHome();
        this.ui.focusOnSearch();
        started = true;
    }

    @Override
    protected void ready() {
        if (this.application.isNewInstall()) {
            this.initializeNewInstall();
        }
        if (SetupWizard.shouldShowWizard()) {
            this.showSetupWizard();
        }
        if (!LWSSettings.HAS_LOADED_LWS_GEO.getValue()) {
            if (this.geoLocation.get().isEmpty()) {
                GeocodeSettings.GEO_LOCATION.addSettingListener(new SettingListener(){

                    @Override
                    public void settingChanged(SettingEvent evt) {
                        if (!((GeocodeInformation)AppFrame.this.geoLocation.get()).isEmpty()) {
                            AppFrame.this.updateGeoLocation();
                            GeocodeSettings.GEO_LOCATION.removeSettingListener(this);
                        }
                    }
                });
            }
            if (!this.geoLocation.get().isEmpty()) {
                this.updateGeoLocation();
            }
        }
        InstallSettings.UPGRADED_TO_5.setValue(true);
        this.validateSaveDirectory();
        Thread eventThread = Thread.currentThread();
        eventThread.setPriority(eventThread.getPriority() + 1);
        new ShellAssociationManager().validateFileAssociations(this.getMainFrame());
        if (!this.isStartup) {
            this.ui.loadProNag();
        }
    }

    private void initializeNewInstall() {
        LWSSettings.HAS_LOADED_LWS_GEO.set(false);
        SwingUiSettings.SHOW_STORE_COMPONENTS.set(false);
        if (!this.geoLocation.get().isEmpty()) {
            this.updateGeoLocation();
        }
        this.showSetupWizard();
        InstallSettings.UPGRADED_TO_5.setValue(true);
        InstallSettings.LAST_VERSION_RUN.set(this.application.getVersion());
        InstallSettings.PREVIOUS_RAN_VERSIONS.add(this.application.getVersion());
    }

    private void showSetupWizard() {
        JXPanel glassPane = new JXPanel();
        glassPane.setOpaque(false);
        glassPane.setBackgroundPainter(new AbstractPainter<JComponent>(){

            @Override
            protected void doPaint(Graphics2D g, JComponent object, int width, int height) {
                g.setPaint(AppFrame.this.glassPaneColor);
                g.fillRect(0, 0, width, height);
            }
        });
        this.getMainFrame().setGlassPane(glassPane);
        this.ui.hideMainPanel();
        glassPane.setVisible(true);
        this.setupWizardProvider.get().showDialog(this.getMainFrame());
        glassPane.setVisible(false);
        this.ui.showMainPanel();
    }

    private synchronized void updateGeoLocation() {
        if (!LWSSettings.HAS_LOADED_LWS_GEO.getValue()) {
            String[] validCountryCodes = LWSSettings.LWS_VALID_COUNTRY_CODES.get();
            boolean showStoreComponents = false;
            for (String country : validCountryCodes) {
                if (!country.equals(this.geoLocation.get().getProperty(GeocodeInformation.Property.CountryCode))) continue;
                showStoreComponents = true;
                break;
            }
            LWSSettings.HAS_LOADED_LWS_GEO.set(true);
            SwingUiSettings.SHOW_STORE_COMPONENTS.set(showStoreComponents);
        }
    }

    @Action
    public void showOptionsDialog(ActionEvent actionEvent) {
        if (this.lastOptionsDialog == null) {
            this.lastOptionsDialog = this.options.get();
        }
        if (!this.lastOptionsDialog.isVisible()) {
            this.lastOptionsDialog.initOptions();
            GuiUtils.getMainFrame().setVisible(true);
            this.lastOptionsDialog.setLocationRelativeTo(GuiUtils.getMainFrame());
            if (actionEvent.getID() == 1001 && actionEvent.getActionCommand() != null) {
                this.lastOptionsDialog.select(actionEvent.getActionCommand());
            }
            this.lastOptionsDialog.setVisible(true);
        }
    }

    @Action
    public void exitApplication(ActionEvent actionEvent) {
        this.exit(actionEvent);
    }

    @Action
    public void minimizeToTray() {
        this.getMainFrame().setState(1);
        this.getMainFrame().setVisible(!this.trayNotifier.supportsSystemTray());
    }

    @Action
    public void restoreView() {
        if (!SwingUiSettings.MINIMIZE_TO_TRAY.getValue()) {
            this.trayNotifier.hideTrayIcon();
        }
        this.getMainFrame().setVisible(true);
        this.getMainFrame().setState(0);
        this.getMainFrame().toFront();
        this.ui.loadProNag();
    }

    @Action
    public void shutdownAfterTransfers() {
        this.trayNotifier.showTrayIcon();
        this.delayedShutdownHandler.shutdownAfterTransfers();
    }

    private Injector createUiInjector() {
        Injector childInjector;
        AbstractModule thiz = new AbstractModule(){

            @Override
            protected void configure() {
                this.bind(AppFrame.class).toInstance(AppFrame.this);
            }
        };
        if (injector == null) {
            LimeMozillaInitializer.initialize();
            childInjector = Guice.createInjector(Stage.DEVELOPMENT, new Module[]{new MockModule(), new LimeWireInjectModule(), new LimeWireSwingUiModule(false), thiz});
        } else {
            childInjector = Guice.createInjector(Stage.DEVELOPMENT, Modules.providersFrom(injector), new LimeWireInjectModule(), thiz, new LimeWireSwingUiModule(injector.getInstance(Application.class).isProVersion()), new AbstractModule(){

                @Override
                protected void configure() {
                    this.requestInjection(new Object(){

                        @Inject
                        void setInspectorInjector(Inspector inspector, Injector injector) {
                            inspector.setInjector(injector);
                        }
                    });
                }
            });
        }
        GuiceUtils.loadEagerSingletons(childInjector);
        return childInjector;
    }

    private void initUIDefaults() {
        if (OSUtils.isMacOSX()) {
            this.initMacUIDefaults();
        }
        if (OSUtils.isWindows()) {
            this.verifyWindowsLAF();
        }
        this.initBackgrounds();
        Color originalSelectionBackground = (Color)UIManager.get("MenuItem.selectionBackground");
        Color originalSelectionForeground = (Color)UIManager.get("MenuItem.selectionForeground");
        if (originalSelectionForeground != null && originalSelectionBackground != null) {
            PlainMenuUI.overrideDefaults(originalSelectionForeground, originalSelectionBackground);
            PlainMenuItemUI.overrideDefaults(originalSelectionForeground, originalSelectionBackground);
            PlainCheckBoxMenuItemUI.overrideDefaults(originalSelectionForeground, originalSelectionBackground);
            PlainWindowsMenuUI.overrideDefaults(originalSelectionForeground, originalSelectionBackground);
            PlainWindowsMenuItemUI.overrideDefaults(originalSelectionForeground, originalSelectionBackground);
            PlainWindowsCheckBoxMenuItemUI.overrideDefaults(originalSelectionForeground, originalSelectionBackground);
        }
        UIManager.put("TextField.selectionBackground", this.selectionBackgroundColor);
        UIManager.put("PasswordField.selectionBackground", this.selectionBackgroundColor);
        UIManager.put("EditorPane.selectionBackground", this.selectionBackgroundColor);
        UIManager.put("TextArea.selectionBackground", this.selectionBackgroundColor);
        UIManager.put("Menu.selectionBackground", this.selectionBackgroundColor);
        UIManager.put("MenuItem.selectionBackground", this.selectionBackgroundColor);
        UIManager.put("CheckBoxMenuItem.selectionBackground", this.selectionBackgroundColor);
        UIManager.put("RadioButtonMenuItem.selectionBackground", this.selectionBackgroundColor);
        Color selectionForeground = Color.BLACK;
        UIManager.put("TextField.selectionForeground", selectionForeground);
        UIManager.put("PasswordField.selectionForeground", selectionForeground);
        UIManager.put("EditorPane.selectionForeground", selectionForeground);
        UIManager.put("TextArea.selectionForeground", selectionForeground);
        UIManager.put("Menu.selectionForeground", selectionForeground);
        UIManager.put("MenuItem.selectionForeground", selectionForeground);
        UIManager.put("CheckBoxMenuItem.selectionForeground", selectionForeground);
        UIManager.put("RadioButtonMenuItem.selectionForeground", selectionForeground);
        UIManager.put("PopupMenu.consumeEventOnClose", false);
        if (OSUtils.isWindows()) {
            this.replaceIconIfFailing("FileChooser.upFolderIcon", this.upFolderVistaFixIcon);
            this.replaceIconIfFailing("FileChooser.detailsViewIcon", this.detailsViewVistaFixIcon);
            this.replaceIconIfFailing("FileChooser.listViewIcon", this.listViewVistaFixIcon);
            this.replaceIconIfFailing("FileChooser.newFolderIcon", this.newFolderVistaFixIcon);
        }
    }

    private void initMacUIDefaults() {
        UIManager.put("MenuItemUI", "javax.swing.plaf.basic.BasicMenuItemUI");
        UIManager.put("CheckBoxMenuItemUI", "javax.swing.plaf.basic.BasicCheckBoxMenuItemUI");
        UIManager.put("RadioButtonMenuItemUI", "javax.swing.plaf.basic.BasicRadioButtonMenuItemUI");
        UIManager.put("MenuUI", "javax.swing.plaf.basic.BasicMenuUI");
        UIManager.put("Menu.selectionBackground", this.selectionBackgroundColor);
        UIManager.put("Menu.selectionForeground", Color.BLACK);
    }

    private void initBackgrounds() {
        ColorUIResource bgColorResource = new ColorUIResource(this.bgColor);
        Color oldBgColor = UIManager.getDefaults().getColor("Panel.background");
        UIDefaults uiDefaults = UIManager.getDefaults();
        Enumeration enumeration = uiDefaults.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            if (key.toString().indexOf("background") == -1 || !uiDefaults.get(key).equals(oldBgColor)) continue;
            UIManager.getDefaults().put(key, bgColorResource);
        }
        uiDefaults.put("Table.background", bgColorResource);
    }

    private void replaceIconIfFailing(String resource, Icon replacementIcon) {
        try {
            UIManager.getIcon(resource);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            UIManager.put(resource, replacementIcon);
        }
    }

    private void validateSaveDirectory() {
        SaveDirectoryHandler.validateSaveDirectoryAndPromptForNewOne();
    }

    private void verifyWindowsLAF() {
        String lafName = UIManager.getLookAndFeel().getClass().getName();
        if (!UIManager.getSystemLookAndFeelClassName().equals(lafName)) {
            return;
        }
        boolean lafValid = true;
        try {
            JCheckBox checkBox = new JCheckBox("Verify");
            checkBox.getPreferredSize();
        }
        catch (NullPointerException npe) {
            LOG.error("Windows XP LAF error", npe);
            lafValid = false;
        }
        if (!lafValid) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception ex) {
                LOG.error("Unable to install LAF", ex);
            }
        }
    }

    private static class FirstVizIgnorer
    extends LimeJFrame {
        private boolean shownOnce = false;

        public FirstVizIgnorer(String title) {
            super(title);
        }

        @Override
        public void setVisible(boolean visible) {
            if (!this.shownOnce) {
                this.shownOnce = true;
            } else {
                super.setVisible(visible);
            }
        }

        @Override
        public void hide() {
            try {
                super.hide();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class ShutdownListener
    implements Application.ExitListener {
        private final Application application;
        private final JFrame mainFrame;

        public ShutdownListener(JFrame mainFrame, Application application) {
            this.mainFrame = mainFrame;
            this.application = application;
        }

        @Override
        public boolean canExit(EventObject event) {
            return true;
        }

        @Override
        public void willExit(EventObject event) {
            this.mainFrame.setVisible(false);
            System.out.println("Shutting down...");
            this.application.stopCore();
            System.out.println("Shut down");
        }
    }
}

