/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import com.google.inject.Inject;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.limewire.core.api.connection.GnutellaConnectionManager;
import org.limewire.core.api.network.NetworkManager;
import org.limewire.core.settings.DHTSettings;
import org.limewire.core.settings.SearchSettings;
import org.limewire.core.settings.UltrapeerSettings;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.I18n;

public class PerformanceOptionPanel
extends OptionPanel {
    private final NetworkManager networkManager;
    private final GnutellaConnectionManager connectionManager;
    private final String firstMultiLineLabel = I18n.tr("If your computer has a fast internet connection, LimeWire may act as an \"Ultrapeer\" or connect to the Mojito DHT. You may disable these if you notice performance issues.");
    private final String secondMultiLineLabel = I18n.tr("LimeWire uses a secure communications mode called TLS, which may use more CPU resources.");
    private final String thirdMultiLineLabel = I18n.tr("Out-of-band Searching helps deliver faster search results to you, but some internet connections may not work well with this feature.");
    private JCheckBox disableUltraPeerCheckBox;
    private JCheckBox disableMojitoCheckBox;
    private JCheckBox disableTLS;
    private JCheckBox disableOutOfBandSearchCheckBox;

    @Inject
    public PerformanceOptionPanel(NetworkManager networkManager, GnutellaConnectionManager connectionManager) {
        this.networkManager = networkManager;
        this.connectionManager = connectionManager;
        this.setLayout(new MigLayout("insets 15 15 15 15, fillx, wrap", "", ""));
        this.setOpaque(false);
        this.add((Component)this.getPerformancePanel(), "pushx, growx");
    }

    private JPanel getPerformancePanel() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder(""));
        p.setLayout(new MigLayout("fillx"));
        p.setOpaque(false);
        this.disableUltraPeerCheckBox = new JCheckBox(I18n.tr("Disable Ultrapeer capabilities"));
        this.disableMojitoCheckBox = new JCheckBox(I18n.tr("Disable connecting to the Mojito DHT"));
        this.disableTLS = new JCheckBox(I18n.tr("Disable TLS capabilities"));
        this.disableOutOfBandSearchCheckBox = new JCheckBox(I18n.tr("Disable Out-of-band searching"));
        this.disableUltraPeerCheckBox.setOpaque(false);
        this.disableMojitoCheckBox.setOpaque(false);
        this.disableTLS.setOpaque(false);
        this.disableOutOfBandSearchCheckBox.setOpaque(false);
        p.add((Component)new MultiLineLabel(this.firstMultiLineLabel, 440), "span, growx, wrap");
        p.add((Component)this.disableUltraPeerCheckBox, "gapleft 25, split, wrap");
        p.add((Component)this.disableMojitoCheckBox, "gapleft 25, split, wrap");
        p.add((Component)new MultiLineLabel(this.secondMultiLineLabel, 440), "span, growx, gaptop 18, wrap");
        p.add((Component)this.disableTLS, "gapleft 25, split, wrap");
        p.add((Component)new MultiLineLabel(this.thirdMultiLineLabel, 440), "span, growx, gaptop 18, wrap");
        p.add((Component)this.disableOutOfBandSearchCheckBox, "gapleft 25, split, wrap");
        return p;
    }

    @Override
    boolean applyOptions() {
        boolean upChanged = UltrapeerSettings.DISABLE_ULTRAPEER_MODE.getValue() != this.disableUltraPeerCheckBox.isSelected();
        boolean tlsServerChanged = this.disableTLS.isSelected() != !this.networkManager.isIncomingTLSEnabled();
        boolean isSupernode = this.connectionManager.isUltrapeer();
        UltrapeerSettings.DISABLE_ULTRAPEER_MODE.setValue(this.disableUltraPeerCheckBox.isSelected());
        DHTSettings.DISABLE_DHT_USER.setValue(this.disableMojitoCheckBox.isSelected());
        this.networkManager.setIncomingTLSEnabled(!this.disableTLS.isSelected());
        this.networkManager.setOutgoingTLSEnabled(!this.disableTLS.isSelected());
        SearchSettings.OOB_ENABLED.setValue(!this.disableOutOfBandSearchCheckBox.isSelected());
        if ((tlsServerChanged || upChanged && this.disableUltraPeerCheckBox.isSelected() && isSupernode) && tlsServerChanged && !this.disableTLS.isSelected()) {
            BackgroundExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    PerformanceOptionPanel.this.networkManager.validateTLS();
                    PerformanceOptionPanel.this.connectionManager.restart();
                }
            });
        }
        return false;
    }

    @Override
    boolean hasChanged() {
        return UltrapeerSettings.DISABLE_ULTRAPEER_MODE.getValue() != this.disableUltraPeerCheckBox.isSelected() || DHTSettings.DISABLE_DHT_USER.getValue() != this.disableMojitoCheckBox.isSelected() || (!this.networkManager.isIncomingTLSEnabled() && !this.networkManager.isOutgoingTLSEnabled()) != this.disableTLS.isSelected() || SearchSettings.OOB_ENABLED.getValue() == this.disableOutOfBandSearchCheckBox.isSelected();
    }

    @Override
    public void initOptions() {
        this.disableUltraPeerCheckBox.setSelected(UltrapeerSettings.DISABLE_ULTRAPEER_MODE.getValue());
        this.disableMojitoCheckBox.setSelected(DHTSettings.DISABLE_DHT_USER.getValue());
        this.disableTLS.setSelected(!this.networkManager.isIncomingTLSEnabled() || !this.networkManager.isOutgoingTLSEnabled());
        this.disableOutOfBandSearchCheckBox.setSelected(!SearchSettings.OOB_ENABLED.getValue());
    }
}

