/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.player;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.util.Locale;
import org.limewire.core.api.Category;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.ui.swing.player.Audio;
import org.limewire.ui.swing.player.PlayerMediator;
import org.limewire.ui.swing.player.Video;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.NativeLaunchUtils;
import org.limewire.util.OSUtils;

public class PlayerUtils {
    @Inject
    @Audio
    private static Provider<PlayerMediator> audioPlayerProvider;
    @Inject
    @Video
    private static Provider<PlayerMediator> videoPlayerProvider;

    private static void playAudio(File mediaFile) {
        audioPlayerProvider.get().play(mediaFile);
    }

    private static void playVideo(File mediaFile) {
        videoPlayerProvider.get().play(mediaFile);
    }

    public static boolean isPlaying(File mediaFile) {
        return audioPlayerProvider.get().isPlaying(mediaFile) || videoPlayerProvider.get().isPlaying(mediaFile);
    }

    public static boolean isPlayableVideoFile(File file, CategoryManager categoryManager) {
        return (OSUtils.isWindows() || OSUtils.isMacOSX()) && categoryManager.getCategoryForFile(file) == Category.VIDEO;
    }

    public static boolean isFileAllowedInPlaylist(File file) {
        return PlayerUtils.isPlayableAudioFile(file);
    }

    public static boolean isPlayableAudioFile(File file) {
        String name = file.getName().toLowerCase(Locale.US);
        return name.endsWith(".mp3") || name.endsWith(".ogg") || name.endsWith(".wav");
    }

    public static void pause() {
        audioPlayerProvider.get().pause();
        videoPlayerProvider.get().pause();
    }

    public static void stop() {
        audioPlayerProvider.get().stop();
        videoPlayerProvider.get().stop();
    }

    public static boolean playOrLaunch(File file, CategoryManager categoryManager) {
        if (SwingUiSettings.PLAYER_ENABLED.getValue() && PlayerUtils.isPlayableAudioFile(file)) {
            PlayerUtils.playAudio(file);
            return true;
        }
        if (SwingUiSettings.PLAYER_ENABLED.getValue() && PlayerUtils.isPlayableVideoFile(file, categoryManager)) {
            PlayerUtils.playVideo(file);
            return true;
        }
        NativeLaunchUtils.safeLaunchFile(file, categoryManager);
        return false;
    }

    public static File getCurrentSongFile() {
        return audioPlayerProvider.get().getCurrentMediaFile();
    }
}

