/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.properties;

import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.bittorrent.Torrent;
import org.limewire.bittorrent.TorrentFileEntry;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.ui.swing.properties.FileInfoPanel;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

class FileInfoBittorrentOverviewPanel
implements FileInfoPanel {
    @Resource
    private Font smallFont;
    @Resource
    private Font smallBoldFont;
    @Resource
    private Font headerFont;
    private final JPanel component;
    private final Torrent torrent;

    public FileInfoBittorrentOverviewPanel(Torrent torrent) {
        this.torrent = torrent;
        GuiUtils.assignResources(this);
        this.component = new JPanel(new MigLayout("fillx, insets 10 3 10 10"));
        this.init();
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public void updatePropertiableFile(PropertiableFile file) {
    }

    @Override
    public void save() {
    }

    @Override
    public void dispose() {
    }

    private void init() {
        this.component.setOpaque(false);
        JTextField field = this.createLabelField(this.torrent.getName());
        field.setFont(this.headerFont);
        this.component.add((Component)field, "growx, span, wrap");
        long totalSize = 0L;
        for (TorrentFileEntry entry : this.torrent.getTorrentFileEntries()) {
            totalSize += entry.getSize();
        }
        this.component.add((Component)this.createLabel(I18n.tr("Size:")), "split 2");
        this.component.add((Component)this.createLabelField(GuiUtils.formatUnitFromBytes(totalSize) + "  (" + GuiUtils.formatBytes(totalSize) + ")"), "growx, wrap");
        this.component.add((Component)this.createLabel(I18n.tr("# files:")), "split 2");
        this.component.add((Component)this.createLabelField(Integer.toString(this.torrent.getTorrentFileEntries().size())), "growx, wrap");
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(this.smallBoldFont);
        return label;
    }

    private JTextField createLabelField(String text) {
        JTextField field = new JTextField(text);
        field.setCaretPosition(0);
        field.setEditable(false);
        field.setOpaque(false);
        field.setFont(this.smallFont);
        field.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        return field;
    }
}

