/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.bittorrent.Torrent;
import org.limewire.core.settings.BittorrentSettings;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.properties.FileInfoBittorrentPanel;
import org.limewire.ui.swing.properties.FileInfoPanelFactory;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class TorrentSelectorPanel
implements PropertyChangeListener {
    @Resource
    private Color foreground;
    @Resource
    private Color backgroundColor;
    @Resource
    private Font headerFont;
    private final JPanel component;
    private FileInfoBittorrentPanel bittorrentPanel;
    private JButton okButton;
    private JCheckBox checkBox;
    private int closeValue = 2;

    public TorrentSelectorPanel(Torrent torrent, FileInfoPanelFactory factory) {
        GuiUtils.assignResources(this);
        this.component = new JPanel(new MigLayout("fill, gap 0, insets 0", "[grow]", "[][][grow][]"));
        this.component.setPreferredSize(new Dimension(440, 500));
        this.component.setBackground(this.backgroundColor);
        this.bittorrentPanel = factory.createBittorentPanel(torrent);
        this.bittorrentPanel.addPropertyChangeListener(this);
        this.component.add((Component)factory.createOverviewPanel(torrent).getComponent(), "growx, wrap, gapleft 5, gapright 5");
        this.component.add((Component)this.createHeaderLabel(I18n.tr("Choose files to download")), "gapleft 5, wrap");
        this.component.add((Component)this.bittorrentPanel.getComponent(), "grow");
        this.createFooter();
        this.component.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                TorrentSelectorPanel.this.okButton.requestFocusInWindow();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
    }

    public int getCloseValue() {
        return this.closeValue;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    private void close() {
        this.bittorrentPanel.dispose();
        Window window = SwingUtilities.getWindowAncestor(this.component);
        window.setVisible(false);
    }

    private void createFooter() {
        this.okButton = new JButton(new OKAction());
        this.checkBox = new JCheckBox(I18n.tr("Always ask before starting torrent"));
        this.checkBox.setOpaque(false);
        this.checkBox.setSelected(BittorrentSettings.TORRENT_SHOW_POPUP_BEFORE_DOWNLOADING.getValue());
        JPanel footerPanel = new JPanel(new MigLayout("fill, insets 0 10 10 15"));
        footerPanel.add((Component)this.checkBox, "span, wrap");
        footerPanel.add((Component)this.okButton, "alignx right, aligny bottom, split, tag ok");
        footerPanel.add((Component)new JButton(new CancelAction()), "aligny bottom, tag cancel");
        footerPanel.setOpaque(false);
        this.component.add((Component)footerPanel, "grow, south");
    }

    private JLabel createHeaderLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(this.headerFont);
        label.setForeground(this.foreground);
        return label;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("torrentFileEntrySelected")) {
            this.okButton.setEnabled((Boolean)evt.getNewValue());
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(I18n.tr("Cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TorrentSelectorPanel.this.closeValue = 2;
            TorrentSelectorPanel.this.close();
        }
    }

    private class OKAction
    extends AbstractAction {
        public OKAction() {
            super(I18n.tr("OK"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TorrentSelectorPanel.this.closeValue = 0;
            TorrentSelectorPanel.this.bittorrentPanel.save();
            BittorrentSettings.TORRENT_SHOW_POPUP_BEFORE_DOWNLOADING.setValue(TorrentSelectorPanel.this.checkBox.isSelected());
            TorrentSelectorPanel.this.close();
        }
    }
}

