/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.core.api.library.RemoteLibraryManager;
import org.limewire.core.api.search.browse.BrowseSearch;
import org.limewire.core.api.search.browse.BrowseStatus;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.listener.EventBean;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.components.HTMLLabel;
import org.limewire.ui.swing.components.HeaderBar;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.MessageComponent;
import org.limewire.ui.swing.components.decorators.HeaderBarDecorator;
import org.limewire.ui.swing.components.decorators.MessageDecorator;
import org.limewire.ui.swing.friends.chat.ChatMediator;
import org.limewire.ui.swing.search.DefaultSearchRepeater;
import org.limewire.ui.swing.search.model.SearchResultsModel;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class BrowseFailedMessagePanel
extends JPanel
implements Disposable {
    @Resource
    private Font chatFont;
    @Resource
    private Color chatForeground;
    private final SearchResultsModel searchResultsModel;
    private final Provider<ChatMediator> chatMediator;
    private final EventBean<FriendConnectionEvent> connectionEventBean;
    private EventListener<FriendConnectionEvent> connectionListener;
    private ListenerSupport<FriendConnectionEvent> connectionSupport;
    private final RemoteLibraryManager remoteLibraryManager;
    private final Provider<MessageDecorator> messageDecoratorProvider;
    private final HeaderBarDecorator headerBarDecorator;
    private BrowseSearch browseSearch;
    private boolean isInitialized = false;
    private BrowseStatus.BrowseState state;
    private List<Friend> friends;

    @Inject
    public BrowseFailedMessagePanel(EventBean<FriendConnectionEvent> connectionEventBean, Provider<ChatMediator> chatMediator, RemoteLibraryManager remoteLibraryManager, Provider<MessageDecorator> messageDecoratorProvider, HeaderBarDecorator headerBarDecorator, @Assisted SearchResultsModel searchResultsModel) {
        GuiUtils.assignResources(this);
        this.connectionEventBean = connectionEventBean;
        this.chatMediator = chatMediator;
        this.searchResultsModel = searchResultsModel;
        this.remoteLibraryManager = remoteLibraryManager;
        this.messageDecoratorProvider = messageDecoratorProvider;
        this.headerBarDecorator = headerBarDecorator;
    }

    public void update(BrowseStatus.BrowseState state, BrowseSearch browseSearch, List<Friend> friends) {
        this.state = state;
        this.browseSearch = browseSearch;
        this.friends = friends;
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.initialize();
        }
        this.updateLabel();
    }

    @Inject
    void registerListener(ListenerSupport<FriendConnectionEvent> connectionSupport) {
        this.connectionSupport = connectionSupport;
        this.connectionListener = new EventListener<FriendConnectionEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(FriendConnectionEvent event) {
                if (BrowseFailedMessagePanel.this.isInitialized) {
                    BrowseFailedMessagePanel.this.updateLabel();
                    BrowseFailedMessagePanel.this.repaint();
                }
            }
        };
        connectionSupport.addListener(this.connectionListener);
    }

    private void initialize() {
        this.setLayout(new MigLayout("insets 0, gap 0, fill", "[]", "[][grow][grow]"));
    }

    private void updateLabel() {
        this.removeAll();
        this.add((Component)this.createMessageComponent(this.getLabelText()), "pos 0.50al 0.4al");
        this.add((Component)this.createBottomComponent(), "pos 1al 1al");
    }

    private JComponent createMessageComponent(String text) {
        HeaderBar header = new HeaderBar(new JLabel(""));
        header.setLayout(new MigLayout("insets 0, gap 0!, novisualpadding, alignx 100%, aligny 100%"));
        header.setAlignmentX(0.5f);
        this.headerBarDecorator.decorateBasic(header);
        this.add((Component)header, "growx, growy, wrap");
        MessageComponent messageComponent = new MessageComponent();
        this.messageDecoratorProvider.get().decorateGrayMessage(messageComponent);
        JLabel message = new JLabel(text);
        messageComponent.decorateHeaderLabel(message);
        messageComponent.addComponent(message, this.hasRefresh() ? "" : "wrap");
        if (this.hasRefresh()) {
            HyperlinkButton refresh = new HyperlinkButton(I18n.tr("Retry"));
            refresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BrowseFailedMessagePanel.this.setVisible(false);
                    new DefaultSearchRepeater(BrowseFailedMessagePanel.this.browseSearch, BrowseFailedMessagePanel.this.searchResultsModel).refresh();
                }
            });
            messageComponent.decorateHeaderLink(refresh);
            messageComponent.addComponent(refresh, "gapleft 5, wrap");
        }
        if (this.state == BrowseStatus.BrowseState.NO_FRIENDS_SHARING || this.state == BrowseStatus.BrowseState.OFFLINE) {
            String subText = null;
            subText = this.isUserOffline() ? (this.state == BrowseStatus.BrowseState.NO_FRIENDS_SHARING ? I18n.tr("When you sign on to LimeWire, your friends' files will appear here.") : I18n.tr("When you sign on to LimeWire, your friend's files will appear here.")) : I18n.tr("When they sign on to LimeWire and share with you, their files will appear here.");
            JLabel subMessage = new JLabel(subText);
            messageComponent.decorateSubLabel(subMessage);
            messageComponent.addComponent(subMessage, "");
        }
        return messageComponent;
    }

    private boolean hasRefresh() {
        return this.state != BrowseStatus.BrowseState.OFFLINE && this.state != BrowseStatus.BrowseState.NO_FRIENDS_SHARING;
    }

    private JComponent createBottomComponent() {
        if (this.state == BrowseStatus.BrowseState.NO_FRIENDS_SHARING && !this.isUserOffline()) {
            String text = this.areFriendsSignedOnToLimeWire() ? I18n.tr("<HTML><A href=\"\">Chat</A> and tell them to share.</HTML>") : I18n.tr("<HTML><A href=\"\">Chat</A> and tell them to sign on.</HTML>");
            HTMLLabel message = new HTMLLabel(text);
            message.setHtmlFont(this.chatFont);
            message.setHtmlForeground(this.chatForeground);
            message.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        ((ChatMediator)BrowseFailedMessagePanel.this.chatMediator.get()).setVisible(true);
                    }
                }
            });
            JPanel panel = new JPanel(new MigLayout("insets 0, gap 0, novisualpadding"));
            panel.add((Component)message, "gapright 5");
            return panel;
        }
        return new JLabel();
    }

    private String getLabelText() {
        if (this.isUserOffline() && (this.state == BrowseStatus.BrowseState.NO_FRIENDS_SHARING || this.state == BrowseStatus.BrowseState.OFFLINE)) {
            return this.getUserOfflineText();
        }
        if (this.state == BrowseStatus.BrowseState.NO_FRIENDS_SHARING) {
            if (this.areFriendsSignedOnToLimeWire()) {
                return I18n.tr("No friends are sharing with you");
            }
            return I18n.tr("No friends are on LimeWire");
        }
        if (this.state == BrowseStatus.BrowseState.OFFLINE) {
            if (this.isSingleBrowse()) {
                return I18n.tr("{0} is not signed on to LimeWire.", this.getSingleFriendName());
            }
            return I18n.tr("These people are not signed on to LimeWire.");
        }
        if (this.isSingleBrowse()) {
            return I18n.tr("There was a problem browsing {0}.", this.getSingleFriendName());
        }
        return I18n.tr("There was a problem viewing these people.");
    }

    private boolean isUserOffline() {
        return this.connectionEventBean.getLastEvent() == null || this.connectionEventBean.getLastEvent().getType() != FriendConnectionEvent.Type.CONNECTED;
    }

    private boolean isSingleBrowse() {
        return this.friends.size() == 1;
    }

    public boolean areFriendsSignedOnToLimeWire() {
        return this.remoteLibraryManager.getFriendLibraryList().size() != 0;
    }

    private String getSingleFriendName() {
        return this.friends.get(0).getRenderName();
    }

    private String getUserOfflineText() {
        return I18n.tr("You are offline.");
    }

    @Override
    public void dispose() {
        if (this.connectionSupport != null) {
            this.connectionSupport.removeListener(this.connectionListener);
        }
    }
}

