/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.model;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransactionList;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.util.concurrent.Lock;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import com.google.inject.Provider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.URN;
import org.limewire.core.api.download.DownloadAction;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadListManager;
import org.limewire.core.api.search.Search;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.core.api.search.SearchDetails;
import org.limewire.core.api.search.SearchListener;
import org.limewire.core.api.search.SearchResult;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.ui.swing.components.DisposalListener;
import org.limewire.ui.swing.filter.FilterDebugger;
import org.limewire.ui.swing.search.SearchInfo;
import org.limewire.ui.swing.search.model.BasicDownloadState;
import org.limewire.ui.swing.search.model.DownloadItemPropertyListener;
import org.limewire.ui.swing.search.model.SearchResultAdapter;
import org.limewire.ui.swing.search.model.SearchResultsModel;
import org.limewire.ui.swing.search.model.SortFactory;
import org.limewire.ui.swing.search.model.SortOption;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.model.VisualSearchResultStatusListener;
import org.limewire.ui.swing.util.DownloadExceptionHandler;
import org.limewire.ui.swing.util.PropertiableHeadings;

class BasicSearchResultsModel
implements SearchResultsModel,
VisualSearchResultStatusListener {
    private static final Log LOG = LogFactory.getLog(BasicSearchResultsModel.class);
    private final FilterDebugger<VisualSearchResult> filterDebugger;
    private final SearchInfo searchInfo;
    private final Search search;
    private final DownloadListManager downloadListManager;
    private final Provider<DownloadExceptionHandler> downloadExceptionHandler;
    private int resultCount;
    private final EventList<VisualSearchResult> groupedUrnResults;
    private final TransactionList<VisualSearchResult> transactionList;
    private final FilterList<VisualSearchResult> filteredResultList;
    private SearchListener searchListener;
    private SortedList<VisualSearchResult> sortedResultList;
    private FilterList<VisualSearchResult> visibleResultList;
    private SearchCategory selectedCategory;
    private SortOption sortOption;
    private MatcherEditor<VisualSearchResult> filterEditor;
    private MatcherEditor.Listener<VisualSearchResult> filterEditorListener;
    private final VisibleMatcherEditor visibleEditor = new VisibleMatcherEditor();
    private List<DisposalListener> disposalListeners = new ArrayList<DisposalListener>();
    private final Provider<PropertiableHeadings> propertiableHeadings;
    private final List<VisualSearchResultStatusListener> changeListeners;
    private final ListQueuer listQueuer = new ListQueuer();
    private final UrnResultFinder resultFinder = new UrnResultFinder();
    private boolean cleared = false;

    public BasicSearchResultsModel(SearchInfo searchInfo, Search search, Provider<PropertiableHeadings> propertiableHeadings, DownloadListManager downloadListManager, Provider<DownloadExceptionHandler> downloadExceptionHandler) {
        this.searchInfo = searchInfo;
        this.search = search;
        this.downloadListManager = downloadListManager;
        this.downloadExceptionHandler = downloadExceptionHandler;
        this.propertiableHeadings = propertiableHeadings;
        this.changeListeners = new ArrayList<VisualSearchResultStatusListener>(3);
        this.filterDebugger = new FilterDebugger();
        this.groupedUrnResults = new BasicEventList<VisualSearchResult>(new ReadWriteLock(){
            private Lock noopLock = new Lock(){

                @Override
                public void lock() {
                }

                @Override
                public boolean tryLock() {
                    return true;
                }

                @Override
                public void unlock() {
                }
            };

            @Override
            public Lock readLock() {
                return this.noopLock;
            }

            @Override
            public Lock writeLock() {
                return this.noopLock;
            }
        });
        this.transactionList = GlazedListsFactory.transactionList(this.groupedUrnResults);
        this.filteredResultList = GlazedListsFactory.filterList(this.transactionList);
        this.setSelectedCategory(searchInfo.getSearchCategory());
    }

    @Override
    public void start(SearchListener searchListener) {
        if (searchListener == null) {
            throw new IllegalArgumentException("Search listener cannot be null");
        }
        this.searchListener = searchListener;
        this.search.addSearchListener(searchListener);
        this.search.start();
    }

    @Override
    public void dispose() {
        this.search.stop();
        if (this.searchListener != null) {
            this.search.removeSearchListener(this.searchListener);
            this.searchListener = null;
        }
        this.groupedUrnResults.dispose();
        this.notifyDisposalListeners();
    }

    @Override
    public SearchCategory getFilterCategory() {
        return this.searchInfo.getSearchCategory();
    }

    @Override
    public FilterDebugger<VisualSearchResult> getFilterDebugger() {
        return this.filterDebugger;
    }

    @Override
    public EventList<VisualSearchResult> getUnfilteredList() {
        return this.transactionList;
    }

    @Override
    public EventList<VisualSearchResult> getFilteredList() {
        return this.filteredResultList;
    }

    @Override
    public SearchCategory getSearchCategory() {
        return this.searchInfo.getSearchCategory();
    }

    @Override
    public String getSearchQuery() {
        return this.searchInfo.getSearchQuery();
    }

    @Override
    public String getSearchTitle() {
        return this.searchInfo.getTitle();
    }

    @Override
    public int getResultCount() {
        return this.resultCount;
    }

    @Override
    public SearchDetails.SearchType getSearchType() {
        return this.searchInfo.getSearchType();
    }

    @Override
    public EventList<VisualSearchResult> getFilteredSearchResults() {
        return this.filteredResultList;
    }

    @Override
    public EventList<VisualSearchResult> getSortedSearchResults() {
        return this.visibleResultList;
    }

    @Override
    public SearchCategory getSelectedCategory() {
        return this.selectedCategory;
    }

    @Override
    public void setSelectedCategory(SearchCategory selectedCategory) {
        if (this.selectedCategory != selectedCategory) {
            this.selectedCategory = selectedCategory;
            this.updateSortedList();
        }
    }

    private void updateSortedList() {
        if (this.visibleResultList == null) {
            this.sortedResultList = GlazedListsFactory.sortedList(this.filteredResultList, this.sortOption != null ? SortFactory.getSortComparator(this.sortOption) : null);
            this.visibleResultList = GlazedListsFactory.filterList(this.sortedResultList, this.visibleEditor);
        }
    }

    @Override
    public void setSortOption(SortOption sortOption) {
        this.sortOption = sortOption;
        this.sortedResultList.setComparator(sortOption != null ? SortFactory.getSortComparator(sortOption) : null);
    }

    @Override
    public void setFilterEditor(MatcherEditor<VisualSearchResult> editor) {
        if (this.filterEditor != null && this.filterEditorListener != null) {
            this.filterEditor.removeMatcherEditorListener(this.filterEditorListener);
        }
        if (this.filterEditorListener == null) {
            this.filterEditorListener = new MatcherEditor.Listener<VisualSearchResult>(){

                @Override
                public void changedMatcher(MatcherEditor.Event<VisualSearchResult> matcherEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BasicSearchResultsModel.this.visibleEditor.update();
                        }
                    });
                }
            };
        }
        this.filterEditor = editor;
        this.filterEditor.addMatcherEditorListener(this.filterEditorListener);
        this.filteredResultList.setMatcherEditor(this.filterEditor);
    }

    public void addResultListener(VisualSearchResultStatusListener vsrChangeListener) {
        this.changeListeners.add(vsrChangeListener);
    }

    @Override
    public void resultCreated(VisualSearchResult vsr) {
    }

    @Override
    public void resultsCleared() {
    }

    @Override
    public void resultChanged(VisualSearchResult vsr, String propertyName, Object oldValue, Object newValue) {
        URN urn = vsr.getUrn();
        int idx = Collections.binarySearch(this.groupedUrnResults, urn, this.resultFinder);
        assert (this.cleared || idx >= 0);
        if (idx >= 0) {
            VisualSearchResult existing = (VisualSearchResult)this.groupedUrnResults.get(idx);
            VisualSearchResult replaced = this.groupedUrnResults.set(idx, existing);
            assert (this.cleared || replaced == vsr);
            if (replaced == vsr) {
                for (VisualSearchResultStatusListener listener : this.changeListeners) {
                    listener.resultChanged(vsr, propertyName, oldValue, newValue);
                }
            }
        }
    }

    @Override
    public void addSearchResult(SearchResult result) {
        if (result.getUrn() == null) {
            return;
        }
        try {
            this.listQueuer.add(result);
        }
        catch (Throwable th) {
            throw new RuntimeException(this.createMessageDetail("Problem adding result", result), th);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addSearchResults(Collection<? extends SearchResult> results) {
        boolean ok = true;
        for (SearchResult searchResult : results) {
            if (searchResult.getUrn() != null) continue;
            ok = false;
            break;
        }
        if (!ok) {
            void var4_6;
            ArrayList<? extends SearchResult> cleanup = new ArrayList<SearchResult>(results);
            int n = cleanup.size() - 1;
            while (var4_6 >= 0) {
                if (cleanup.get((int)var4_6).getUrn() == null) {
                    cleanup.remove((int)var4_6);
                }
                --var4_6;
            }
            results = cleanup;
        }
        this.listQueuer.addAll(results);
    }

    @Override
    public void clear() {
        this.listQueuer.clear();
    }

    @Override
    public void download(VisualSearchResult vsr) {
        this.download(vsr, null);
    }

    @Override
    public void download(final VisualSearchResult vsr, File saveFile) {
        try {
            DownloadItem di = saveFile == null ? this.downloadListManager.addDownload(this.search, vsr.getCoreSearchResults()) : this.downloadListManager.addDownload(this.search, vsr.getCoreSearchResults(), saveFile, true);
            di.addPropertyChangeListener(new DownloadItemPropertyListener(vsr));
            BasicDownloadState state = BasicDownloadState.fromState(di.getState());
            if (state != null) {
                vsr.setDownloadState(state);
            }
        }
        catch (DownloadException e) {
            if (e.getErrorCode() == DownloadException.ErrorCode.FILE_ALREADY_DOWNLOADING) {
                DownloadItem downloadItem = this.downloadListManager.getDownloadItem(vsr.getUrn());
                if (downloadItem != null) {
                    downloadItem.addPropertyChangeListener(new DownloadItemPropertyListener(vsr));
                    BasicDownloadState state = BasicDownloadState.fromState(downloadItem.getState());
                    if (state != null) {
                        vsr.setDownloadState(state);
                    }
                    if (saveFile != null) {
                        try {
                            downloadItem.setSaveFile(saveFile, true);
                        }
                        catch (DownloadException ex) {
                            LOG.infof(ex, "Unable to relocate downloading file {0}", ex.getMessage());
                        }
                    }
                }
            }
            this.downloadExceptionHandler.get().handleDownloadException(new DownloadAction(){

                @Override
                public void download(File saveFile, boolean overwrite) throws DownloadException {
                    DownloadItem di = BasicSearchResultsModel.this.downloadListManager.addDownload(BasicSearchResultsModel.this.search, vsr.getCoreSearchResults(), saveFile, overwrite);
                    di.addPropertyChangeListener(new DownloadItemPropertyListener(vsr));
                    BasicDownloadState state = BasicDownloadState.fromState(di.getState());
                    if (state != null) {
                        vsr.setDownloadState(state);
                    }
                }

                @Override
                public void downloadCanceled(DownloadException ignored) {
                }
            }, e, true);
        }
    }

    private String createMessageDetail(String prefix, SearchResult result) {
        StringBuilder buf = new StringBuilder(prefix);
        buf.append(", searchCategory=").append((Object)this.searchInfo.getSearchCategory());
        buf.append(", resultCategory=").append((Object)result.getCategory());
        buf.append(", spam=").append(result.isSpam());
        buf.append(", unfilteredSize=").append(this.getUnfilteredList().size());
        buf.append(", filteredSize=").append(this.getFilteredList().size());
        buf.append(", EDT=").append(SwingUtilities.isEventDispatchThread());
        buf.append(", filters=").append(this.filterDebugger.getFilterString());
        return buf.toString();
    }

    private boolean isFilterMatch(VisualSearchResult vsr) {
        if (this.filterEditor != null) {
            return this.filterEditor.getMatcher().matches(vsr);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResultsInternal(Collection<? extends SearchResult> results) {
        this.transactionList.beginEvent(true);
        try {
            for (SearchResult searchResult : results) {
                SearchResultAdapter vsr;
                URN urn = searchResult.getUrn();
                if (urn == null) continue;
                int idx = Collections.binarySearch(this.groupedUrnResults, urn, this.resultFinder);
                if (idx >= 0) {
                    vsr = (SearchResultAdapter)this.groupedUrnResults.get(idx);
                    vsr.addNewSource(searchResult, this.searchInfo.getSearchQuery());
                    this.groupedUrnResults.set(idx, vsr);
                    for (VisualSearchResultStatusListener listener : this.changeListeners) {
                        listener.resultChanged(vsr, "new-sources", null, null);
                    }
                } else {
                    idx = -(idx + 1);
                    vsr = new SearchResultAdapter(searchResult, this.propertiableHeadings, this, this.searchInfo.getSearchQuery());
                    this.groupedUrnResults.add(idx, vsr);
                    for (VisualSearchResultStatusListener listener : this.changeListeners) {
                        listener.resultCreated(vsr);
                    }
                }
                this.resultCount += searchResult.getSources().size();
            }
        }
        finally {
            this.transactionList.commitEvent();
        }
    }

    @Override
    public void addDisposalListener(DisposalListener listener) {
        this.disposalListeners.add(listener);
    }

    @Override
    public void removeDisposalListener(DisposalListener listener) {
        this.disposalListeners.remove(listener);
    }

    private void notifyDisposalListeners() {
        for (DisposalListener listener : this.disposalListeners) {
            listener.objectDisposed(this);
        }
    }

    private static class UrnResultFinder
    implements Comparator<Object> {
        private UrnResultFinder() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return ((VisualSearchResult)o1).getUrn().compareTo((URN)o2);
        }
    }

    private class ListQueuer
    implements Runnable {
        private final Object LOCK = new Object();
        private final List<SearchResult> queue = new ArrayList<SearchResult>();
        private final ArrayList<SearchResult> transferQ = new ArrayList();
        private boolean scheduled = false;

        private ListQueuer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(SearchResult result) {
            Object object = this.LOCK;
            synchronized (object) {
                this.queue.add(result);
                this.schedule();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addAll(Collection<? extends SearchResult> results) {
            Object object = this.LOCK;
            synchronized (object) {
                this.queue.addAll(results);
                this.schedule();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            Object object = this.LOCK;
            synchronized (object) {
                this.queue.clear();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BasicSearchResultsModel.this.cleared = true;
                        BasicSearchResultsModel.this.groupedUrnResults.clear();
                        for (VisualSearchResultStatusListener listener : BasicSearchResultsModel.this.changeListeners) {
                            listener.resultsCleared();
                        }
                    }
                });
            }
        }

        private void schedule() {
            if (!this.scheduled) {
                this.scheduled = true;
                SwingUtilities.invokeLater(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.transferQ.clear();
            Object object = this.LOCK;
            synchronized (object) {
                this.transferQ.addAll(this.queue);
                this.queue.clear();
            }
            BasicSearchResultsModel.this.addResultsInternal(this.transferQ);
            this.transferQ.clear();
            object = this.LOCK;
            synchronized (object) {
                this.scheduled = false;
                if (!this.queue.isEmpty()) {
                    this.schedule();
                }
            }
        }
    }

    private class VisibleMatcherEditor
    extends AbstractMatcherEditor<VisualSearchResult> {
        public VisibleMatcherEditor() {
            this.currentMatcher = new Matcher<VisualSearchResult>(){

                @Override
                public boolean matches(VisualSearchResult item) {
                    VisualSearchResult parent = item.getSimilarityParent();
                    boolean parentHidden = parent != null && !BasicSearchResultsModel.this.isFilterMatch(parent);
                    return item.isVisible() || parentHidden;
                }
            };
        }

        public void update() {
            this.fireChangedMatcher(new MatcherEditor.Event<VisualSearchResult>(this, 4, this.currentMatcher));
        }
    }
}

