/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.resultpanel;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;
import org.limewire.friend.api.Friend;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.settings.TablesHandler;
import org.limewire.ui.swing.table.AbstractColumnStateFormat;
import org.limewire.ui.swing.table.ColumnStateInfo;
import org.limewire.ui.swing.table.QualityComparator;
import org.limewire.ui.swing.util.EventListTableSortFormat;
import org.limewire.util.Objects;

public abstract class ResultsTableFormat<T>
extends AbstractColumnStateFormat<T>
implements EventListTableSortFormat {
    protected VisualSearchResult vsr;
    private final int nameColumn;
    private final int fromColumn;
    private final int spamColumn;
    private final String sortID;

    public ResultsTableFormat(ColumnStateInfo ... columnInfo) {
        this("", -1, -1, -1, columnInfo);
    }

    public ResultsTableFormat(String sortID, int nameColumn, int fromColumn, int spamColumn, ColumnStateInfo ... columnInfo) {
        super(columnInfo);
        this.sortID = sortID;
        this.nameColumn = nameColumn;
        this.fromColumn = fromColumn;
        this.spamColumn = spamColumn;
    }

    @Override
    public Class getColumnClass(int index) {
        return String.class;
    }

    @Override
    public VisualSearchResult setColumnValue(VisualSearchResult vsr, Object value, int index) {
        return vsr;
    }

    @Override
    public boolean isEditable(VisualSearchResult vsr, int column) {
        return column == this.fromColumn;
    }

    public int getNameColumn() {
        return this.nameColumn;
    }

    @Override
    public List<SortKey> getPreSortColumns() {
        return Arrays.asList(new SortKey(SortOrder.ASCENDING, this.spamColumn));
    }

    @Override
    public boolean getSortOrder() {
        return false;
    }

    @Override
    public String getSortOrderID() {
        return this.sortID;
    }

    @Override
    public int getSortedColumn() {
        return this.fromColumn;
    }

    @Override
    public List<SortKey> getDefaultSortKeys() {
        return Arrays.asList(new SortKey(TablesHandler.getSortedOrder(this.getSortOrderID(), this.getSortOrder()).getValue() ? SortOrder.ASCENDING : SortOrder.DESCENDING, TablesHandler.getSortedColumn(this.getSortOrderID(), this.getSortedColumn()).getValue()));
    }

    @Override
    public Comparator getColumnComparator(int index) {
        if (index == this.fromColumn) {
            return this.getFromComparator();
        }
        if (index == this.nameColumn) {
            return this.getNameComparator();
        }
        if (index == this.spamColumn) {
            return this.getSpamComparator();
        }
        return this.getLimeComparator();
    }

    public Comparator getFromComparator() {
        return new FromComparator();
    }

    public Comparator getNameComparator() {
        return new NameComparator(false);
    }

    public Comparator getQualityComparator() {
        return new QualityComparator();
    }

    public Comparator getSpamComparator() {
        return new IsSpamComparator();
    }

    public static class IsSpamComparator
    implements Comparator<VisualSearchResult> {
        @Override
        public int compare(VisualSearchResult o1, VisualSearchResult o2) {
            boolean spam1 = o1.isSpam();
            boolean spam2 = o2.isSpam();
            if (!spam1 && spam2) {
                return -1;
            }
            if (spam1 && !spam2) {
                return 1;
            }
            return 0;
        }
    }

    public static class NameComparator
    implements Comparator<VisualSearchResult> {
        private final boolean useAudioArtist;

        public NameComparator(boolean useAudioArtist) {
            this.useAudioArtist = useAudioArtist;
        }

        @Override
        public int compare(VisualSearchResult o1, VisualSearchResult o2) {
            String name1 = this.getName(o1);
            String name2 = this.getName(o2);
            return name1.compareToIgnoreCase(name2);
        }

        private String getName(VisualSearchResult result) {
            return result.getNameProperty(this.useAudioArtist);
        }
    }

    public static class FromComparator
    implements Comparator<VisualSearchResult> {
        @Override
        public int compare(VisualSearchResult o1, VisualSearchResult o2) {
            int size2;
            int size1 = o1.getSources().size();
            if (size1 == (size2 = o2.getSources().size())) {
                if (size1 == 1) {
                    Collection<Friend> friends1 = o1.getFriends();
                    String name1 = null;
                    if (friends1.size() == 1) {
                        name1 = friends1.iterator().next().getRenderName();
                    }
                    Collection<Friend> friends2 = o2.getFriends();
                    String name2 = null;
                    if (friends2.size() == 1) {
                        name2 = friends2.iterator().next().getRenderName();
                    }
                    return Objects.compareToNullIgnoreCase(name1, name2, false);
                }
                return 0;
            }
            if (size1 > size2) {
                return 1;
            }
            return -1;
        }
    }
}

