/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.shell;

import org.limewire.ui.swing.shell.ShellAssociation;
import org.limewire.ui.swing.util.MacOSXUtils;

class OSXURLSchemeAssociation
implements ShellAssociation {
    private final String urlScheme;

    protected OSXURLSchemeAssociation(String urlScheme) {
        this.urlScheme = urlScheme;
    }

    public static boolean isNativeLibraryLoadedCorrectly() {
        return MacOSXUtils.isNativeLibraryLoadedCorrectly();
    }

    @Override
    public boolean isAvailable() {
        return !MacOSXUtils.isURLSchemeHandled(this.urlScheme);
    }

    @Override
    public boolean isRegistered() {
        return MacOSXUtils.isLimewireDefaultURLSchemeHandler(this.urlScheme);
    }

    @Override
    public void register() {
        MacOSXUtils.setLimewireAsDefaultURLSchemeHandler(this.urlScheme);
    }

    @Override
    public boolean canUnregister() {
        return MacOSXUtils.canChangeDefaultURLSchemeHandler(this.urlScheme);
    }

    @Override
    public void unregister() {
        MacOSXUtils.tryChangingDefaultURLSchemeHandler(this.urlScheme);
    }
}

