/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.tray;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.EventObject;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.tray.BasicNotifier;
import org.limewire.ui.swing.tray.GrowlNotifier;
import org.limewire.ui.swing.tray.Notification;
import org.limewire.ui.swing.tray.SystemTrayNotifier;
import org.limewire.ui.swing.tray.TrayNotifier;
import org.limewire.util.OSUtils;

@Singleton
class TrayNotifierProxy
implements TrayNotifier {
    private TrayNotifier notifier;
    private boolean inTray;

    @Inject
    TrayNotifierProxy() {
        if (OSUtils.isMacOSX()) {
            this.notifier = new GrowlNotifier();
        } else {
            this.notifier = new SystemTrayNotifier();
            if (!this.showTrayIcon()) {
                this.notifier = new BasicNotifier();
            }
        }
    }

    @Override
    public boolean supportsSystemTray() {
        return this.notifier.supportsSystemTray();
    }

    @Override
    public boolean showTrayIcon() {
        boolean notify;
        if (this.inTray) {
            return true;
        }
        this.inTray = notify = this.notifier.showTrayIcon();
        return notify;
    }

    @Override
    public void hideTrayIcon() {
        if (!this.inTray) {
            return;
        }
        this.notifier.hideTrayIcon();
        this.inTray = false;
    }

    @Override
    public void hideMessage(Notification notification) {
        this.notifier.hideMessage(notification);
    }

    @Override
    public void showMessage(Notification notification) {
        if (!SwingUiSettings.SHOW_NOTIFICATIONS.getValue()) {
            return;
        }
        this.notifier.showMessage(notification);
    }

    @Override
    public boolean isExitEvent(EventObject event) {
        return this.notifier.isExitEvent(event);
    }
}

