/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.upload.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;
import org.limewire.core.api.upload.UploadItem;
import org.limewire.ui.swing.components.IconButton;
import org.limewire.ui.swing.table.TableRendererEditor;
import org.limewire.ui.swing.transfer.TransferRendererResources;
import org.limewire.ui.swing.upload.UploadMediator;
import org.limewire.ui.swing.upload.table.UploadActionHandler;
import org.limewire.ui.swing.util.I18n;

class UploadCancelRendererEditor
extends TableRendererEditor {
    private final UploadActionHandler actionHandler;
    private final JButton cancelButton;
    private final JButton removeButton;
    private UploadItem item;

    public UploadCancelRendererEditor(UploadActionHandler actionHandler) {
        this.actionHandler = actionHandler;
        this.setLayout(new MigLayout("insets 0, gap 0, nogrid, novisualpadding, alignx center, aligny center"));
        TransferRendererResources resources = new TransferRendererResources();
        this.cancelButton = new IconButton();
        resources.decorateCancelButton(this.cancelButton);
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.setToolTipText(I18n.tr("Cancel upload"));
        this.removeButton = new IconButton();
        resources.decorateCancelButton(this.removeButton);
        this.removeButton.setActionCommand("remove");
        this.removeButton.setToolTipText(I18n.tr("Remove upload"));
        if (actionHandler != null) {
            ButtonListener listener = new ButtonListener();
            this.cancelButton.addActionListener(listener);
            this.removeButton.addActionListener(listener);
        }
        this.add((Component)this.cancelButton, "hidemode 3");
        this.add((Component)this.removeButton, "hidemode 3");
    }

    @Override
    protected Component doTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof UploadItem) {
            this.item = (UploadItem)value;
            this.updateButtons(this.item);
            return this;
        }
        return this.emptyPanel;
    }

    @Override
    protected Component doTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof UploadItem) {
            this.updateButtons((UploadItem)value);
            return this;
        }
        return this.emptyPanel;
    }

    private void updateButtons(UploadItem item) {
        boolean removable = UploadMediator.isRemovable(item);
        this.cancelButton.setVisible(!removable);
        this.removeButton.setVisible(removable);
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof IconButton) {
                ((IconButton)e.getSource()).resetDefaultCursor();
            }
            UploadCancelRendererEditor.this.actionHandler.performAction(e.getActionCommand(), UploadCancelRendererEditor.this.item);
            UploadCancelRendererEditor.this.cancelCellEditing();
        }
    }
}

