/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.upload.table;

import java.awt.Component;
import java.awt.Point;
import java.util.List;
import javax.swing.JPopupMenu;
import org.limewire.core.api.upload.UploadItem;
import org.limewire.ui.swing.table.TablePopupHandler;
import org.limewire.ui.swing.upload.table.UploadPopupMenuFactory;
import org.limewire.ui.swing.upload.table.UploadTable;

public class UploadPopupHandler
implements TablePopupHandler {
    private final UploadTable table;
    private final UploadPopupMenuFactory popupMenuFactory;
    private JPopupMenu popupMenu;

    public UploadPopupHandler(UploadTable table, UploadPopupMenuFactory popupMenuFactory) {
        this.table = table;
        this.popupMenuFactory = popupMenuFactory;
    }

    @Override
    public boolean isPopupShowing(int row) {
        return this.popupMenu != null && this.popupMenu.isVisible();
    }

    @Override
    public void maybeShowPopup(Component component, int x, int y) {
        int popupRow = this.table.rowAtPoint(new Point(x, y));
        if (popupRow < 0) {
            return;
        }
        UploadItem item = this.table.getUploadItem(popupRow);
        List<UploadItem> uploadItems = this.table.getSelectedItems();
        if (uploadItems.size() == 0 || !uploadItems.contains(item)) {
            this.table.setRowSelectionInterval(popupRow, popupRow);
            uploadItems = this.table.getSelectedItems();
        }
        this.popupMenu = this.popupMenuFactory.create(this.table, uploadItems);
        this.popupMenu.show(component, x, y);
    }
}

