/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileLocker;
import org.limewire.util.OSUtils;
import org.limewire.util.ProcessUtils;
import org.limewire.util.SystemUtils;

public class FileUtils {
    private static final org.limewire.logging.Log LOG = LogFactory.getLog(FileUtils.class);
    private static final Map<File, Boolean> CAN_WRITE_CACHE = new ConcurrentHashMap<File, Boolean>();
    private static final CopyOnWriteArrayList<FileLocker> fileLockers = new CopyOnWriteArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeWithBackupFile(Object toWrite, File backupFile, File properFile, Log log) {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(backupFile)));
            out.writeObject(toWrite);
            out.flush();
            out.close();
            out = null;
            if (!properFile.equals(backupFile)) {
                properFile.delete();
                backupFile.renameTo(properFile);
            } else if (log != null) {
                log.warn("backup file is same as proper file! -- " + backupFile);
            }
            boolean bl = true;
            FileUtils.close(out);
            return bl;
        }
        catch (IOException iox) {
            if (log != null) {
                log.debug("IOX writing file to: " + properFile, iox);
            }
        }
        finally {
            FileUtils.close(out);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(File f, Object obj) throws IOException {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
            out.writeObject(obj);
            out.flush();
        }
        catch (Throwable throwable) {
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close(out);
    }

    public static Object readObject(String fileName) throws IOException, ClassNotFoundException {
        return FileUtils.readObject(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObject(File file) throws IOException, ClassNotFoundException {
        Object object;
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            object = in.readObject();
        }
        catch (Throwable throwable) {
            FileUtils.close(in);
            throw throwable;
        }
        FileUtils.close(in);
        return object;
    }

    public static String getCanonicalPath(File f) throws IOException {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            if (OSUtils.isWindows() && msg != null && msg.indexOf("There are no more files") != -1) {
                return f.getAbsolutePath();
            }
            throw ioe;
        }
    }

    public static File canonicalize(File f) {
        try {
            return FileUtils.getCanonicalFile(f);
        }
        catch (IOException iox) {
            return f;
        }
    }

    public static File getCanonicalFile(File f) throws IOException {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            if (OSUtils.isWindows() && msg != null && msg.indexOf("There are no more files") != -1) {
                return f.getAbsoluteFile();
            }
            throw ioe;
        }
    }

    public static boolean isAncestor(File ancestor, File child) {
        while (child != null) {
            if (child.equals(ancestor)) {
                return true;
            }
            child = child.getParentFile();
        }
        return false;
    }

    public static boolean isReallyParent(File testParent, File testChild) throws IOException {
        String testChildParentName;
        String testParentName = FileUtils.getCanonicalPath(testParent);
        return testParentName.equals(testChildParentName = FileUtils.getCanonicalPath(testChild.getAbsoluteFile().getParentFile()));
    }

    public static boolean isReallyInParentPath(File testParent, File testChild) throws IOException {
        String testParentName = FileUtils.getCanonicalPath(testParent);
        File testChildParentFile = testChild.getAbsoluteFile().getParentFile();
        if (testChildParentFile == null) {
            testChildParentFile = testChild.getAbsoluteFile();
        }
        String testChildParentName = FileUtils.getCanonicalPath(testChildParentFile);
        return testChildParentName.startsWith(testParentName);
    }

    public static String getFilenameNoExtension(String fullname) {
        int i = fullname.lastIndexOf(".");
        if (i < 0) {
            return fullname;
        }
        return fullname.substring(0, i);
    }

    public static String getFileExtension(File f) {
        String name = f.getName();
        return FileUtils.getFileExtension(name);
    }

    public static String getFileExtension(String name) {
        int index = name.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        if (index == 0) {
            return "";
        }
        if (index == name.length() - 1) {
            return "";
        }
        return name.substring(index + 1).intern();
    }

    public static boolean setWriteable(File f) {
        String fName;
        if (!f.exists()) {
            return true;
        }
        if (FileUtils.canWrite(f)) {
            if (OSUtils.isWindows()) {
                return true;
            }
            if (!f.isDirectory()) {
                return true;
            }
        }
        try {
            fName = f.getCanonicalPath();
        }
        catch (IOException ioe) {
            fName = f.getPath();
        }
        String[] cmds = null;
        if (OSUtils.isWindows() || OSUtils.isMacOSX()) {
            SystemUtils.setWriteable(fName);
            CAN_WRITE_CACHE.remove(f);
        } else if (!OSUtils.isOS2()) {
            cmds = f.isDirectory() ? new String[]{"chmod", "u+w+x", fName} : new String[]{"chmod", "u+w", fName};
        }
        if (cmds != null) {
            try {
                Process p = Runtime.getRuntime().exec(cmds);
                p.waitFor();
            }
            catch (SecurityException ignored) {
            }
            catch (IOException ignored) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return FileUtils.canWrite(f);
    }

    public static void touch(File f) throws IOException {
        if (f.exists()) {
            return;
        }
        File parent = f.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try {
            f.createNewFile();
        }
        catch (IOException failed) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
            }
            catch (IOException ioe) {
                try {
                    ioe.initCause(failed);
                    throw ioe;
                }
                catch (Throwable throwable) {
                    FileUtils.close(fos);
                    throw throwable;
                }
            }
            FileUtils.close(fos);
        }
    }

    public static void addFileLocker(FileLocker locker) {
        fileLockers.addIfAbsent(locker);
    }

    public static void removeFileLocker(FileLocker locker) {
        fileLockers.remove(locker);
    }

    public static boolean forceRename(File src, File dst) {
        boolean success = src.renameTo(dst);
        if (!success) {
            FileLocker locker;
            Iterator<FileLocker> i$ = fileLockers.iterator();
            while (!(!i$.hasNext() || (locker = i$.next()).releaseLock(src) && (success = src.renameTo(dst)))) {
            }
        }
        if (!success && (success = FileUtils.copy(src, dst))) {
            src.delete();
        }
        return success;
    }

    public static boolean forceDelete(File file) {
        boolean success = file.delete();
        if (!success) {
            FileLocker locker;
            Iterator<FileLocker> i$ = fileLockers.iterator();
            while (!(!i$.hasNext() || (locker = i$.next()).releaseLock(file) && (success = file.delete()))) {
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("success= {0}, file.exists()? {1}", (Object)success, (Object)file.exists());
        }
        return !file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verySafeSave(File dir, String name, byte[] data) {
        File tmp;
        try {
            tmp = FileUtils.createTempFile(name, "tmp", dir);
        }
        catch (IOException hrorible) {
            return false;
        }
        File out = new File(dir, name);
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(tmp));
            ((OutputStream)os).write(data);
            ((OutputStream)os).flush();
            FileUtils.close(os);
        }
        catch (IOException bad) {
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtils.close(os);
        }
        byte[] read = FileUtils.readFileFully(tmp);
        if (read == null || !Arrays.equals(read, data)) {
            return false;
        }
        return FileUtils.forceRename(tmp, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileFully(File source) {
        DataInputStream raf = null;
        int length = (int)source.length();
        if (length <= 0) {
            return null;
        }
        byte[] data = new byte[length];
        try {
            raf = new DataInputStream(new BufferedInputStream(new FileInputStream(source)));
            raf.readFully(data);
            FileUtils.close(raf);
        }
        catch (IOException ioe) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            FileUtils.close(raf);
        }
        return data;
    }

    public static File[] getFilesRecursive(File directory, String ... filter) {
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<File> retFileArray = new ArrayList<File>();
        File[] retArray = new File[]{};
        if (directory.exists() && directory.isDirectory()) {
            dirs.add(directory);
        }
        while (dirs.size() > 0) {
            File currDir = (File)dirs.remove(0);
            String[] listedFiles = currDir.list();
            for (int i = 0; listedFiles != null && i < listedFiles.length; ++i) {
                File currFile = new File(currDir, listedFiles[i]);
                if (currFile.isDirectory()) {
                    dirs.add(currFile);
                    continue;
                }
                if (!currFile.isFile()) continue;
                boolean shouldAdd = false;
                if (filter == null || filter.length == 0) {
                    shouldAdd = true;
                } else {
                    String ext = FileUtils.getFileExtension(currFile);
                    for (int j = 0; j < filter.length && !ext.isEmpty(); ++j) {
                        if (!ext.equalsIgnoreCase(filter[j])) continue;
                        shouldAdd = true;
                        break;
                    }
                }
                if (!shouldAdd) continue;
                retFileArray.add(currFile);
            }
        }
        if (!retFileArray.isEmpty()) {
            retArray = new File[retFileArray.size()];
            for (int i = 0; i < retArray.length; ++i) {
                retArray[i] = (File)retFileArray.get(i);
            }
        }
        return retArray;
    }

    public static boolean delete(File file, boolean moveToTrash) {
        if (!file.exists()) {
            return false;
        }
        if (moveToTrash) {
            if (OSUtils.isMacOSX()) {
                return FileUtils.moveToTrashOSX(file);
            }
            if (OSUtils.isWindows()) {
                return SystemUtils.recycle(file);
            }
            throw new IllegalArgumentException("OS does not support trash");
        }
        return FileUtils.deleteRecursive(file);
    }

    private static boolean moveToTrashOSX(File file) {
        try {
            String[] command = FileUtils.moveToTrashCommand(file);
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream();
            Process process = builder.start();
            ProcessUtils.consumeAllInput(process);
            process.waitFor();
        }
        catch (InterruptedException err) {
            LOG.error("InterruptedException", err);
        }
        catch (IOException err) {
            LOG.error("IOException", err);
        }
        return !file.exists();
    }

    private static String[] moveToTrashCommand(File file) {
        String path = null;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException err) {
            LOG.error("IOException", err);
            path = file.getAbsolutePath();
        }
        String fileOrFolder = file.isFile() ? "file" : "folder";
        String[] command = new String[]{"osascript", "-e", "set unixPath to \"" + path + "\"", "-e", "set hfsPath to POSIX file unixPath", "-e", "tell application \"Finder\"", "-e", "if " + fileOrFolder + " hfsPath exists then", "-e", "move " + fileOrFolder + " hfsPath to trash", "-e", "end if", "-e", "end tell"};
        return command;
    }

    public static boolean deleteRecursive(File directory) {
        String canonicalParent;
        try {
            canonicalParent = FileUtils.getCanonicalPath(directory);
        }
        catch (IOException ioe) {
            return false;
        }
        if (!directory.isDirectory()) {
            return directory.delete();
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                try {
                    if (!FileUtils.getCanonicalPath(file).startsWith(canonicalParent)) {
                        continue;
                    }
                }
                catch (IOException ioe) {
                    return false;
                }
                if (FileUtils.deleteRecursive(file)) continue;
                return false;
            }
        }
        return directory.delete();
    }

    public static boolean conflictsAny(File a, File b) {
        if (a.equals(b)) {
            return true;
        }
        HashSet<File> unique = new HashSet<File>();
        unique.add(a);
        unique.addAll(Arrays.asList(FileUtils.getFilesRecursive(a, new String[0])));
        if (unique.contains(b)) {
            return true;
        }
        for (File recursive : FileUtils.getFilesRecursive(b, new String[0])) {
            if (!unique.contains(recursive)) continue;
            return true;
        }
        return false;
    }

    public static long getLengthRecursive(File f) {
        if (!f.isDirectory()) {
            return f.length();
        }
        long ret = 0L;
        for (File file : FileUtils.getFilesRecursive(f, new String[0])) {
            ret += file.length();
        }
        return ret;
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void flush(Flushable flushable) {
        if (flushable != null) {
            try {
                flushable.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(File src, long amount, File dst) {
        long amountToRead;
        int BUFFER_SIZE = 1024;
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            int read;
            in = new BufferedInputStream(new FileInputStream(src));
            out = new BufferedOutputStream(new FileOutputStream(dst));
            byte[] buf = new byte[1024];
            for (amountToRead = amount; amountToRead > 0L && (read = ((InputStream)in).read(buf, 0, (int)Math.min(1024L, amountToRead))) != -1; amountToRead -= (long)read) {
                ((OutputStream)out).write(buf, 0, read);
            }
        }
        catch (IOException ignore) {
            try {
                LOG.error(ignore.getMessage(), ignore);
            }
            catch (Throwable throwable) {
                FileUtils.close(in);
                FileUtils.flush(out);
                FileUtils.close(out);
                throw throwable;
            }
            FileUtils.close(in);
            FileUtils.flush(out);
            FileUtils.close(out);
        }
        FileUtils.close(in);
        FileUtils.flush(out);
        FileUtils.close(out);
        return amount - amountToRead;
    }

    public static boolean copy(File src, File dst) {
        long length = src.length();
        return FileUtils.copy(src, (int)length, dst) == length;
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        IOException iox = null;
        for (int i = 0; i < 10; ++i) {
            try {
                return File.createTempFile(prefix, suffix, directory);
            }
            catch (IOException x) {
                iox = x;
                continue;
            }
        }
        throw iox;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        IOException iox = null;
        for (int i = 0; i < 10; ++i) {
            try {
                return File.createTempFile(prefix, suffix);
            }
            catch (IOException x) {
                iox = x;
                continue;
            }
        }
        throw iox;
    }

    public static File getJarFromClasspath(String markerFile) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            classLoader = FileUtils.class.getClassLoader();
        }
        if (classLoader == null) {
            return null;
        }
        return FileUtils.getJarFromClasspath(classLoader, markerFile);
    }

    public static File getJarFromClasspath(ClassLoader classLoader, String markerFile) {
        String url;
        if (classLoader == null) {
            throw new IllegalArgumentException();
        }
        URL messagesURL = classLoader.getResource(markerFile);
        if (messagesURL != null && (url = CommonUtils.decode(messagesURL.toExternalForm())) != null && url.startsWith("jar:file:")) {
            url = url.substring("jar:file:".length(), url.length());
            url = url.substring(0, url.length() - markerFile.length() - "!/".length());
            return new File(url);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(File path) throws IOException {
        BufferedInputStream stream = null;
        Properties properties = new Properties();
        try {
            stream = new BufferedInputStream(new FileInputStream(path));
            properties.load(stream);
        }
        catch (Throwable throwable) {
            FileUtils.close(stream);
            throw throwable;
        }
        FileUtils.close(stream);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProperties(File path, Properties properties) throws IOException {
        BufferedOutputStream stream = null;
        try {
            stream = new BufferedOutputStream(new FileOutputStream(path));
            properties.store(stream, "");
        }
        catch (Throwable throwable) {
            FileUtils.close(stream);
            throw throwable;
        }
        FileUtils.close(stream);
    }

    public static void makeFolder(File path) throws IOException {
        if (path.isDirectory()) {
            return;
        }
        if (!path.mkdirs()) {
            throw new IOException("error from File.mkdirs()");
        }
    }

    public static File resolveSpecialPath(String path) throws IOException {
        if (path == null) {
            throw new IOException("no path");
        }
        int i = path.indexOf(">");
        if (i != -1) {
            String tag = path.substring(0, i);
            SystemUtils.SpecialLocations location = SystemUtils.SpecialLocations.parse(tag);
            if (location == null) {
                throw new IOException("unknown tag");
            }
            String special = SystemUtils.getSpecialPath(location);
            if (special == null) {
                throw new IOException("unable to get path");
            }
            path = path.substring(i + 1);
            return new File(special, path).getAbsoluteFile();
        }
        return FileUtils.getCanonicalFile(new File(path));
    }

    public static void copyDirectory(File sourceDirectory, File destinationDirectory) throws IOException {
        String[] contents;
        if (!sourceDirectory.isDirectory()) {
            throw new IOException("source directory not found");
        }
        if (destinationDirectory.exists()) {
            throw new IOException("destination directory already exists");
        }
        FileUtils.makeFolder(destinationDirectory);
        for (String name : contents = sourceDirectory.list()) {
            File source = new File(sourceDirectory, name);
            File destination = new File(destinationDirectory, name);
            if (source.isDirectory()) {
                FileUtils.copyDirectory(source, destination);
                continue;
            }
            if (FileUtils.copy(source, destination)) continue;
            throw new IOException("unable to copy file");
        }
    }

    public static void write(InputStream inputStream, OutputStream outputStream) throws IOException {
        int numRead = 0;
        byte[] buffer = new byte[1024];
        while ((numRead = inputStream.read(buffer, 0, buffer.length)) != -1) {
            outputStream.write(buffer, 0, numRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest m = MessageDigest.getInstance("MD5");
        ByteBuffer byteBuffer = ByteBuffer.allocate(16384);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            while (fileChannel.read(byteBuffer) != -1) {
                byteBuffer.flip();
                m.update(byteBuffer);
                byteBuffer.clear();
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        byte[] digest = m.digest();
        String md5 = new BigInteger(1, digest).toString(16);
        return md5;
    }

    public static int createSymbolicLink(File source, File target) throws IOException, InterruptedException {
        if (!OSUtils.isLinux()) {
            throw new UnsupportedOperationException("Creating Symbolic links is only supported on linux.");
        }
        String[] command = new String[]{"ln", "-s", source.getAbsolutePath(), target.getAbsolutePath()};
        Process process = Runtime.getRuntime().exec(command);
        process.waitFor();
        return process.exitValue();
    }

    public static void unlockFile(File file) {
        for (FileLocker locker : fileLockers) {
            locker.releaseLock(file);
        }
    }

    public static boolean canWrite(File file) {
        if (!OSUtils.isWindows() || !file.isDirectory()) {
            return file.canWrite();
        }
        if (file.canWrite()) {
            return true;
        }
        Boolean cached = CAN_WRITE_CACHE.get(file);
        if (cached != null) {
            return cached;
        }
        try {
            File f = FileUtils.createTempFile("lw-", "can-write-test", file);
            f.delete();
            CAN_WRITE_CACHE.put(file, true);
            return true;
        }
        catch (IOException iox) {
            CAN_WRITE_CACHE.put(file, false);
            return false;
        }
    }

    public static boolean forceDeleteRecursive(File directory) {
        String canonicalParent;
        try {
            canonicalParent = FileUtils.getCanonicalPath(directory);
        }
        catch (IOException ioe) {
            return false;
        }
        if (!directory.isDirectory()) {
            return FileUtils.forceDelete(directory);
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                try {
                    if (!FileUtils.getCanonicalPath(file).startsWith(canonicalParent)) {
                        continue;
                    }
                }
                catch (IOException ioe) {
                    return false;
                }
                if (FileUtils.forceDeleteRecursive(file)) continue;
                return false;
            }
        }
        return FileUtils.forceDelete(directory);
    }

    public static boolean deleteEmptyDirectories(File directory) {
        if (directory.isDirectory()) {
            boolean empty = true;
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    empty &= file.isDirectory() && FileUtils.deleteEmptyDirectories(file);
                }
            }
            if (empty) {
                directory.delete();
            }
            return empty;
        }
        return false;
    }
}

