/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.impl.components;

import java.util.Vector;
import javax.swing.JLabel;

public class JMultiLineLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    private static int LINE_SEPARATOR_LEN = LINE_SEPARATOR.length();

    public void setText(String s) {
        if (s == null) {
            s = "";
        }
        String[] lines = JMultiLineLabel.breakupLines(s);
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                sb.append("<br>");
            }
            sb.append(lines[i]);
        }
        sb.append("</html>");
        super.setText(sb.toString());
    }

    public static String[] breakupLines(String text) {
        int len = text.length();
        if (len == 0) {
            return new String[]{""};
        }
        Vector<String> data = new Vector<String>(10);
        int start = 0;
        int i = 0;
        while (i < len) {
            if (text.startsWith(LINE_SEPARATOR, i)) {
                data.addElement(text.substring(start, i));
                i = start = i + LINE_SEPARATOR_LEN;
                continue;
            }
            if (text.charAt(i) == '\n') {
                data.addElement(text.substring(start, i));
                i = start = i + 1;
                continue;
            }
            ++i;
        }
        if (start != len) {
            data.addElement(text.substring(start));
        }
        int numlines = data.size();
        Object[] lines = new String[numlines];
        data.copyInto(lines);
        return lines;
    }
}

