/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom;

import java.util.concurrent.Callable;
import org.mozilla.dom.AttrImpl;
import org.mozilla.dom.NodeFactory;
import org.mozilla.dom.NodeImpl;
import org.mozilla.dom.NodeListImpl;
import org.mozilla.dom.ThreadProxy;
import org.mozilla.dom.UnsupportedException;
import org.mozilla.interfaces.nsIDOMAttr;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends NodeImpl
implements Element {
    public nsIDOMElement getInstance() {
        return this.getInstanceAsnsIDOMElement();
    }

    public ElementImpl(nsIDOMElement mozInst) {
        super(mozInst);
    }

    public static ElementImpl getDOMInstance(nsIDOMElement mozInst) {
        ElementImpl node = (ElementImpl)instances.get(mozInst);
        return node == null ? new ElementImpl(mozInst) : node;
    }

    public nsIDOMElement getInstanceAsnsIDOMElement() {
        if (this.moz == null) {
            return null;
        }
        return (nsIDOMElement)this.moz.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
    }

    public void removeAttributeNS(final String namespaceURI, final String localName) {
        Runnable r = new Runnable(){

            public void run() {
                ElementImpl.this.getInstanceAsnsIDOMElement().removeAttributeNS(namespaceURI, localName);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedException();
    }

    public boolean hasAttributeNS(final String namespaceURI, final String localName) {
        Callable<Boolean> c = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean result = ElementImpl.this.getInstanceAsnsIDOMElement().hasAttributeNS(namespaceURI, localName);
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void removeAttribute(final String name) {
        Runnable r = new Runnable(){

            public void run() {
                ElementImpl.this.getInstanceAsnsIDOMElement().removeAttribute(name);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public String getAttribute(final String name) {
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() {
                String result = ElementImpl.this.getInstanceAsnsIDOMElement().getAttribute(name);
                if (result != null && NodeFactory.getConvertNodeNamesToLowerCase()) {
                    return result.toLowerCase();
                }
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public NodeList getElementsByTagName(final String name) {
        Callable<NodeList> c = new Callable<NodeList>(){

            @Override
            public NodeList call() {
                nsIDOMNodeList result = ElementImpl.this.getInstanceAsnsIDOMElement().getElementsByTagName(name);
                return new NodeListImpl(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Attr setAttributeNodeNS(Attr newAttr) {
        final nsIDOMAttr mozNewattr = newAttr != null ? ((AttrImpl)newAttr).getInstance() : null;
        Callable<Attr> c = new Callable<Attr>(){

            @Override
            public Attr call() {
                nsIDOMAttr result = ElementImpl.this.getInstanceAsnsIDOMElement().setAttributeNodeNS(mozNewattr);
                return (Attr)NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void setAttribute(final String name, final String value) {
        Runnable r = new Runnable(){

            public void run() {
                ElementImpl.this.getInstanceAsnsIDOMElement().setAttribute(name, value);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public NodeList getElementsByTagNameNS(final String namespaceURI, final String localName) {
        Callable<NodeList> c = new Callable<NodeList>(){

            @Override
            public NodeList call() {
                nsIDOMNodeList result = ElementImpl.this.getInstanceAsnsIDOMElement().getElementsByTagNameNS(namespaceURI, localName);
                return new NodeListImpl(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public String getTagName() {
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() {
                String result = ElementImpl.this.getInstanceAsnsIDOMElement().getTagName();
                if (result != null && NodeFactory.getConvertNodeNamesToLowerCase()) {
                    return result.toLowerCase();
                }
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Attr getAttributeNode(final String name) {
        Callable<Attr> c = new Callable<Attr>(){

            @Override
            public Attr call() {
                nsIDOMAttr result = ElementImpl.this.getInstanceAsnsIDOMElement().getAttributeNode(name);
                return (Attr)NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) {
        nsIDOMAttr mozIdattr = idAttr != null ? ((AttrImpl)idAttr).getInstance() : null;
        throw new UnsupportedException();
    }

    public Attr getAttributeNodeNS(final String namespaceURI, final String localName) {
        Callable<Attr> c = new Callable<Attr>(){

            @Override
            public Attr call() {
                nsIDOMAttr result = ElementImpl.this.getInstanceAsnsIDOMElement().getAttributeNodeNS(namespaceURI, localName);
                return (Attr)NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Attr setAttributeNode(Attr newAttr) {
        final nsIDOMAttr mozNewattr = newAttr != null ? ((AttrImpl)newAttr).getInstance() : null;
        Callable<Attr> c = new Callable<Attr>(){

            @Override
            public Attr call() {
                nsIDOMAttr result = ElementImpl.this.getInstanceAsnsIDOMElement().setAttributeNode(mozNewattr);
                return (Attr)NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void setAttributeNS(final String namespaceURI, final String qualifiedName, final String value) {
        Runnable r = new Runnable(){

            public void run() {
                ElementImpl.this.getInstanceAsnsIDOMElement().setAttributeNS(namespaceURI, qualifiedName, value);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public void setIdAttribute(String name, boolean isId) {
        throw new UnsupportedException();
    }

    public boolean hasAttribute(final String name) {
        Callable<Boolean> c = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean result = ElementImpl.this.getInstanceAsnsIDOMElement().hasAttribute(name);
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public String getAttributeNS(final String namespaceURI, final String localName) {
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() {
                String result = ElementImpl.this.getInstanceAsnsIDOMElement().getAttributeNS(namespaceURI, localName);
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) {
        throw new UnsupportedException();
    }

    public Attr removeAttributeNode(Attr oldAttr) {
        final nsIDOMAttr mozOldattr = oldAttr != null ? ((AttrImpl)oldAttr).getInstance() : null;
        Callable<Attr> c = new Callable<Attr>(){

            @Override
            public Attr call() {
                nsIDOMAttr result = ElementImpl.this.getInstanceAsnsIDOMElement().removeAttributeNode(mozOldattr);
                return (Attr)NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }
}

