/*
 * Decompiled with CFR 0.152.
 */
package org.rubycoder.gsm;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.rubycoder.gsm.GSMDecoder;
import org.rubycoder.gsm.GSMEncoder;
import org.rubycoder.gsm.InvalidGSMFrameException;

public class GSMDriver {
    public static void main(String[] argv) {
        if (argv.length != 3) {
            System.err.print("Usage: GSMDriver d inputfile outputfile   -  decode from gsm file");
            System.err.print("       GSMDriver e inputfile outputfile   -  encode into gsm file");
            System.exit(2);
        }
        if (argv[0].equalsIgnoreCase("d")) {
            GSMDriver.decode(argv[1], argv[2]);
        } else if (argv[0].equalsIgnoreCase("e")) {
            GSMDriver.encode(argv[1], argv[2]);
        }
    }

    private static void encode(String input, String output) {
        GSMEncoder myEncoder = new GSMEncoder();
        byte[] inputArray = new byte[320];
        byte[] outputArray = new byte[33];
        FileInputStream fis = null;
        FileOutputStream fos = null;
        int[] inInts = new int[160];
        try {
            fis = new FileInputStream(input);
            fos = new FileOutputStream(output);
        }
        catch (Exception e) {
            System.err.println("file not found, or can't open.\n");
            System.exit(2);
        }
        while (true) {
            block11: {
                try {
                    if (fis.read(inputArray) <= 0) {
                    }
                    break block11;
                }
                catch (IOException e) {
                    System.err.println("error reading inputArray");
                }
                break;
            }
            int i = 0;
            while (i < 160) {
                int index = i << 1;
                inInts[i] = inputArray[index + 1];
                int n = i;
                inInts[n] = inInts[n] << 8;
                int n2 = i++;
                inInts[n2] = inInts[n2] | inputArray[index++] & 0xFF;
            }
            myEncoder.encode(outputArray, inInts);
            try {
                fos.write(outputArray);
            }
            catch (IOException e) {
                System.err.println("error writing outputArray");
                break;
            }
        }
        try {
            fis.close();
            fos.close();
        }
        catch (IOException e) {
            System.err.println("error closing files.");
        }
    }

    private static void decode(String input, String output) {
        GSMDecoder myDecoder = new GSMDecoder();
        byte[] inputArray = new byte[33];
        int[] outputArray = new int[160];
        FileInputStream fis = null;
        FileOutputStream fos = null;
        byte[] outBytes = new byte[320];
        if (input.equalsIgnoreCase("") || output.equalsIgnoreCase("")) {
            System.err.print("Usage: GSMDriver inputfile outputfile\n");
            System.exit(1);
        }
        try {
            fis = new FileInputStream(input);
            fos = new FileOutputStream(output);
        }
        catch (Exception e) {
            System.err.println("file not found, or can't open.\n");
            System.exit(2);
        }
        while (true) {
            block14: {
                try {
                    if (fis.read(inputArray) <= 0) {
                    }
                    break block14;
                }
                catch (IOException e) {
                    System.err.println("error reading inputArray");
                }
                break;
            }
            try {
                myDecoder.decode(inputArray, outputArray);
                for (int i = 0; i < 160; ++i) {
                    int index = i << 1;
                    outBytes[index] = (byte)(outputArray[i] & 0xFF);
                    outBytes[++index] = (byte)((outputArray[i] & 0xFF00) >> 8);
                }
                System.out.println("-");
                try {
                    fos.write(outBytes);
                }
                catch (IOException e) {
                    System.err.println("error writing outputArray");
                    break;
                }
            }
            catch (InvalidGSMFrameException e) {
                System.err.println("bad frame");
                break;
            }
        }
        try {
            fis.close();
            fos.close();
        }
        catch (IOException e) {
            System.err.println("error closing files.");
        }
    }
}

