/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph;

import java.util.logging.Logger;
import org.netbeans.modules.web.jsf.navigation.PageFlowToolbarUtilities;

public final class XmlScope {
    private static final Logger LOGGER = Logger.getLogger(XmlScope.class.getName());
    private static final String SCENE_FACES_SCOPE_XML = "Faces Configuration Only";
    private static final String SCENE_PROJECT_SCOPE_XML = "Project";
    private static final String SCENE_ALL_FACESCONFIG_XML = "All Faces Configurations";
    private static final String SCENE_FACES_SCOPE = PageFlowToolbarUtilities.getScopeLabel(PageFlowToolbarUtilities.Scope.SCOPE_FACESCONFIG);
    private static final String SCENE_PROJECT_SCOPE = PageFlowToolbarUtilities.getScopeLabel(PageFlowToolbarUtilities.Scope.SCOPE_PROJECT);
    private static final String SCENE_ALL_FACESCONFIG = PageFlowToolbarUtilities.getScopeLabel(PageFlowToolbarUtilities.Scope.SCOPE_ALL_FACESCONFIG);
    private String xmlScope;
    private PageFlowToolbarUtilities.Scope scope;
    public static final XmlScope SCOPE_FACES = new XmlScope(PageFlowToolbarUtilities.Scope.SCOPE_FACESCONFIG);
    public static final XmlScope SCOPE_PROJECT = new XmlScope(PageFlowToolbarUtilities.Scope.SCOPE_PROJECT);
    public static final XmlScope SCOPE_ALL = new XmlScope(PageFlowToolbarUtilities.Scope.SCOPE_ALL_FACESCONFIG);

    private XmlScope(PageFlowToolbarUtilities.Scope scope) {
        this.xmlScope = this.getScopeXmlFromScope(scope);
        this.scope = scope;
    }

    public PageFlowToolbarUtilities.Scope getScope() {
        return this.scope;
    }

    public String toString() {
        return this.xmlScope;
    }

    public static final XmlScope getInstance(String string) {
        XmlScope xmlScope = XmlScope.getXmlScopeFromXmlStr(string);
        if (xmlScope == null) {
            xmlScope = XmlScope.getXmlScopeFromLocStr(string);
        }
        assert (xmlScope != null);
        if (xmlScope == null) {
            LOGGER.severe(XmlScope.class.getName() + ": myXmlScope is null and it should not be.  For string:" + string);
            LOGGER.severe(XmlScope.class.getName() + ": Setting to Project Scope regardless as to not cause unnessary errors.");
            xmlScope = SCOPE_PROJECT;
        }
        return xmlScope;
    }

    private final String getScopeXmlFromScope(PageFlowToolbarUtilities.Scope scope) {
        String string;
        switch (scope) {
            case SCOPE_FACESCONFIG: {
                string = SCENE_FACES_SCOPE_XML;
                break;
            }
            case SCOPE_PROJECT: {
                string = SCENE_PROJECT_SCOPE_XML;
                break;
            }
            case SCOPE_ALL_FACESCONFIG: {
                string = SCENE_ALL_FACESCONFIG_XML;
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    private static final XmlScope getXmlScopeFromXmlStr(String string) {
        XmlScope xmlScope = null;
        if (string.equals(SCENE_FACES_SCOPE_XML)) {
            xmlScope = SCOPE_FACES;
        } else if (string.equals(SCENE_PROJECT_SCOPE_XML)) {
            xmlScope = SCOPE_PROJECT;
        } else if (string.equals(SCENE_ALL_FACESCONFIG_XML)) {
            xmlScope = SCOPE_ALL;
        }
        return xmlScope;
    }

    private static final XmlScope getXmlScopeFromLocStr(String string) {
        XmlScope xmlScope = null;
        if (string.equals(SCENE_FACES_SCOPE)) {
            xmlScope = SCOPE_FACES;
        } else if (string.equals(SCENE_PROJECT_SCOPE)) {
            xmlScope = SCOPE_PROJECT;
        } else if (string.equals(SCENE_ALL_FACESCONFIG)) {
            xmlScope = SCOPE_ALL;
        }
        return xmlScope;
    }
}

