/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.netbeans.modules.web.jsf.navigation.NavigationCaseEdge;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.PageFlowToolbarUtilities;
import org.netbeans.modules.web.jsf.navigation.Pin;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowScene;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneElement;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageFlowDeleteAction
extends AbstractAction {
    private final PageFlowScene scene;
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.web.jsf.navigation.graph.actions.PageFlowDeleteAction");
    private final Collection<NavigationCaseEdge> thoseEdges = new ArrayList<NavigationCaseEdge>();
    private final Collection<NavigationCaseEdge> theseEdges = new ArrayList<NavigationCaseEdge>();

    public PageFlowDeleteAction(PageFlowScene pageFlowScene) {
        this.scene = pageFlowScene;
        this.putValue("ACCELERATOR_KEY", KeyStroke.getKeyStroke(127, 0));
    }

    @Override
    public boolean isEnabled() {
        Set set = this.scene.getSelectedObjects();
        if (set.isEmpty()) {
            return false;
        }
        for (Object e : set) {
            if (!(e instanceof PageFlowSceneElement)) {
                return false;
            }
            PageFlowSceneElement pageFlowSceneElement = (PageFlowSceneElement)e;
            if (!pageFlowSceneElement.isModifiable()) {
                return false;
            }
            if (!this.scene.getPageFlowView().getPageFlowController().isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_ALL_FACESCONFIG) || !(pageFlowSceneElement instanceof Page)) continue;
            this.thoseEdges.clear();
            this.theseEdges.clear();
            ArrayList arrayList = new ArrayList();
            Collection collection = this.scene.getNodePins((Page)pageFlowSceneElement);
            for (PageFlowSceneElement pageFlowSceneElement2 : collection) {
                arrayList.addAll(this.scene.findPinEdges(pageFlowSceneElement2, true, true));
            }
            for (PageFlowSceneElement pageFlowSceneElement2 : arrayList) {
                if (pageFlowSceneElement2.isModifiable()) {
                    this.theseEdges.add((NavigationCaseEdge)pageFlowSceneElement2);
                    continue;
                }
                this.thoseEdges.add((NavigationCaseEdge)pageFlowSceneElement2);
            }
            if (!this.theseEdges.isEmpty()) continue;
            return false;
        }
        return super.isEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        LinkedList<PageFlowSceneElement> linkedList = new LinkedList<PageFlowSceneElement>();
        HashSet hashSet = new HashSet(this.scene.getSelectedObjects());
        LOG.fine("Selected Objects: " + hashSet);
        LOG.finest("Scene: \nNodes: " + this.scene.getNodes() + "\n" + "Edges: " + this.scene.getEdges() + "\n" + "Pins: " + this.scene.getPins());
        if (hashSet.size() == 1 && (object = hashSet.toArray()[0]) instanceof PageFlowSceneElement) {
            linkedList.add((PageFlowSceneElement)object);
            this.deleteNodes(linkedList);
            return;
        }
        object = new HashSet();
        HashSet<PageFlowSceneElement> hashSet2 = new HashSet<PageFlowSceneElement>();
        HashSet hashSet3 = new HashSet();
        for (Object e : hashSet) {
            if (!(e instanceof PageFlowSceneElement)) continue;
            if (this.scene.isEdge(e)) {
                assert (!this.scene.isPin(e));
                object.add((NavigationCaseEdge)e);
                continue;
            }
            assert (this.scene.isNode(e) || this.scene.isPin(e));
            hashSet2.add((PageFlowSceneElement)e);
        }
        linkedList.addAll((Collection<PageFlowSceneElement>)object);
        linkedList.addAll(hashSet2);
        this.deleteNodes(linkedList);
    }

    private void deleteNodes(Queue<PageFlowSceneElement> queue) {
        final Queue<PageFlowSceneElement> queue2 = queue;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    for (PageFlowSceneElement pageFlowSceneElement : queue2) {
                        if (!pageFlowSceneElement.canDestroy()) continue;
                        if (pageFlowSceneElement instanceof NavigationCaseEdge) {
                            PageFlowDeleteAction.this.updateSourcePins((NavigationCaseEdge)pageFlowSceneElement);
                        }
                        if (PageFlowDeleteAction.this.scene.getPageFlowView().getPageFlowController().isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_ALL_FACESCONFIG)) {
                            if (PageFlowDeleteAction.this.thoseEdges.isEmpty()) {
                                pageFlowSceneElement.destroy();
                            } else {
                                for (NavigationCaseEdge navigationCaseEdge : PageFlowDeleteAction.this.theseEdges) {
                                    if (PageFlowDeleteAction.this.scene.findWidget(navigationCaseEdge) == null) continue;
                                    PageFlowDeleteAction.this.updateSourcePins(navigationCaseEdge);
                                    navigationCaseEdge.destroy();
                                }
                            }
                            PageFlowDeleteAction.this.thoseEdges.clear();
                            continue;
                        }
                        pageFlowSceneElement.destroy();
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        });
    }

    private void updateSourcePins(NavigationCaseEdge navigationCaseEdge) {
        Pin pin = (Pin)this.scene.getEdgeSource(navigationCaseEdge);
        if (pin != null && !pin.isDefault()) {
            pin.setFromOutcome(null);
        }
    }
}

