/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final Logger log = DLightLogger.getLogger(Util.class);

    private Util() {
    }

    private static String getFullPath(String string) {
        File file = InstalledFileLocator.getDefault().locate(string, null, false);
        if (file != null && file.exists()) {
            return file.getAbsolutePath();
        }
        return string;
    }

    public static File copyToTempDir(Class<?> clazz, String string) throws IOException {
        return Util.copyToTempDir(clazz.getClassLoader().getResource(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyToTempDir(URL uRL) throws IOException {
        if (uRL == null) {
            return null;
        }
        InputStream inputStream = uRL.openStream();
        try {
            File file;
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
            if (hostInfo == null) {
                throw new IOException("Failed to get local ExecutionEnvironment");
            }
            String string = "_dlight_" + Util.getBriefName(uRL);
            String string2 = hostInfo.getTempDir();
            HostInfo.OSFamily oSFamily = hostInfo.getOSFamily();
            hostInfo.getOSFamily();
            if (oSFamily == HostInfo.OSFamily.WINDOWS) {
                string2 = WindowsSupport.getInstance().convertToWindowsPath(string2);
            }
            File file2 = File.createTempFile(string, "", new File(string2));
            file2.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                FileUtil.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                fileOutputStream.flush();
                file = file2;
            }
            catch (Throwable throwable) {
                ((OutputStream)fileOutputStream).close();
                throw throwable;
            }
            ((OutputStream)fileOutputStream).close();
            return file;
        }
        finally {
            inputStream.close();
        }
    }

    public static String getBriefName(URL uRL) {
        String string = uRL.getFile();
        int n = string.lastIndexOf(47);
        string = n >= 0 ? string.substring(n + 1) : string;
        return string;
    }

    public static void setExecutionPermissions(List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Object arrayList2 = list.iterator();
        while (arrayList2.hasNext()) {
            String object2;
            String iOException = object2 = arrayList2.next();
            if (!new File(object2).exists()) {
                iOException = Util.getFullPath(object2);
            }
            if (!new File(iOException).exists()) continue;
            arrayList.add(iOException);
        }
        arrayList2 = new ArrayList();
        arrayList2.add("/bin/chmod");
        arrayList2.add("755");
        arrayList2.addAll(arrayList);
        ProcessBuilder processBuilder = new ProcessBuilder((List<String>)arrayList2);
        try {
            processBuilder.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String getBasePath(Class<?> clazz) {
        String string = clazz.getName().replace('.', '/');
        int n = string.lastIndexOf(47);
        return n > 0 ? string.substring(0, n) : string;
    }

    public static boolean getBoolean(String string, boolean bl) {
        String string2 = System.getProperty(string);
        return string2 == null ? bl : Boolean.parseBoolean(string2);
    }

    public static boolean deleteLocalDirectory(File file) {
        File[] fileArray;
        if (file.exists() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    Util.deleteLocalDirectory(fileArray[i]);
                    continue;
                }
                boolean bl = fileArray[i].delete();
                if (bl || !log.isLoggable(Level.FINE)) continue;
                log.fine("Unable to delete file " + fileArray[i].getAbsolutePath());
            }
        }
        return file.delete();
    }

    public static <T> T firstInstanceOf(Class<T> clazz, Collection<? super T> collection) {
        for (T t : collection) {
            if (!clazz.isAssignableFrom(t.getClass())) continue;
            return clazz.cast(t);
        }
        return null;
    }

    public static <T> T maskNull(T t, T t2) {
        return t == null ? t2 : t;
    }
}

