/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util.usagetracking;

import java.io.IOException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.util.RequestProcessor;

public final class SunStudioUserCounter {
    private static final boolean SUNW_NO_UPDATE_NOTIFY;
    private static final RequestProcessor SS_USER_COUNT;
    private static IDEType appType;

    private SunStudioUserCounter() {
    }

    public static IDEType getIDEType() {
        if (appType == null) {
            String string = System.getProperty("spro.ide.name");
            appType = "sside".equals(string) ? IDEType.SUN_STUDIO_IDE : ("dlighttool".equals(string) ? IDEType.DLIGHTTOOL : ("dbxtool".equals(string) ? IDEType.DBX_TOOL : IDEType.CND));
        }
        return appType;
    }

    private static String getSunStudioBinDir(ExecutionEnvironment executionEnvironment) {
        if (executionEnvironment != null && executionEnvironment.isRemote()) {
            return null;
        }
        String string = System.getProperty("spro.bin");
        if (string == null) {
            string = System.getProperty("spro.home");
            if (string != null) {
                if (!string.endsWith("/") && !string.endsWith("\\")) {
                    string = string + "/";
                }
                string = string + "bin/";
            }
        } else {
            string = string + "/";
        }
        return string;
    }

    private static String getCheckUpdatePath(String string, ExecutionEnvironment executionEnvironment) {
        String string2 = System.getProperty("spro.check_update");
        if (string2 == null || string != null && executionEnvironment.isRemote()) {
            String string3 = string = string == null ? SunStudioUserCounter.getSunStudioBinDir(executionEnvironment) : string;
            if (string != null) {
                if (!string.endsWith("/") && !string.endsWith("\\")) {
                    string = string + "/";
                }
                string2 = string + "../prod/bin/check_update";
            }
        }
        return string2;
    }

    public static void countIDE(String string, ExecutionEnvironment executionEnvironment) {
        SunStudioUserCounter.countTool(SunStudioUserCounter.getCheckUpdatePath(string, executionEnvironment), executionEnvironment, SunStudioUserCounter.getIDEType().getTag());
    }

    public static void countDLight(ExecutionEnvironment executionEnvironment) {
        ExecutionEnvironment executionEnvironment2;
        String string;
        if (SUNW_NO_UPDATE_NOTIFY) {
            return;
        }
        String string2 = SunStudioUserCounter.getIDEType() == IDEType.DLIGHTTOOL ? "dlight" : "dlightss";
        if (!executionEnvironment.isLocal() && (string = SunStudioUserCounter.getCheckUpdatePath(null, executionEnvironment2 = ExecutionEnvironmentFactory.getLocal())) != null) {
            SunStudioUserCounter.countTool(string, executionEnvironment2, string2);
            return;
        }
        SunStudioUserCounter.countTool(SunStudioUserCounter.getCheckUpdatePath(null, executionEnvironment), executionEnvironment, string2);
    }

    public static void countGizmo(String string, ExecutionEnvironment executionEnvironment) {
        String string2 = null;
        if (string != null) {
            string2 = !string.endsWith("/") && !string.endsWith("\\") ? string + "/bin/" : string + "bin/";
        }
        SunStudioUserCounter.countTool(SunStudioUserCounter.getCheckUpdatePath(string2, executionEnvironment), executionEnvironment, "gizmo");
    }

    private static void countTool(final String string, final ExecutionEnvironment executionEnvironment, final String string2) {
        if (SUNW_NO_UPDATE_NOTIFY) {
            return;
        }
        if (string == null || executionEnvironment == null || string2 == null) {
            return;
        }
        if (ConnectionManager.getInstance().isConnectedTo(executionEnvironment)) {
            SS_USER_COUNT.post(new Runnable(){

                public void run() {
                    NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)executionEnvironment).setExecutable(string).setArguments(new String[]{string2});
                    try {
                        nativeProcessBuilder.call();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    static {
        SS_USER_COUNT = new RequestProcessor("SunStudio check_update");
        SUNW_NO_UPDATE_NOTIFY = System.getProperty("SUNW_NO_UPDATE_NOTIFY") != null;
        appType = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IDEType {
        CND("cnd"),
        SUN_STUDIO_IDE("ide"),
        DBX_TOOL("dbxtool"),
        DLIGHTTOOL("dlighttool");

        private final String tag;

        private IDEType(String string2) {
            this.tag = string2;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

