/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.project.libraries.LibraryDeclarationConvertorImpl;
import org.netbeans.modules.project.libraries.LibraryDeclarationHandlerImpl;
import org.netbeans.modules.project.libraries.LibraryDeclarationParser;
import org.netbeans.modules.project.libraries.LibraryTypeRegistry;
import org.netbeans.modules.project.libraries.WritableLibraryProvider;
import org.netbeans.modules.project.libraries.ui.LibrariesCustomizer;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibrariesStorage
extends FileChangeAdapter
implements WritableLibraryProvider<LibraryImplementation>,
ChangeListener {
    private static final String NB_HOME_PROPERTY = "netbeans.home";
    private static final String LIBRARIES_REPOSITORY = "org-netbeans-api-project-libraries/Libraries";
    private static final String TIME_STAMPS_FILE = "libraries-timestamps.properties";
    private static final String XML_EXT = "xml";
    static final Logger LOG = Logger.getLogger(LibrariesStorage.class.getName());
    private static final Object TIMESTAMPS_LOCK = new Object();
    private FileObject storage = null;
    private Map<String, LibraryImplementation> libraries;
    private Map<String, LibraryImplementation> librariesByFileNames;
    private ResourceBundle bundle;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean initialized;
    private Properties timeStamps;

    public LibrariesStorage() {
    }

    LibrariesStorage(FileObject fileObject) {
        this();
        this.storage = fileObject;
    }

    private static final FileObject createStorage() {
        try {
            return FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)LIBRARIES_REPOSITORY);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void loadFromStorage(Map<? super String, ? super LibraryImplementation> map, Map<? super String, ? super LibraryImplementation> map2) {
        if (this.storage == null) {
            return;
        }
        LibraryDeclarationHandlerImpl libraryDeclarationHandlerImpl = new LibraryDeclarationHandlerImpl();
        LibraryDeclarationConvertorImpl libraryDeclarationConvertorImpl = new LibraryDeclarationConvertorImpl();
        LibraryDeclarationParser libraryDeclarationParser = new LibraryDeclarationParser(libraryDeclarationHandlerImpl, libraryDeclarationConvertorImpl);
        for (FileObject fileObject : this.storage.getChildren()) {
            if (!XML_EXT.equalsIgnoreCase(fileObject.getExt())) continue;
            try {
                libraryDeclarationHandlerImpl.setLibrary(null);
                LibrariesStorage.readLibrary(fileObject, libraryDeclarationParser);
                LibraryImplementation libraryImplementation = libraryDeclarationHandlerImpl.getLibrary();
                if (libraryImplementation == null) continue;
                LibraryTypeProvider libraryTypeProvider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(libraryImplementation.getType());
                if (libraryTypeProvider == null) {
                    LOG.warning("LibrariesStorage: Can not invoke LibraryTypeProvider.libraryCreated(), the library type provider is unknown.");
                    continue;
                }
                if (map.keySet().contains(libraryImplementation.getName())) {
                    LOG.warning("LibrariesStorage: Library \"" + libraryImplementation.getName() + "\" is already defined, skeeping the definition from: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                    continue;
                }
                if (!this.isUpToDate(fileObject)) {
                    libraryTypeProvider.libraryCreated(libraryImplementation);
                    this.updateTimeStamp(fileObject);
                }
                map2.put(fileObject.getPath(), libraryImplementation);
                map.put(libraryImplementation.getName(), libraryImplementation);
                LibrariesCustomizer.registerSource(libraryImplementation, fileObject);
            }
            catch (SAXException sAXException) {
                LOG.warning(String.format("File %s contains broken library descriptor.", FileUtil.getFileDisplayName((FileObject)fileObject)));
            }
            catch (ParserConfigurationException parserConfigurationException) {
                Exceptions.printStackTrace((Throwable)parserConfigurationException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (RuntimeException runtimeException) {
                Exceptions.printStackTrace((Throwable)runtimeException);
            }
        }
        try {
            this.saveTimeStamps();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStorage() {
        boolean bl;
        Object object = this;
        synchronized (object) {
            if (!this.initialized) {
                if (this.storage == null) {
                    this.storage = LibrariesStorage.createStorage();
                }
                if (this.storage != null) {
                    this.storage.addFileChangeListener((FileChangeListener)this);
                }
                LibraryTypeRegistry.getDefault().addChangeListener(this);
                this.initialized = true;
            }
            bl = this.libraries == null || LibraryTypeRegistry.getDefault().hasChanged();
        }
        if (bl) {
            object = new HashMap();
            HashMap<String, LibraryImplementation> hashMap = new HashMap<String, LibraryImplementation>();
            this.loadFromStorage((Map<? super String, ? super LibraryImplementation>)object, hashMap);
            LibrariesStorage librariesStorage = this;
            synchronized (librariesStorage) {
                this.libraries = object;
                this.librariesByFileNames = hashMap;
            }
        }
    }

    private static LibraryImplementation readLibrary(FileObject fileObject) throws SAXException, ParserConfigurationException, IOException {
        return LibrariesStorage.readLibrary(fileObject, (LibraryImplementation)null);
    }

    private static LibraryImplementation readLibrary(FileObject fileObject, LibraryImplementation libraryImplementation) throws SAXException, ParserConfigurationException, IOException {
        LibraryDeclarationHandlerImpl libraryDeclarationHandlerImpl = new LibraryDeclarationHandlerImpl();
        LibraryDeclarationConvertorImpl libraryDeclarationConvertorImpl = new LibraryDeclarationConvertorImpl();
        LibraryDeclarationParser libraryDeclarationParser = new LibraryDeclarationParser(libraryDeclarationHandlerImpl, libraryDeclarationConvertorImpl);
        libraryDeclarationHandlerImpl.setLibrary(libraryImplementation);
        LibrariesStorage.readLibrary(fileObject, libraryDeclarationParser);
        LibrariesCustomizer.registerSource(libraryImplementation, fileObject);
        return libraryDeclarationHandlerImpl.getLibrary();
    }

    private static void readLibrary(FileObject fileObject, LibraryDeclarationParser libraryDeclarationParser) throws SAXException, ParserConfigurationException, IOException {
        URL uRL = fileObject.getURL();
        InputSource inputSource = new InputSource(uRL.toExternalForm());
        inputSource.setByteStream(fileObject.getInputStream());
        try {
            libraryDeclarationParser.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw (SAXException)Exceptions.attachMessage((Throwable)sAXException, (String)("From: " + uRL));
        }
    }

    private void writeLibrary(final FileObject fileObject, final LibraryImplementation libraryImplementation) throws IOException {
        fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                String string = libraryImplementation.getType();
                LibraryTypeProvider libraryTypeProvider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(string);
                if (libraryTypeProvider == null) {
                    LOG.warning("LibrariesStorage: Cannot store library, the library type is not recognized by any of installed LibraryTypeProviders.");
                    return;
                }
                FileObject fileObject2 = fileObject.createData(libraryImplementation.getName(), LibrariesStorage.XML_EXT);
                LibrariesStorage.writeLibraryDefinition(fileObject2, libraryImplementation, libraryTypeProvider);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLibraryDefinition(FileObject fileObject, LibraryImplementation libraryImplementation, LibraryTypeProvider libraryTypeProvider) throws IOException {
        String string;
        Document document = XMLUtil.createDocument((String)"library", null, (String)"-//NetBeans//DTD Library Declaration 1.0//EN", (String)"http://www.netbeans.org/dtds/library-declaration-1_0.dtd");
        Element element = document.getDocumentElement();
        element.setAttribute("version", "1.0");
        element.appendChild(document.createElement("name")).appendChild(document.createTextNode(libraryImplementation.getName()));
        element.appendChild(document.createElement("type")).appendChild(document.createTextNode(libraryImplementation.getType()));
        String string2 = libraryImplementation.getDescription();
        if (string2 != null && string2.length() > 0) {
            element.appendChild(document.createElement("description")).appendChild(document.createTextNode(string2));
        }
        if ((string = libraryImplementation.getLocalizingBundle()) != null && string.length() > 0) {
            element.appendChild(document.createElement("localizing-bundle")).appendChild(document.createTextNode(string));
        }
        for (String string3 : libraryTypeProvider.getSupportedVolumeTypes()) {
            Element element2 = (Element)element.appendChild(document.createElement("volume"));
            element2.appendChild(document.createElement("type")).appendChild(document.createTextNode(string3));
            List<URL> list = libraryImplementation.getContent(string3);
            if (list == null) continue;
            for (URL uRL : list) {
                element2.appendChild(document.createElement("resource")).appendChild(document.createTextNode(uRL.toString()));
            }
        }
        OutputStream outputStream = fileObject.getOutputStream();
        try {
            XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
        }
        finally {
            outputStream.close();
        }
    }

    private void fireLibrariesChanged() {
        this.support.firePropertyChange("libraries", null, null);
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LibraryImplementation[] getLibraries() {
        this.initStorage();
        LibrariesStorage librariesStorage = this;
        synchronized (librariesStorage) {
            assert (this.storage != null) : "Storage is not initialized";
            assert (this.libraries != null);
            return this.libraries.values().toArray(new LibraryImplementation[this.libraries.size()]);
        }
    }

    @Override
    public void addLibrary(LibraryImplementation libraryImplementation) throws IOException {
        this.initStorage();
        assert (this.storage != null) : "Storage is not initialized";
        this.writeLibrary(this.storage, libraryImplementation);
    }

    @Override
    public void removeLibrary(LibraryImplementation libraryImplementation) throws IOException {
        this.initStorage();
        assert (this.storage != null) : "Storage is not initialized";
        for (String string : this.librariesByFileNames.keySet()) {
            FileObject fileObject;
            LibraryImplementation libraryImplementation2 = this.librariesByFileNames.get(string);
            if (!libraryImplementation.equals(libraryImplementation2) || (fileObject = this.storage.getFileSystem().findResource(string)) == null) continue;
            fileObject.delete();
            return;
        }
    }

    @Override
    public void updateLibrary(LibraryImplementation libraryImplementation, final LibraryImplementation libraryImplementation2) throws IOException {
        this.initStorage();
        assert (this.storage != null) : "Storage is not initialized";
        for (String string : this.librariesByFileNames.keySet()) {
            FileObject fileObject;
            LibraryImplementation libraryImplementation3 = this.librariesByFileNames.get(string);
            if (!libraryImplementation.equals(libraryImplementation3) || (fileObject = this.storage.getFileSystem().findResource(string)) == null) continue;
            String string2 = libraryImplementation2.getType();
            final LibraryTypeProvider libraryTypeProvider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(string2);
            if (libraryTypeProvider == null) {
                LOG.warning("LibrariesStorageL Cannot store library, the library type is not recognized by any of installed LibraryTypeProviders.");
                return;
            }
            this.storage.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    LibrariesStorage.writeLibraryDefinition(fileObject, libraryImplementation2, libraryTypeProvider);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileDataCreated(FileEvent fileEvent) {
        block10: {
            FileObject fileObject = fileEvent.getFile();
            try {
                LibraryImplementation libraryImplementation = LibrariesStorage.readLibrary(fileObject);
                if (libraryImplementation == null) break block10;
                LibraryTypeProvider libraryTypeProvider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(libraryImplementation.getType());
                if (libraryTypeProvider == null) {
                    LOG.warning("LibrariesStorage: Can not invoke LibraryTypeProvider.libraryCreated(), the library type provider is unknown.");
                    break block10;
                }
                LibrariesStorage librariesStorage = this;
                synchronized (librariesStorage) {
                    this.libraries.put(libraryImplementation.getName(), libraryImplementation);
                    this.librariesByFileNames.put(fileObject.getPath(), libraryImplementation);
                }
                try {
                    libraryTypeProvider.libraryCreated(libraryImplementation);
                    this.updateTimeStamp(fileObject);
                    this.saveTimeStamps();
                }
                catch (RuntimeException runtimeException) {
                    String string = NbBundle.getMessage(LibrariesStorage.class, (String)"MSG_libraryCreatedError");
                    Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)runtimeException, (String)string));
                }
                this.fireLibrariesChanged();
            }
            catch (SAXException sAXException) {
                Exceptions.printStackTrace((Throwable)sAXException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                Exceptions.printStackTrace((Throwable)parserConfigurationException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileDeleted(FileEvent fileEvent) {
        LibraryImplementation libraryImplementation;
        String string = fileEvent.getFile().getPath();
        Object object = this;
        synchronized (object) {
            libraryImplementation = this.librariesByFileNames.remove(string);
            if (libraryImplementation != null) {
                this.libraries.remove(libraryImplementation.getName());
            }
        }
        if (libraryImplementation != null) {
            object = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(libraryImplementation.getType());
            if (object == null) {
                LOG.warning("LibrariesStorage: Cannot invoke LibraryTypeProvider.libraryDeleted(), the library type provider is unknown.");
            } else {
                try {
                    object.libraryDeleted(libraryImplementation);
                }
                catch (RuntimeException runtimeException) {
                    String string2 = NbBundle.getMessage(LibrariesStorage.class, (String)"MSG_libraryDeletedError");
                    Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)runtimeException, (String)string2));
                }
            }
            this.fireLibrariesChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileChanged(FileEvent fileEvent) {
        LibraryImplementation libraryImplementation;
        FileObject fileObject = fileEvent.getFile();
        String string = fileObject.getPath();
        Object object = this;
        synchronized (object) {
            libraryImplementation = this.librariesByFileNames.get(string);
        }
        if (libraryImplementation != null) {
            try {
                LibrariesStorage.readLibrary(fileObject, libraryImplementation);
                object = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(libraryImplementation.getType());
                if (object == null) {
                    LOG.warning("LibrariesStorage: Can not invoke LibraryTypeProvider.libraryCreated(), the library type provider is unknown.");
                }
                try {
                    object.libraryCreated(libraryImplementation);
                    this.updateTimeStamp(fileObject);
                    this.saveTimeStamps();
                }
                catch (RuntimeException runtimeException) {
                    String string2 = NbBundle.getMessage(LibrariesStorage.class, (String)"MSG_libraryCreatedError");
                    Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)runtimeException, (String)string2));
                }
            }
            catch (SAXException sAXException) {
                Exceptions.printStackTrace((Throwable)sAXException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                Exceptions.printStackTrace((Throwable)parserConfigurationException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    protected final ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(LibrariesStorage.class);
        }
        return this.bundle;
    }

    private boolean isUpToDate(FileObject fileObject) {
        Properties properties = this.getTimeStamps();
        String string = (String)properties.get(fileObject.getNameExt());
        return string == null ? false : Long.parseLong(string) >= fileObject.lastModified().getTime();
    }

    private void updateTimeStamp(FileObject fileObject) {
        Properties properties = this.getTimeStamps();
        properties.put(fileObject.getNameExt(), Long.toString(fileObject.lastModified().getTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTimeStamps() throws IOException {
        if (this.storage != null) {
            Object object = TIMESTAMPS_LOCK;
            synchronized (object) {
                FileObject fileObject;
                String string;
                Properties properties = this.getTimeStamps();
                if (properties.get(NB_HOME_PROPERTY) == null) {
                    string = LibrariesStorage.getNBRoots();
                    properties.put(NB_HOME_PROPERTY, string);
                }
                if ((fileObject = (string = this.storage.getParent()).getFileObject(TIME_STAMPS_FILE)) == null) {
                    fileObject = string.createData(TIME_STAMPS_FILE);
                }
                FileLock fileLock = fileObject.lock();
                try {
                    OutputStream outputStream = fileObject.getOutputStream(fileLock);
                    try {
                        properties.store(outputStream, null);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Properties getTimeStamps() {
        if (this.timeStamps == null) {
            FileObject fileObject;
            this.timeStamps = new Properties();
            if (this.storage != null && (fileObject = this.storage.getParent().getFileObject(TIME_STAMPS_FILE)) != null) {
                try {
                    InputStream inputStream = fileObject.getInputStream();
                    try {
                        this.timeStamps.load(inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                    String string = (String)this.timeStamps.get(NB_HOME_PROPERTY);
                    String string2 = LibrariesStorage.getNBRoots();
                    if (string == null || !string.equals(string2)) {
                        this.timeStamps.clear();
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        return this.timeStamps;
    }

    private static String getNBRoots() {
        Object object;
        Object object2;
        TreeSet<String> treeSet = new TreeSet<String>();
        String string = System.getProperty(NB_HOME_PROPERTY);
        if (string != null && ((File)(object2 = FileUtil.normalizeFile((File)new File(string)))).isDirectory()) {
            treeSet.add(((File)object2).getAbsolutePath());
        }
        if ((string = System.getProperty("netbeans.dirs")) != null) {
            object2 = new StringTokenizer(string, File.pathSeparator);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = FileUtil.normalizeFile((File)new File(((StringTokenizer)object2).nextToken()));
                treeSet.add(((File)object).getAbsolutePath());
            }
        }
        object2 = new StringBuffer();
        object = treeSet.iterator();
        while (object.hasNext()) {
            ((StringBuffer)object2).append((String)object.next());
            if (!object.hasNext()) continue;
            ((StringBuffer)object2).append(":");
        }
        return ((StringBuffer)object2).toString();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireLibrariesChanged();
    }
}

