/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

public final class LibraryTypeRegistry {
    private static final String REGISTRY = "org-netbeans-api-project-libraries/LibraryTypeProviders";
    private static LibraryTypeRegistry instance;
    private final Lookup.Result<LibraryTypeProvider> result;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private volatile Set<? extends LibraryTypeProvider> usedLibraryTypes;

    private LibraryTypeRegistry() {
        Lookup lookup = Lookups.forPath((String)REGISTRY);
        assert (lookup != null);
        this.result = lookup.lookupResult(LibraryTypeProvider.class);
        this.result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                LibraryTypeRegistry.this.changeSupport.fireChange();
            }
        });
    }

    public LibraryTypeProvider[] getLibraryTypeProviders() {
        assert (this.result != null);
        Collection collection = this.result.allInstances();
        return collection.toArray(new LibraryTypeProvider[collection.size()]);
    }

    public LibraryTypeProvider getLibraryTypeProvider(String string) {
        LibraryTypeProvider[] libraryTypeProviderArray;
        assert (string != null);
        for (LibraryTypeProvider libraryTypeProvider : libraryTypeProviderArray = this.getLibraryTypeProviders()) {
            if (!string.equals(libraryTypeProvider.getLibraryType())) continue;
            return libraryTypeProvider;
        }
        return null;
    }

    public boolean hasChanged() {
        Set<? extends LibraryTypeProvider> set = this.usedLibraryTypes;
        LibraryTypeProvider[] libraryTypeProviderArray = this.getLibraryTypeProviders();
        IdentityHashMap<LibraryTypeProvider, LibraryTypeProvider> identityHashMap = new IdentityHashMap<LibraryTypeProvider, LibraryTypeProvider>();
        for (LibraryTypeProvider libraryTypeProvider : libraryTypeProviderArray) {
            identityHashMap.put(libraryTypeProvider, libraryTypeProvider);
        }
        this.usedLibraryTypes = identityHashMap.keySet();
        return set == null || !((Object)set).equals(identityHashMap.keySet());
    }

    public void addChangeListener(ChangeListener changeListener) {
        assert (changeListener != null);
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        assert (changeListener != null);
        this.changeSupport.removeChangeListener(changeListener);
    }

    public static synchronized LibraryTypeRegistry getDefault() {
        if (instance == null) {
            instance = new LibraryTypeRegistry();
        }
        return instance;
    }
}

