/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Locale;
import javax.xml.parsers.SAXParserFactory;
import org.ini4j.AbstractParser;
import org.ini4j.Config;
import org.ini4j.IniHandler;
import org.ini4j.IniSource;
import org.ini4j.InvalidIniFormatException;
import org.ini4j.spi.ServiceFinder;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IniParser
extends AbstractParser {
    private static final String COMMENTS = ";#";
    private static final String OPERATORS = ":=";
    public static final char SECTION_BEGIN = '[';
    public static final char SECTION_END = ']';
    static /* synthetic */ Class class$org$ini4j$IniParser;

    public IniParser() {
        super(OPERATORS, COMMENTS);
    }

    public static IniParser newInstance() {
        Class<?> clazz = class$org$ini4j$IniParser;
        if (clazz == null) {
            clazz = class$org$ini4j$IniParser = new IniParser[0].getClass().getComponentType();
        }
        return (IniParser)ServiceFinder.findService(clazz);
    }

    public static IniParser newInstance(Config config) {
        IniParser instance = IniParser.newInstance();
        instance.setConfig(config);
        return instance;
    }

    public void parse(InputStream input, IniHandler handler) throws IOException, InvalidIniFormatException {
        this.parse(this.newIniSource(input), handler);
    }

    public void parse(Reader input, IniHandler handler) throws IOException, InvalidIniFormatException {
        this.parse(this.newIniSource(input), handler);
    }

    public void parse(URL input, IniHandler handler) throws IOException, InvalidIniFormatException {
        this.parse(this.newIniSource(input), handler);
    }

    public void parseXML(InputStream input, IniHandler handler) throws IOException, InvalidIniFormatException {
        this.parseXML(new InputStreamReader(input), handler);
    }

    public void parseXML(Reader input, final IniHandler handler) throws IOException, InvalidIniFormatException {
        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class XmlToIni
        extends DefaultHandler {
            private static final String TAG_SECTION = "section";
            private static final String TAG_OPTION = "option";
            private static final String TAG_INI = "ini";
            private static final String ATTR_KEY = "key";
            private static final String ATTR_VALUE = "value";
            private static final String ATTR_VERSION = "version";
            private static final String CURRENT_VERSION = "1.0";

            XmlToIni() {
            }

            @Override
            public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
                String key = attrs.getValue(ATTR_KEY);
                if (qname.equals(TAG_INI)) {
                    String ver = attrs.getValue(ATTR_VERSION);
                    if (ver == null || !ver.equals(CURRENT_VERSION)) {
                        throw new SAXException("Missing or invalid 'version' attribute");
                    }
                    handler.startIni();
                } else {
                    if (key == null) {
                        throw new SAXException("missing 'key' attribute");
                    }
                    if (qname.equals(TAG_SECTION)) {
                        handler.startSection(key);
                    } else if (qname.equals(TAG_OPTION)) {
                        handler.handleOption(key, attrs.getValue(ATTR_VALUE));
                    } else {
                        throw new SAXException(new StringBuffer().append("Invalid element: ").append(qname).toString());
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qname) throws SAXException {
                if (qname.equals(TAG_SECTION)) {
                    handler.endSection();
                } else if (qname.equals(TAG_INI)) {
                    handler.endIni();
                }
            }
        }
        XmlToIni xmlToini = new XmlToIni();
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(new InputSource(input), (DefaultHandler)xmlToini);
        }
        catch (Exception x) {
            throw new InvalidIniFormatException(x);
        }
    }

    public void parseXML(URL input, IniHandler handler) throws IOException, InvalidIniFormatException {
        this.parseXML(input.openStream(), handler);
    }

    private String parseSectionLine(String line, IniSource source, IniHandler handler) throws InvalidIniFormatException {
        String sectionName;
        if (line.charAt(line.length() - 1) != ']') {
            this.parseError(line, source.getLineNumber());
        }
        if ((sectionName = this.unescape(line.substring(1, line.length() - 1).trim())).length() == 0 && !this.getConfig().isUnnamedSection()) {
            this.parseError(line, source.getLineNumber());
        }
        if (this.getConfig().isLowerCaseSection()) {
            sectionName = sectionName.toLowerCase(Locale.getDefault());
        }
        handler.startSection(sectionName);
        return sectionName;
    }

    private void parse(IniSource source, IniHandler handler) throws IOException, InvalidIniFormatException {
        handler.startIni();
        String sectionName = null;
        String line = source.readLine();
        while (line != null) {
            if (line.charAt(0) == '[') {
                if (sectionName != null) {
                    handler.endSection();
                }
                sectionName = this.parseSectionLine(line, source, handler);
            } else {
                if (sectionName == null) {
                    if (this.getConfig().isGlobalSection()) {
                        sectionName = this.getConfig().getGlobalSectionName();
                        handler.startSection(sectionName);
                    } else {
                        this.parseError(line, source.getLineNumber());
                    }
                }
                this.parseOptionLine(line, handler, source.getLineNumber());
            }
            line = source.readLine();
        }
        if (sectionName != null) {
            handler.endSection();
        }
        handler.endIni();
    }
}

