/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.action;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.action.GenerationOptions;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.spi.entitymanagergenerator.ApplicationManagedResourceTransactionInJ2SE;
import org.netbeans.modules.j2ee.persistence.spi.entitymanagergenerator.EntityManagerGenerationStrategy;
import org.netbeans.modules.j2ee.persistence.spi.entitymanagergenerator.EntityManagerGenerationStrategyResolver;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityManagerGenerator {
    private final String fqn;
    private final JavaSource targetSource;
    private final FileObject targetFo;
    private final Project project;

    public EntityManagerGenerator(FileObject fileObject, String string) {
        this.fqn = string;
        this.targetFo = fileObject;
        this.targetSource = JavaSource.forFileObject((FileObject)fileObject);
        this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
    }

    public FileObject generate(GenerationOptions generationOptions) throws IOException {
        Class<? extends EntityManagerGenerationStrategy> clazz = this.getStrategy();
        if (clazz == null) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(EntityManagerGenerator.class, (String)"ERR_NotSupported"), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return this.targetFo;
        }
        return this.generate(generationOptions, clazz);
    }

    public FileObject generate(final GenerationOptions generationOptions, final Class<? extends EntityManagerGenerationStrategy> clazz) throws IOException {
        Parameters.notNull((CharSequence)"options", (Object)generationOptions);
        Parameters.notNull((CharSequence)"strategyClass", clazz);
        Task<WorkingCopy> task = new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                for (Tree tree : compilationUnitTree.getTypeDecls()) {
                    if (Tree.Kind.CLASS != tree.getKind()) continue;
                    ClassTree classTree = (ClassTree)tree;
                    EntityManagerGenerationStrategy entityManagerGenerationStrategy = EntityManagerGenerator.this.instantiateStrategy(clazz, workingCopy, treeMaker, classTree, generationOptions);
                    workingCopy.rewrite((Tree)classTree, (Tree)entityManagerGenerationStrategy.generate());
                }
            }
        };
        this.targetSource.runModificationTask((Task)task).commit();
        return this.targetFo;
    }

    private Class<? extends EntityManagerGenerationStrategy> getStrategy() {
        EntityManagerGenerationStrategyResolver entityManagerGenerationStrategyResolver = (EntityManagerGenerationStrategyResolver)this.project.getLookup().lookup(EntityManagerGenerationStrategyResolver.class);
        if (entityManagerGenerationStrategyResolver != null) {
            return entityManagerGenerationStrategyResolver.resolveStrategy(this.targetFo);
        }
        return ApplicationManagedResourceTransactionInJ2SE.class;
    }

    private EntityManagerGenerationStrategy instantiateStrategy(Class<? extends EntityManagerGenerationStrategy> clazz, WorkingCopy workingCopy, TreeMaker treeMaker, ClassTree classTree, GenerationOptions generationOptions) {
        EntityManagerGenerationStrategy entityManagerGenerationStrategy = null;
        try {
            entityManagerGenerationStrategy = clazz.newInstance();
            entityManagerGenerationStrategy.setClassTree(classTree);
            entityManagerGenerationStrategy.setWorkingCopy(workingCopy);
            entityManagerGenerationStrategy.setGenerationOptions(generationOptions);
            entityManagerGenerationStrategy.setTreeMaker(treeMaker);
            entityManagerGenerationStrategy.setPersistenceUnit(this.getPersistenceUnit());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        return entityManagerGenerationStrategy;
    }

    private PersistenceUnit getPersistenceUnit() {
        PersistenceScope persistenceScope = PersistenceScope.getPersistenceScope((FileObject)this.targetFo);
        if (persistenceScope == null) {
            return null;
        }
        try {
            Persistence persistence = PersistenceMetadata.getDefault().getRoot(persistenceScope.getPersistenceXml());
            if (persistence != null) {
                PersistenceUnit persistenceUnit;
                PersistenceUnit[] persistenceUnitArray = persistence.getPersistenceUnit();
                PersistenceUnit persistenceUnit2 = persistenceUnit = persistenceUnitArray.length > 0 ? persistenceUnitArray[0] : null;
                if (persistenceUnitArray.length > 1) {
                    PersistenceUnit persistenceUnit3 = null;
                    PersistenceUnit persistenceUnit4 = null;
                    block2: for (int i = 0; i < persistenceUnitArray.length && persistenceUnit4 == null; ++i) {
                        String[] stringArray;
                        PersistenceUnit persistenceUnit5 = persistenceUnitArray[i];
                        if (persistenceUnit3 == null && !persistenceUnit5.isExcludeUnlistedClasses()) {
                            persistenceUnit3 = persistenceUnit5;
                        }
                        if (!persistenceUnit5.isExcludeUnlistedClasses()) continue;
                        for (String string : stringArray = persistenceUnit5.getClass2()) {
                            if (!this.fqn.equals(string)) continue;
                            persistenceUnit4 = persistenceUnit5;
                            continue block2;
                        }
                    }
                    persistenceUnit = persistenceUnit4 != null ? persistenceUnit4 : (persistenceUnit3 != null ? persistenceUnit3 : persistenceUnit);
                }
                return persistenceUnit;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }
}

