/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.NativeLong;
import com.kenai.jaffl.ParameterFlags;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.byref.ByReference;
import com.kenai.jaffl.mapper.FromNativeContext;
import com.kenai.jaffl.mapper.FromNativeConverter;
import com.kenai.jaffl.mapper.MethodResultContext;
import com.kenai.jaffl.mapper.ToNativeContext;
import com.kenai.jaffl.mapper.ToNativeConverter;
import com.kenai.jaffl.mapper.TypeMapper;
import com.kenai.jaffl.provider.AbstractArrayMemoryIO;
import com.kenai.jaffl.provider.DelegatingMemoryIO;
import com.kenai.jaffl.provider.InvocationSession;
import com.kenai.jaffl.provider.Invoker;
import com.kenai.jaffl.provider.Library;
import com.kenai.jaffl.provider.StringIO;
import com.kenai.jaffl.provider.jffi.DirectMemoryIO;
import com.kenai.jaffl.provider.jffi.InvokerFactory;
import com.kenai.jaffl.provider.jffi.InvokerUtil;
import com.kenai.jaffl.provider.jffi.JFFIPointer;
import com.kenai.jaffl.struct.Struct;
import com.kenai.jaffl.struct.StructUtil;
import com.kenai.jaffl.util.EnumMapper;
import com.kenai.jffi.ArrayFlags;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.InvocationBuffer;
import com.kenai.jffi.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultInvokerFactory
implements InvokerFactory {
    DefaultInvokerFactory() {
    }

    public static final InvokerFactory getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public final boolean isMethodSupported(Method method2) {
        return true;
    }

    @Override
    public final Invoker createInvoker(Method method2, Library library2, Map<LibraryOption, ?> options2) {
        FromNativeConverter resultConverter;
        long address2 = ((com.kenai.jaffl.provider.jffi.Library)library2).findSymbolAddress(method2.getName());
        TypeMapper typeMapper = (TypeMapper)options2.get((Object)LibraryOption.TypeMapper);
        Marshaller[] marshallers = new Marshaller[method2.getParameterTypes().length];
        Type[] paramTypes = new Type[marshallers.length];
        for (int i = 0; i < marshallers.length; ++i) {
            marshallers[i] = DefaultInvokerFactory.getMarshaller(method2, i, typeMapper);
            paramTypes[i] = DefaultInvokerFactory.getNativeParameterType(method2, i, typeMapper);
        }
        Class<Object> returnType = method2.getReturnType();
        FromNativeConverter fromNativeConverter = resultConverter = typeMapper != null ? typeMapper.getFromNativeConverter(returnType) : null;
        if (resultConverter != null) {
            returnType = resultConverter.nativeType();
        }
        Function function = new Function(address2, DefaultInvokerFactory.getNativeReturnType(returnType), paramTypes, CallingConvention.DEFAULT, InvokerUtil.requiresErrno(method2));
        FunctionInvoker invoker = DefaultInvokerFactory.getFunctionInvoker(returnType);
        if (resultConverter != null) {
            MethodResultContext context = new MethodResultContext(method2);
            invoker = new ConvertingInvoker(resultConverter, context, invoker);
        }
        return DefaultInvokerFactory.isSessionRequired(marshallers) ? new SessionInvoker(function, invoker, marshallers) : new DefaultInvoker(function, invoker, marshallers);
    }

    private static final boolean isSessionRequired(Marshaller[] marshallers) {
        for (Marshaller m : marshallers) {
            if (!m.isSessionRequired()) continue;
            return true;
        }
        return false;
    }

    private static final FunctionInvoker getFunctionInvoker(Class returnType) {
        if (Void.class.isAssignableFrom(returnType) || Void.TYPE == returnType) {
            return VoidInvoker.INSTANCE;
        }
        if (Boolean.class.isAssignableFrom(returnType) || Boolean.TYPE == returnType) {
            return BooleanInvoker.INSTANCE;
        }
        if (Enum.class.isAssignableFrom(returnType)) {
            return new EnumInvoker(returnType);
        }
        if (Byte.class.isAssignableFrom(returnType) || Byte.TYPE == returnType) {
            return Int8Invoker.INSTANCE;
        }
        if (Short.class.isAssignableFrom(returnType) || Short.TYPE == returnType) {
            return Int16Invoker.INSTANCE;
        }
        if (Integer.class.isAssignableFrom(returnType) || Integer.TYPE == returnType) {
            return Int32Invoker.INSTANCE;
        }
        if (Long.class.isAssignableFrom(returnType) || Long.TYPE == returnType) {
            return Int64Invoker.INSTANCE;
        }
        if (NativeLong.class.isAssignableFrom(returnType)) {
            return Platform.getPlatform().longSize() == 32 ? NativeLong32Invoker.INSTANCE : NativeLong64Invoker.INSTANCE;
        }
        if (Float.class.isAssignableFrom(returnType) || Float.TYPE == returnType) {
            return Float32Invoker.INSTANCE;
        }
        if (Double.class.isAssignableFrom(returnType) || Double.TYPE == returnType) {
            return Float64Invoker.INSTANCE;
        }
        if (Pointer.class.isAssignableFrom(returnType)) {
            return PointerInvoker.INSTANCE;
        }
        if (Struct.class.isAssignableFrom(returnType)) {
            return new StructInvoker(returnType);
        }
        if (String.class.isAssignableFrom(returnType)) {
            return StringInvoker.INSTANCE;
        }
        throw new IllegalArgumentException("Unknown return type: " + returnType);
    }

    private static final Type getNativeReturnType(Class type2) {
        if (Void.class.isAssignableFrom(type2) || Void.TYPE == type2) {
            return Type.VOID;
        }
        if (Boolean.class.isAssignableFrom(type2) || Boolean.TYPE == type2) {
            return Type.SINT32;
        }
        if (Byte.class.isAssignableFrom(type2) || Byte.TYPE == type2) {
            return Type.SINT8;
        }
        if (Short.class.isAssignableFrom(type2) || Short.TYPE == type2) {
            return Type.SINT16;
        }
        if (Integer.class.isAssignableFrom(type2) || Integer.TYPE == type2) {
            return Type.SINT32;
        }
        if (Long.class.isAssignableFrom(type2) || Long.TYPE == type2) {
            return Type.SINT64;
        }
        if (NativeLong.class.isAssignableFrom(type2)) {
            return Platform.getPlatform().longSize() == 32 ? Type.SINT32 : Type.SINT64;
        }
        if (Float.class.isAssignableFrom(type2) || Float.TYPE == type2) {
            return Type.FLOAT;
        }
        if (Double.class.isAssignableFrom(type2) || Double.TYPE == type2) {
            return Type.DOUBLE;
        }
        if (Enum.class.isAssignableFrom(type2)) {
            return Type.SINT32;
        }
        if (Pointer.class.isAssignableFrom(type2)) {
            return Type.POINTER;
        }
        if (Struct.class.isAssignableFrom(type2)) {
            return Type.POINTER;
        }
        if (String.class.isAssignableFrom(type2)) {
            return Type.POINTER;
        }
        throw new IllegalArgumentException("Unsupported return type: " + type2);
    }

    private static final Type getNativeParameterType(Method method2, int paramIndex, TypeMapper mapper) {
        Class<?> type2 = method2.getParameterTypes()[paramIndex];
        ToNativeConverter converter = mapper != null ? mapper.getToNativeConverter(type2) : null;
        return DefaultInvokerFactory.getNativeParameterType(converter != null ? converter.nativeType() : type2);
    }

    private static final Type getNativeParameterType(Class type2) {
        if (Byte.class.isAssignableFrom(type2) || Byte.TYPE == type2) {
            return Type.SINT8;
        }
        if (Short.class.isAssignableFrom(type2) || Short.TYPE == type2) {
            return Type.SINT16;
        }
        if (Integer.class.isAssignableFrom(type2) || Integer.TYPE == type2) {
            return Type.SINT32;
        }
        if (Long.class.isAssignableFrom(type2) || Long.TYPE == type2) {
            return Type.SINT64;
        }
        if (NativeLong.class.isAssignableFrom(type2)) {
            return Platform.getPlatform().longSize() == 32 ? Type.SINT32 : Type.SINT64;
        }
        if (Float.class.isAssignableFrom(type2) || Float.TYPE == type2) {
            return Type.FLOAT;
        }
        if (Double.class.isAssignableFrom(type2) || Double.TYPE == type2) {
            return Type.DOUBLE;
        }
        if (Boolean.class.isAssignableFrom(type2) || Boolean.TYPE == type2) {
            return Type.SINT32;
        }
        if (Enum.class.isAssignableFrom(type2)) {
            return Type.SINT32;
        }
        if (Pointer.class.isAssignableFrom(type2)) {
            return Type.POINTER;
        }
        if (Struct.class.isAssignableFrom(type2) || type2.isArray() && Struct.class.isAssignableFrom(type2.getComponentType())) {
            return Type.POINTER;
        }
        if (Buffer.class.isAssignableFrom(type2)) {
            return Type.POINTER;
        }
        if (CharSequence.class.isAssignableFrom(type2)) {
            return Type.POINTER;
        }
        if (ByReference.class.isAssignableFrom(type2)) {
            return Type.POINTER;
        }
        if (type2.isArray()) {
            return Type.POINTER;
        }
        throw new IllegalArgumentException("Unsupported parameter type: " + type2);
    }

    static final int getParameterFlags(Method method2, int paramIndex) {
        return DefaultInvokerFactory.getParameterFlags(method2.getParameterAnnotations()[paramIndex]);
    }

    static final int getParameterFlags(Annotation[] annotations2) {
        return ParameterFlags.parse(annotations2);
    }

    static final int getNativeArrayFlags(int flags) {
        int nflags = 0;
        nflags |= ParameterFlags.isIn(flags) ? 1 : 0;
        nflags |= ParameterFlags.isOut(flags) ? 2 : 0;
        return nflags |= ParameterFlags.isNulTerminate(flags) ? 4 : 0;
    }

    private static final Marshaller getMarshaller(Method method2, int paramIndex, TypeMapper mapper) {
        ToNativeConverter converter;
        Class<?> type2 = method2.getParameterTypes()[paramIndex];
        ToNativeConverter toNativeConverter = converter = mapper != null ? mapper.getToNativeConverter(type2) : null;
        if (converter != null) {
            return new ToNativeConverterMarshaller(converter, DefaultInvokerFactory.getMarshaller(converter.nativeType(), method2.getParameterAnnotations()[paramIndex]));
        }
        return DefaultInvokerFactory.getMarshaller(method2, paramIndex);
    }

    private static final Marshaller getMarshaller(Method method2, int paramIndex) {
        return DefaultInvokerFactory.getMarshaller(method2.getParameterTypes()[paramIndex], method2.getParameterAnnotations()[paramIndex]);
    }

    private static final Marshaller getMarshaller(Class type2, Annotation[] annotations2) {
        if (Byte.class.isAssignableFrom(type2) || Byte.TYPE == type2) {
            return Int8Marshaller.INSTANCE;
        }
        if (Short.class.isAssignableFrom(type2) || Short.TYPE == type2) {
            return Int16Marshaller.INSTANCE;
        }
        if (Integer.class.isAssignableFrom(type2) || Integer.TYPE == type2) {
            return Int32Marshaller.INSTANCE;
        }
        if (Long.class.isAssignableFrom(type2) || Long.TYPE == type2) {
            return Int64Marshaller.INSTANCE;
        }
        if (NativeLong.class.isAssignableFrom(type2)) {
            return Platform.getPlatform().longSize() == 32 ? Int32Marshaller.INSTANCE : Int64Marshaller.INSTANCE;
        }
        if (Float.class.isAssignableFrom(type2) || Float.TYPE == type2) {
            return Float32Marshaller.INSTANCE;
        }
        if (Double.class.isAssignableFrom(type2) || Double.TYPE == type2) {
            return Float64Marshaller.INSTANCE;
        }
        if (Boolean.class.isAssignableFrom(type2) || Boolean.TYPE == type2) {
            return BooleanMarshaller.INSTANCE;
        }
        if (Enum.class.isAssignableFrom(type2)) {
            return EnumMarshaller.INSTANCE;
        }
        if (Pointer.class.isAssignableFrom(type2)) {
            return PointerMarshaller.INSTANCE;
        }
        if (StringBuffer.class.isAssignableFrom(type2)) {
            return new StringBuilderMarshaller(DefaultInvokerFactory.getParameterFlags(annotations2));
        }
        if (StringBuilder.class.isAssignableFrom(type2)) {
            return new StringBuilderMarshaller(DefaultInvokerFactory.getParameterFlags(annotations2));
        }
        if (CharSequence.class.isAssignableFrom(type2)) {
            return CharSequenceMarshaller.INSTANCE;
        }
        if (ByReference.class.isAssignableFrom(type2)) {
            return new ByReferenceMarshaller(DefaultInvokerFactory.getParameterFlags(annotations2));
        }
        if (Struct.class.isAssignableFrom(type2)) {
            return new StructMarshaller(DefaultInvokerFactory.getParameterFlags(annotations2));
        }
        if (ByteBuffer.class.isAssignableFrom(type2)) {
            return new ByteBufferMarshaller(DefaultInvokerFactory.getParameterFlags(annotations2));
        }
        if (ShortBuffer.class.isAssignableFrom(type2)) {
            return new ShortBufferMarshaller(DefaultInvokerFactory.getParameterFlags(annotations2));
        }
        if (IntBuffer.class.isAssignableFrom(type2)) {
            return new IntBufferMarshaller(DefaultInvokerFactory.getParameterFlags(annotations2));
        }
        if (LongBuffer.class.isAssignableFrom(type2)) {
            return new LongBufferMarshaller(DefaultInvokerFactory.getParameterFlags(annotations2));
        }
        if (FloatBuffer.class.isAssignableFrom(type2)) {
            return new FloatBufferMarshaller(DefaultInvokerFactory.getParameterFlags(annotations2));
        }
        if (DoubleBuffer.class.isAssignableFrom(type2)) {
            return new DoubleBufferMarshaller(DefaultInvokerFactory.getParameterFlags(annotations2));
        }
        if (type2.isArray() && type2.getComponentType() == Byte.TYPE) {
            return new ByteArrayMarshaller(DefaultInvokerFactory.getParameterFlags(annotations2));
        }
        if (type2.isArray() && type2.getComponentType() == Short.TYPE) {
            return new ShortArrayMarshaller(DefaultInvokerFactory.getParameterFlags(annotations2));
        }
        if (type2.isArray() && type2.getComponentType() == Integer.TYPE) {
            return new IntArrayMarshaller(DefaultInvokerFactory.getParameterFlags(annotations2));
        }
        if (type2.isArray() && type2.getComponentType() == Long.TYPE) {
            return new LongArrayMarshaller(DefaultInvokerFactory.getParameterFlags(annotations2));
        }
        if (type2.isArray() && type2.getComponentType() == Float.TYPE) {
            return new FloatArrayMarshaller(DefaultInvokerFactory.getParameterFlags(annotations2));
        }
        if (type2.isArray() && type2.getComponentType() == Double.TYPE) {
            return new DoubleArrayMarshaller(DefaultInvokerFactory.getParameterFlags(annotations2));
        }
        if (type2.isArray() && Struct.class.isAssignableFrom(type2.getComponentType())) {
            return new StructArrayMarshaller(DefaultInvokerFactory.getParameterFlags(annotations2));
        }
        throw new IllegalArgumentException("Unsupported parameter type: " + type2);
    }

    static final class ToNativeConverterMarshaller
    extends BaseMarshaller {
        private final ToNativeConverter converter;
        private final ToNativeContext context = null;
        private final Marshaller marshaller;

        public ToNativeConverterMarshaller(ToNativeConverter converter, Marshaller marshaller) {
            this.converter = converter;
            this.marshaller = marshaller;
        }

        public void marshal(InvocationBuffer buffer, Object parameter) {
            this.marshaller.marshal(buffer, this.converter.toNative(parameter, this.context));
        }

        public boolean isSessionRequired() {
            return this.marshaller.isSessionRequired();
        }

        public void marshal(InvocationSession session, InvocationBuffer buffer, Object parameter) {
            this.marshaller.marshal(session, buffer, this.converter.toNative(parameter, this.context));
        }
    }

    static final class StructArrayMarshaller
    extends BaseMarshaller {
        private final int nflags;
        private final int flags;

        public StructArrayMarshaller(int flags) {
            this.flags = flags;
            this.nflags = DefaultInvokerFactory.getNativeArrayFlags(flags);
        }

        public final void marshal(InvocationBuffer buffer, Object parameter) {
            if (parameter == null) {
                buffer.putAddress(0L);
            } else {
                Struct[] array = (Struct[])Struct[].class.cast(parameter);
                MemoryIO io2 = StructUtil.getMemoryIO(array[0], this.flags);
                if (!(io2 instanceof DelegatingMemoryIO)) {
                    throw new RuntimeException("Struct array must be backed by contiguous array");
                }
                if ((io2 = ((DelegatingMemoryIO)((Object)io2)).getDelegatedMemoryIO()) instanceof AbstractArrayMemoryIO) {
                    AbstractArrayMemoryIO aio = (AbstractArrayMemoryIO)io2;
                    buffer.putArray(aio.array(), aio.offset(), aio.length(), this.nflags);
                } else if (io2.isDirect()) {
                    buffer.putAddress(io2.getAddress());
                }
            }
        }
    }

    static final class StructMarshaller
    extends BaseMarshaller {
        private final int nflags;
        private final int flags;

        public StructMarshaller(int flags) {
            this.flags = flags;
            this.nflags = DefaultInvokerFactory.getNativeArrayFlags(flags);
        }

        public final void marshal(InvocationBuffer buffer, Object parameter) {
            if (parameter == null) {
                buffer.putAddress(0L);
            } else {
                Struct s = (Struct)parameter;
                MemoryIO io2 = StructUtil.getMemoryIO(s, this.flags);
                if (io2 instanceof AbstractArrayMemoryIO) {
                    AbstractArrayMemoryIO aio = (AbstractArrayMemoryIO)io2;
                    buffer.putArray(aio.array(), aio.offset(), aio.length(), this.nflags);
                } else if (io2.isDirect()) {
                    buffer.putAddress(io2.getAddress());
                }
            }
        }
    }

    static final class ByReferenceMarshaller
    extends BaseMarshaller {
        private final int flags;

        public ByReferenceMarshaller(int flags) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(flags);
        }

        public final boolean isSessionRequired() {
            return true;
        }

        public final void marshal(InvocationSession session, InvocationBuffer buffer, Object parameter) {
            if (parameter == null) {
                buffer.putAddress(0L);
            } else {
                final ByReference ref = (ByReference)parameter;
                final ByteBuffer buf = ByteBuffer.allocate(ref.nativeSize()).order(ByteOrder.nativeOrder());
                buf.clear();
                if (ArrayFlags.isIn(this.flags)) {
                    ref.marshal(buf);
                }
                buffer.putArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), this.flags);
                if (ArrayFlags.isOut(this.flags)) {
                    session.addPostInvoke(new InvocationSession.PostInvoke(){

                        public void postInvoke() {
                            ref.unmarshal(buf);
                        }
                    });
                }
            }
        }

        public void marshal(InvocationBuffer buffer, Object parameter) {
            throw new UnsupportedOperationException("Cannot marshal ByReference without session");
        }
    }

    static final class DoubleBufferMarshaller
    extends BaseMarshaller {
        private final int flags;

        public DoubleBufferMarshaller(int flags) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(flags);
        }

        public final void marshal(InvocationBuffer buffer, Object parameter) {
            DoubleBuffer buf = (DoubleBuffer)parameter;
            if (parameter == null) {
                buffer.putAddress(0L);
            } else if (buf.hasArray()) {
                buffer.putArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), this.flags);
            } else {
                buffer.putDirectBuffer(buf, buf.position() << 3, buf.remaining() << 3);
            }
        }
    }

    static final class FloatBufferMarshaller
    extends BaseMarshaller {
        private final int flags;

        public FloatBufferMarshaller(int flags) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(flags);
        }

        public final void marshal(InvocationBuffer buffer, Object parameter) {
            FloatBuffer buf = (FloatBuffer)parameter;
            if (parameter == null) {
                buffer.putAddress(0L);
            } else if (buf.hasArray()) {
                buffer.putArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), this.flags);
            } else {
                buffer.putDirectBuffer(buf, buf.position() << 2, buf.remaining() << 2);
            }
        }
    }

    static final class LongBufferMarshaller
    extends BaseMarshaller {
        private final int flags;

        public LongBufferMarshaller(int flags) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(flags);
        }

        public final void marshal(InvocationBuffer buffer, Object parameter) {
            LongBuffer buf = (LongBuffer)parameter;
            if (parameter == null) {
                buffer.putAddress(0L);
            } else if (buf.hasArray()) {
                buffer.putArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), this.flags);
            } else {
                buffer.putDirectBuffer(buf, buf.position() << 3, buf.remaining() << 3);
            }
        }
    }

    static final class IntBufferMarshaller
    extends BaseMarshaller {
        private final int flags;

        public IntBufferMarshaller(int flags) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(flags);
        }

        public final void marshal(InvocationBuffer buffer, Object parameter) {
            IntBuffer buf = (IntBuffer)parameter;
            if (parameter == null) {
                buffer.putAddress(0L);
            } else if (buf.hasArray()) {
                buffer.putArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), this.flags);
            } else {
                buffer.putDirectBuffer(buf, buf.position() << 2, buf.remaining() << 2);
            }
        }
    }

    static final class ShortBufferMarshaller
    extends BaseMarshaller {
        private final int flags;

        public ShortBufferMarshaller(int flags) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(flags);
        }

        public final void marshal(InvocationBuffer buffer, Object parameter) {
            ShortBuffer buf = (ShortBuffer)parameter;
            if (parameter == null) {
                buffer.putAddress(0L);
            } else if (buf.hasArray()) {
                buffer.putArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), this.flags);
            } else {
                buffer.putDirectBuffer(buf, buf.position() << 1, buf.remaining() << 1);
            }
        }
    }

    static final class ByteBufferMarshaller
    extends BaseMarshaller {
        private final int flags;

        public ByteBufferMarshaller(int flags) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(flags | (ParameterFlags.isIn(flags) ? 8 : 0));
        }

        public final void marshal(InvocationBuffer buffer, Object parameter) {
            ByteBuffer buf = (ByteBuffer)parameter;
            if (parameter == null) {
                buffer.putAddress(0L);
            } else if (buf.hasArray()) {
                buffer.putArray(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), this.flags);
            } else {
                buffer.putDirectBuffer(buf, buf.position(), buf.remaining());
            }
        }
    }

    static final class DoubleArrayMarshaller
    extends BaseMarshaller {
        private final int flags;

        public DoubleArrayMarshaller(int flags) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(flags);
        }

        public final void marshal(InvocationBuffer buffer, Object parameter) {
            if (parameter == null) {
                buffer.putAddress(0L);
            } else {
                double[] array = (double[])double[].class.cast(parameter);
                buffer.putArray(array, 0, array.length, this.flags);
            }
        }
    }

    static final class FloatArrayMarshaller
    extends BaseMarshaller {
        private final int flags;

        public FloatArrayMarshaller(int flags) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(flags);
        }

        public final void marshal(InvocationBuffer buffer, Object parameter) {
            if (parameter == null) {
                buffer.putAddress(0L);
            } else {
                float[] array = (float[])float[].class.cast(parameter);
                buffer.putArray(array, 0, array.length, this.flags);
            }
        }
    }

    static final class LongArrayMarshaller
    extends BaseMarshaller {
        private final int flags;

        public LongArrayMarshaller(int flags) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(flags);
        }

        public final void marshal(InvocationBuffer buffer, Object parameter) {
            if (parameter == null) {
                buffer.putAddress(0L);
            } else {
                long[] array = (long[])long[].class.cast(parameter);
                buffer.putArray(array, 0, array.length, this.flags);
            }
        }
    }

    static final class IntArrayMarshaller
    extends BaseMarshaller {
        private final int flags;

        public IntArrayMarshaller(int flags) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(flags);
        }

        public final void marshal(InvocationBuffer buffer, Object parameter) {
            if (parameter == null) {
                buffer.putAddress(0L);
            } else {
                int[] array = (int[])int[].class.cast(parameter);
                buffer.putArray(array, 0, array.length, this.flags);
            }
        }
    }

    static final class ShortArrayMarshaller
    extends BaseMarshaller {
        private final int flags;

        public ShortArrayMarshaller(int flags) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(flags);
        }

        public final void marshal(InvocationBuffer buffer, Object parameter) {
            if (parameter == null) {
                buffer.putAddress(0L);
            } else {
                short[] array = (short[])short[].class.cast(parameter);
                buffer.putArray(array, 0, array.length, this.flags);
            }
        }
    }

    static final class ByteArrayMarshaller
    extends BaseMarshaller {
        private final int flags;

        public ByteArrayMarshaller(int flags) {
            this.flags = DefaultInvokerFactory.getNativeArrayFlags(flags | (ParameterFlags.isIn(flags) ? 8 : 0));
        }

        public final void marshal(InvocationBuffer buffer, Object parameter) {
            if (parameter == null) {
                buffer.putAddress(0L);
            } else {
                byte[] array = (byte[])byte[].class.cast(parameter);
                buffer.putArray(array, 0, array.length, this.flags);
            }
        }
    }

    static final class StringBuilderMarshaller
    extends BaseMarshaller {
        private final int nflags;
        private final int inout;

        public StringBuilderMarshaller(int inout) {
            this.inout = inout;
            this.nflags = DefaultInvokerFactory.getNativeArrayFlags(inout | (ParameterFlags.isIn(inout) ? 8 : 0));
        }

        public final boolean isSessionRequired() {
            return true;
        }

        public void marshal(InvocationBuffer buffer, Object parameter) {
            throw new UnsupportedOperationException("Cannot marshal StringBuilder without session");
        }

        public void marshal(InvocationSession session, InvocationBuffer buffer, Object parameter) {
            if (parameter == null) {
                buffer.putAddress(0L);
            } else if (parameter instanceof StringBuilder) {
                final StringBuilder sb = (StringBuilder)parameter;
                final StringIO io2 = StringIO.getStringIO();
                final ByteBuffer buf = io2.toNative(sb, sb.capacity(), ParameterFlags.isIn(this.inout));
                buffer.putArray(buf.array(), buf.arrayOffset(), buf.remaining(), this.nflags);
                if (ParameterFlags.isOut(this.inout)) {
                    session.addPostInvoke(new InvocationSession.PostInvoke(){

                        public void postInvoke() {
                            sb.delete(0, sb.length()).append(io2.fromNative(buf, sb.capacity()));
                        }
                    });
                }
            } else if (parameter instanceof StringBuffer) {
                final StringBuffer sb = (StringBuffer)parameter;
                final StringIO io3 = StringIO.getStringIO();
                final ByteBuffer buf = io3.toNative(sb, sb.capacity(), ParameterFlags.isIn(this.inout));
                buffer.putArray(buf.array(), buf.arrayOffset(), buf.limit(), this.nflags);
                if (ParameterFlags.isOut(this.inout)) {
                    session.addPostInvoke(new InvocationSession.PostInvoke(){

                        public void postInvoke() {
                            sb.delete(0, sb.length()).append(io3.fromNative(buf, sb.capacity()));
                        }
                    });
                }
            }
        }
    }

    static final class CharSequenceMarshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new CharSequenceMarshaller();
        static final int FLAGS = 5;

        CharSequenceMarshaller() {
        }

        public void marshal(InvocationBuffer buffer, Object parameter) {
            if (parameter == null) {
                buffer.putAddress(0L);
            } else {
                CharSequence cs = (CharSequence)parameter;
                ByteBuffer buf = StringIO.getStringIO().toNative(cs, cs.length(), true);
                buffer.putArray(buf.array(), buf.arrayOffset(), buf.remaining(), 5);
            }
        }
    }

    static final class PointerMarshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new PointerMarshaller();

        PointerMarshaller() {
        }

        public void marshal(InvocationBuffer buffer, Object parameter) {
            buffer.putAddress(((JFFIPointer)parameter).address);
        }
    }

    static final class Float64Marshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new Float64Marshaller();

        Float64Marshaller() {
        }

        public void marshal(InvocationBuffer buffer, Object parameter) {
            buffer.putDouble(((Number)parameter).doubleValue());
        }
    }

    static final class Float32Marshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new Float32Marshaller();

        Float32Marshaller() {
        }

        public void marshal(InvocationBuffer buffer, Object parameter) {
            buffer.putFloat(((Number)parameter).floatValue());
        }
    }

    static final class Int64Marshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new Int64Marshaller();

        Int64Marshaller() {
        }

        public void marshal(InvocationBuffer buffer, Object parameter) {
            buffer.putLong(((Number)parameter).longValue());
        }
    }

    static final class Int32Marshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new Int32Marshaller();

        Int32Marshaller() {
        }

        public void marshal(InvocationBuffer buffer, Object parameter) {
            buffer.putInt(((Number)parameter).intValue());
        }
    }

    static final class Int16Marshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new Int16Marshaller();

        Int16Marshaller() {
        }

        public void marshal(InvocationBuffer buffer, Object parameter) {
            buffer.putShort(((Number)parameter).intValue());
        }
    }

    static final class Int8Marshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new Int8Marshaller();

        Int8Marshaller() {
        }

        public void marshal(InvocationBuffer buffer, Object parameter) {
            buffer.putByte(((Number)parameter).intValue());
        }
    }

    static final class EnumMarshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new EnumMarshaller();

        EnumMarshaller() {
        }

        public void marshal(InvocationBuffer buffer, Object parameter) {
            buffer.putInt(EnumMapper.getInstance().intValue((Enum)parameter));
        }
    }

    static final class BooleanMarshaller
    extends BaseMarshaller {
        static final Marshaller INSTANCE = new BooleanMarshaller();

        BooleanMarshaller() {
        }

        public void marshal(InvocationBuffer buffer, Object parameter) {
            buffer.putInt((Boolean)parameter != false ? 1 : 0);
        }
    }

    static final class StringInvoker
    extends BaseInvoker {
        com.kenai.jffi.MemoryIO IO = com.kenai.jffi.MemoryIO.getInstance();
        static final FunctionInvoker INSTANCE = new StringInvoker();

        StringInvoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer buffer) {
            long ptr = invoker.invokeAddress(function, buffer);
            if (ptr == 0L) {
                return null;
            }
            ByteBuffer buf = ByteBuffer.wrap(this.IO.getZeroTerminatedByteArray(ptr));
            return ((Object)StringIO.getStringIO().fromNative(buf)).toString();
        }
    }

    static final class StructInvoker
    extends BaseInvoker {
        private final Class structClass;

        public StructInvoker(Class structClass) {
            this.structClass = structClass;
        }

        public final Object invoke(Function function, HeapInvocationBuffer buffer) {
            long ptr = invoker.invokeAddress(function, buffer);
            if (ptr == 0L) {
                return null;
            }
            try {
                Struct s = (Struct)this.structClass.newInstance();
                s.useMemory(new DirectMemoryIO(ptr));
                return s;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    static final class PointerInvoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new PointerInvoker();

        PointerInvoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer buffer) {
            long ptr = invoker.invokeAddress(function, buffer);
            return ptr != 0L ? new JFFIPointer(ptr) : null;
        }
    }

    static final class Float64Invoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new Float64Invoker();

        Float64Invoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer buffer) {
            return invoker.invokeDouble(function, buffer);
        }
    }

    static final class Float32Invoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new Float32Invoker();

        Float32Invoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer buffer) {
            return Float.valueOf(invoker.invokeFloat(function, buffer));
        }
    }

    static final class NativeLong64Invoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new NativeLong64Invoker();

        NativeLong64Invoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer buffer) {
            return NativeLong.valueOf(invoker.invokeLong(function, buffer));
        }
    }

    static final class NativeLong32Invoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new NativeLong32Invoker();

        NativeLong32Invoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer buffer) {
            return NativeLong.valueOf(invoker.invokeInt(function, buffer));
        }
    }

    static final class Int64Invoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new Int64Invoker();

        Int64Invoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer buffer) {
            return invoker.invokeLong(function, buffer);
        }
    }

    static final class Int32Invoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new Int32Invoker();

        Int32Invoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer buffer) {
            return invoker.invokeInt(function, buffer);
        }
    }

    static final class Int16Invoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new Int16Invoker();

        Int16Invoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer buffer) {
            return (short)invoker.invokeInt(function, buffer);
        }
    }

    static final class Int8Invoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new Int8Invoker();

        Int8Invoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer buffer) {
            return (byte)invoker.invokeInt(function, buffer);
        }
    }

    static final class EnumInvoker
    extends BaseInvoker {
        private final Class enumClass;

        private EnumInvoker(Class enumClass) {
            this.enumClass = enumClass;
        }

        public final Object invoke(Function function, HeapInvocationBuffer buffer) {
            return EnumMapper.getInstance().valueOf(invoker.invokeInt(function, buffer), this.enumClass);
        }
    }

    static final class BooleanInvoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new BooleanInvoker();

        BooleanInvoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer buffer) {
            return invoker.invokeInt(function, buffer) != 0;
        }
    }

    static final class VoidInvoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new VoidInvoker();

        VoidInvoker() {
        }

        public final Object invoke(Function function, HeapInvocationBuffer buffer) {
            invoker.invokeInt(function, buffer);
            return null;
        }
    }

    static final class ConvertingInvoker
    extends BaseInvoker {
        private final FromNativeConverter converter;
        private final FromNativeContext context;
        private final FunctionInvoker nativeInvoker;

        public ConvertingInvoker(FromNativeConverter converter, FromNativeContext context, FunctionInvoker nativeInvoker) {
            this.converter = converter;
            this.context = context;
            this.nativeInvoker = nativeInvoker;
        }

        public final Object invoke(Function function, HeapInvocationBuffer buffer) {
            return this.converter.fromNative(this.nativeInvoker.invoke(function, buffer), this.context);
        }
    }

    static abstract class BaseInvoker
    implements FunctionInvoker {
        static final com.kenai.jffi.Invoker invoker = com.kenai.jffi.Invoker.getInstance();

        BaseInvoker() {
        }
    }

    static abstract class BaseMarshaller
    implements Marshaller {
        BaseMarshaller() {
        }

        public boolean isSessionRequired() {
            return false;
        }

        public void marshal(InvocationSession session, InvocationBuffer buffer, Object parameter) {
            this.marshal(buffer, parameter);
        }
    }

    static interface FunctionInvoker {
        public Object invoke(Function var1, HeapInvocationBuffer var2);
    }

    static interface Marshaller {
        public boolean isSessionRequired();

        public void marshal(InvocationSession var1, InvocationBuffer var2, Object var3);

        public void marshal(InvocationBuffer var1, Object var2);
    }

    static final class DefaultInvoker
    implements Invoker {
        final Function function;
        final FunctionInvoker functionInvoker;
        final Marshaller[] marshallers;

        DefaultInvoker(Function function, FunctionInvoker invoker, Marshaller[] marshallers) {
            this.function = function;
            this.functionInvoker = invoker;
            this.marshallers = marshallers;
        }

        final HeapInvocationBuffer marshal(Object[] parameters) {
            HeapInvocationBuffer buffer = new HeapInvocationBuffer(this.function);
            for (int i = 0; i < parameters.length; ++i) {
                this.marshallers[i].marshal(buffer, parameters[i]);
            }
            return buffer;
        }

        public final Object invoke(Object[] parameters) {
            return this.functionInvoker.invoke(this.function, this.marshal(parameters));
        }
    }

    static final class SessionInvoker
    implements Invoker {
        static final com.kenai.jffi.Invoker invoker = com.kenai.jffi.Invoker.getInstance();
        final Function function;
        final FunctionInvoker functionInvoker;
        final Marshaller[] marshallers;

        SessionInvoker(Function function, FunctionInvoker invoker, Marshaller[] marshallers) {
            this.function = function;
            this.functionInvoker = invoker;
            this.marshallers = marshallers;
        }

        final HeapInvocationBuffer marshal(InvocationSession session, Object[] parameters) {
            HeapInvocationBuffer buffer = new HeapInvocationBuffer(this.function);
            for (int i = 0; i < parameters.length; ++i) {
                this.marshallers[i].marshal(session, buffer, parameters[i]);
            }
            return buffer;
        }

        public final Object invoke(Object[] parameters) {
            InvocationSession session = new InvocationSession();
            Object retVal = this.functionInvoker.invoke(this.function, this.marshal(session, parameters));
            session.finish();
            return retVal;
        }
    }

    private static final class SingletonHolder {
        static InvokerFactory INSTANCE = new DefaultInvokerFactory();

        private SingletonHolder() {
        }
    }
}

