/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Library {
    private static final Map<String, WeakReference<Library>> cache = new ConcurrentHashMap<String, WeakReference<Library>>();
    private static final Object lock = new Object();
    private static final ThreadLocal<String> lastError = new ThreadLocal();
    public static final int LAZY = 1;
    public static final int NOW = 2;
    public static final int LOCAL = 4;
    public static final int GLOBAL = 8;
    private final long handle;
    private final String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long dlopen(String name2, int flags) {
        Foreign foreign = Foreign.getInstance();
        Object object = lock;
        synchronized (object) {
            long address2 = foreign.dlopen(name2, flags);
            if (address2 == 0L) {
                lastError.set(foreign.dlerror());
            }
            return address2;
        }
    }

    public static final Library getDefault() {
        return DefaultLibrary.INSTANCE;
    }

    public static final Library getCachedInstance(String name2, int flags) {
        Library lib;
        if (name2 == null) {
            return Library.getDefault();
        }
        WeakReference<Library> ref = cache.get(name2);
        Library library2 = lib = ref != null ? (Library)ref.get() : null;
        if (lib != null) {
            return lib;
        }
        lib = Library.openLibrary(name2, flags);
        if (lib == null) {
            return null;
        }
        cache.put(name2, new WeakReference<Library>(lib));
        return lib;
    }

    public static final Library openLibrary(String name2, int flags) {
        long address2;
        if (flags == 0) {
            flags = 1;
        }
        return (address2 = Library.dlopen(name2, flags)) != 0L ? new Library(name2, address2) : null;
    }

    private Library(String name2, long address2) {
        this.name = name2;
        this.handle = address2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getSymbolAddress(String name2) {
        Foreign foreign = Foreign.getInstance();
        Object object = lock;
        synchronized (object) {
            long address2 = foreign.dlsym(this.handle, name2);
            if (address2 == 0L) {
                lastError.set(foreign.dlerror());
            }
            return address2;
        }
    }

    public static final String getLastError() {
        String error2 = lastError.get();
        return error2 != null ? error2 : "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.handle != 0L) {
                Foreign.getInstance().dlclose(this.handle);
            }
        }
        finally {
            super.finalize();
        }
    }

    static /* synthetic */ long access$000(String x0, int x1) {
        return Library.dlopen(x0, x1);
    }

    private static final class DefaultLibrary {
        private static final Library INSTANCE = new Library(null, Library.access$000(null, 1));

        private DefaultLibrary() {
        }
    }
}

