/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyFile;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JRubyFile;

@JRubyModule(name={"FileTest"})
public class RubyFileTest {
    public static RubyModule createFileTestModule(Ruby runtime2) {
        RubyModule fileTestModule = runtime2.defineModule("FileTest");
        runtime2.setFileTest(fileTestModule);
        fileTestModule.defineAnnotatedMethods(RubyFileTest.class);
        return fileTestModule;
    }

    @JRubyMethod(name={"blockdev?"}, required=1, module=true)
    public static IRubyObject blockdev_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFileTest.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isBlockDev());
    }

    @JRubyMethod(name={"chardev?"}, required=1, module=true)
    public static IRubyObject chardev_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFileTest.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isCharDev());
    }

    @JRubyMethod(name={"directory?"}, required=1, module=true)
    public static IRubyObject directory_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.directory_p(recv2.getRuntime(), filename2);
    }

    public static IRubyObject directory_p(Ruby runtime2, IRubyObject filename2) {
        ZipEntry entry = RubyFileTest.file_in_archive(filename2);
        if (entry != null) {
            return entry.isDirectory() ? runtime2.getTrue() : runtime2.getFalse();
        }
        JRubyFile file2 = RubyFileTest.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isDirectory());
    }

    @JRubyMethod(name={"executable?"}, required=1, module=true)
    public static IRubyObject executable_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFileTest.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isExecutable());
    }

    @JRubyMethod(name={"executable_real?"}, required=1, module=true)
    public static IRubyObject executable_real_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFileTest.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isExecutableReal());
    }

    @JRubyMethod(name={"exist?", "exists?"}, required=1, module=true)
    public static IRubyObject exist_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        if (Ruby.isSecurityRestricted()) {
            return runtime2.getFalse();
        }
        if (RubyFileTest.file_in_archive(filename2) != null) {
            return runtime2.getTrue();
        }
        return runtime2.newBoolean(RubyFileTest.file(filename2).exists());
    }

    @JRubyMethod(name={"file?"}, required=1, module=true)
    public static RubyBoolean file_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        ZipEntry entry = RubyFileTest.file_in_archive(filename2);
        if (entry != null) {
            return entry.isDirectory() ? recv2.getRuntime().getFalse() : recv2.getRuntime().getTrue();
        }
        JRubyFile file2 = RubyFileTest.file(filename2);
        return runtime2.newBoolean(file2.exists() && file2.isFile());
    }

    @JRubyMethod(name={"grpowned?"}, required=1, module=true)
    public static IRubyObject grpowned_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFileTest.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isGroupOwned());
    }

    @JRubyMethod(name={"identical?"}, required=2, module=true)
    public static IRubyObject identical_p(IRubyObject recv2, IRubyObject filename1, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file1 = RubyFileTest.file(filename1);
        JRubyFile file2 = RubyFileTest.file(filename2);
        return runtime2.newBoolean(file1.exists() && file2.exists() && runtime2.getPosix().stat(file1.getAbsolutePath()).isIdentical(runtime2.getPosix().stat(file2.getAbsolutePath())));
    }

    @JRubyMethod(name={"owned?"}, required=1, module=true)
    public static IRubyObject owned_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFileTest.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isOwned());
    }

    @JRubyMethod(name={"pipe?"}, required=1, module=true)
    public static IRubyObject pipe_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFileTest.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isNamedPipe());
    }

    @JRubyMethod(name={"readable?", "readable_real?"}, required=1, module=true)
    public static IRubyObject readable_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        ZipEntry entry = RubyFileTest.file_in_archive(filename2);
        if (entry != null) {
            return entry.isDirectory() ? recv2.getRuntime().getFalse() : recv2.getRuntime().getTrue();
        }
        JRubyFile file2 = RubyFileTest.file(filename2);
        return runtime2.newBoolean(file2.exists() && file2.canRead());
    }

    public static IRubyObject rowned_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFileTest.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isROwned());
    }

    @JRubyMethod(name={"setgid?"}, required=1, module=true)
    public static IRubyObject setgid_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFileTest.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isSetgid());
    }

    @JRubyMethod(name={"setuid?"}, required=1, module=true)
    public static IRubyObject setuid_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFileTest.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isSetuid());
    }

    @JRubyMethod(name={"size"}, required=1, module=true)
    public static IRubyObject size(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        ZipEntry entry = RubyFileTest.file_in_archive(filename2);
        if (entry != null) {
            return runtime2.newFixnum(entry.getSize());
        }
        JRubyFile file2 = RubyFileTest.file(filename2);
        if (!file2.exists()) {
            RubyFileTest.noFileError(filename2);
        }
        return runtime2.newFixnum(file2.length());
    }

    @JRubyMethod(name={"size?"}, required=1, module=true)
    public static IRubyObject size_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        ZipEntry entry = RubyFileTest.file_in_archive(filename2);
        if (entry != null) {
            long size2 = entry.getSize();
            if (size2 > 0L) {
                return runtime2.newFixnum(size2);
            }
            return runtime2.getNil();
        }
        JRubyFile file2 = RubyFileTest.file(filename2);
        if (!file2.exists()) {
            return runtime2.getNil();
        }
        long length2 = file2.length();
        if (length2 > 0L) {
            return runtime2.newFixnum(length2);
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"socket?"}, required=1, module=true)
    public static IRubyObject socket_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFileTest.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isSocket());
    }

    @JRubyMethod(name={"sticky?"}, required=1, module=true)
    public static IRubyObject sticky_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFileTest.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isSticky());
    }

    @JRubyMethod(name={"symlink?"}, required=1, module=true)
    public static RubyBoolean symlink_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFileTest.file(filename2);
        try {
            return runtime2.newBoolean(runtime2.getPosix().lstat(file2.getAbsolutePath()).isSymlink());
        }
        catch (SecurityException re) {
            return runtime2.getFalse();
        }
        catch (RaiseException re) {
            return runtime2.getFalse();
        }
    }

    @JRubyMethod(name={"writable?", "writable_real?"}, required=1, module=true)
    public static RubyBoolean writable_p(IRubyObject recv2, IRubyObject filename2) {
        return filename2.getRuntime().newBoolean(RubyFileTest.file(filename2).canWrite());
    }

    @JRubyMethod(name={"zero?"}, required=1, module=true)
    public static RubyBoolean zero_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        ZipEntry entry = RubyFileTest.file_in_archive(filename2);
        if (entry != null) {
            return runtime2.newBoolean(entry.getSize() == 0L);
        }
        JRubyFile file2 = RubyFileTest.file(filename2);
        return runtime2.newBoolean(file2.exists() && file2.length() == 0L);
    }

    private static JRubyFile file(IRubyObject pathOrFile) {
        Ruby runtime2 = pathOrFile.getRuntime();
        if (pathOrFile instanceof RubyFile) {
            return JRubyFile.create(runtime2.getCurrentDirectory(), ((RubyFile)pathOrFile).getPath());
        }
        RubyString path2 = RubyFile.get_path(runtime2.getCurrentContext(), pathOrFile);
        return JRubyFile.create(runtime2.getCurrentDirectory(), path2.getUnicodeValue());
    }

    private static ZipEntry file_in_archive(IRubyObject path2) {
        Ruby runtime2 = path2.getRuntime();
        if (path2 instanceof RubyFile) {
            return null;
        }
        RubyString pathStr = RubyFile.get_path(runtime2.getCurrentContext(), path2);
        String pathJStr = pathStr.getUnicodeValue();
        if (pathJStr.startsWith("file:")) {
            String file2 = pathJStr.substring(5);
            int bang = file2.indexOf(33);
            if (bang == -1 || bang == file2.length() - 1) {
                return null;
            }
            String jar = file2.substring(0, bang);
            String after = file2.substring(bang + 2);
            try {
                JarFile jf = new JarFile(jar);
                ZipEntry entry = jf.getEntry(after + "/");
                if (entry == null) {
                    entry = jf.getEntry(after);
                }
                return entry;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private static void noFileError(IRubyObject filename2) {
        throw filename2.getRuntime().newErrnoENOENTError("No such file or directory - " + filename2.convertToString());
    }
}

