/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyGC;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"ObjectSpace"})
public class RubyObjectSpace {
    public static RubyModule createObjectSpaceModule(Ruby runtime2) {
        RubyModule objectSpaceModule = runtime2.defineModule("ObjectSpace");
        runtime2.setObjectSpaceModule(objectSpaceModule);
        objectSpaceModule.defineAnnotatedMethods(RubyObjectSpace.class);
        return objectSpaceModule;
    }

    @JRubyMethod(name={"define_finalizer"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject define_finalizer(IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = recv2.getRuntime();
        IRubyObject finalizer = null;
        if (args2.length == 2) {
            finalizer = args2[1];
            if (!finalizer.respondsTo("call")) {
                throw runtime2.newArgumentError("wrong type argument " + finalizer.getType() + " (should be callable)");
            }
        } else {
            finalizer = runtime2.newProc(Block.Type.PROC, block);
        }
        IRubyObject obj = args2[0];
        runtime2.getObjectSpace().addFinalizer(obj, finalizer);
        return runtime2.newArray((IRubyObject)runtime2.newFixnum(runtime2.getSafeLevel()), finalizer);
    }

    @JRubyMethod(name={"undefine_finalizer"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject undefine_finalizer(IRubyObject recv2, IRubyObject arg1, Block block) {
        recv2.getRuntime().getObjectSpace().removeFinalizers(RubyNumeric.fix2long(arg1.id()));
        return recv2;
    }

    @JRubyMethod(name={"_id2ref"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject id2ref(IRubyObject recv2, IRubyObject id2) {
        Ruby runtime2 = id2.getRuntime();
        if (!(id2 instanceof RubyFixnum)) {
            throw recv2.getRuntime().newTypeError(id2, recv2.getRuntime().getFixnum());
        }
        RubyFixnum idFixnum = (RubyFixnum)id2;
        long longId = idFixnum.getLongValue();
        if (longId == 0L) {
            return runtime2.getFalse();
        }
        if (longId == 2L) {
            return runtime2.getTrue();
        }
        if (longId == 4L) {
            return runtime2.getNil();
        }
        if (longId % 2L != 0L) {
            return runtime2.newFixnum((longId - 1L) / 2L);
        }
        IRubyObject object = runtime2.getObjectSpace().id2ref(longId);
        if (object == null) {
            return runtime2.getNil();
        }
        return object;
    }

    public static IRubyObject each_object(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyModule rubyClass;
        if (args2.length == 0) {
            rubyClass = recv2.getRuntime().getObject();
        } else {
            if (!(args2[0] instanceof RubyModule)) {
                throw recv2.getRuntime().newTypeError("class or module required");
            }
            rubyClass = (RubyModule)args2[0];
        }
        Ruby runtime2 = recv2.getRuntime();
        int count2 = 0;
        if (rubyClass != runtime2.getClassClass()) {
            if (!runtime2.isObjectSpaceEnabled()) {
                throw runtime2.newRuntimeError("ObjectSpace is disabled; each_object will only work with Class, pass -X+O to enable");
            }
            Iterator iter = recv2.getRuntime().getObjectSpace().iterator(rubyClass);
            IRubyObject obj = null;
            while ((obj = (IRubyObject)iter.next()) != null) {
                ++count2;
                block.yield(context, obj);
            }
        } else {
            for (IRubyObject obj : runtime2.getObject().subclasses(true)) {
                if (obj instanceof RubyClass && ((RubyClass)obj).isIncluded()) continue;
                ++count2;
                block.yield(context, obj);
            }
        }
        return recv2.getRuntime().newFixnum(count2);
    }

    @JRubyMethod(name={"each_object"}, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject each_object19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyObjectSpace.each_object(context, recv2, args2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), recv2, "each_object", args2);
    }

    @JRubyMethod(name={"garbage_collect"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject garbage_collect(IRubyObject recv2) {
        return RubyGC.start(recv2);
    }
}

